/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPair;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.Pair;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.TaggedSocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class HybridReducerClientEC<C extends RingElem<C>>
implements Runnable {
    private static final Logger logger = Logger.getLogger(HybridReducerClientEC.class);
    public final boolean debug = logger.isDebugEnabled();
    private final TaggedSocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    private final int threadsPerNode;
    public final Integer pairTag = GroebnerBaseDistributedHybrid.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybrid.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybrid.ackTag;

    HybridReducerClientEC(int tpn, TaggedSocketChannel tc, Integer tid, DistHashTable<Integer, GenPolynomial<C>> dl) {
        this.threadsPerNode = tpn;
        this.pairChannel = tc;
        this.theList = dl;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        if (this.debug) {
            logger.info((Object)("pairChannel   = " + this.pairChannel + " reducer client running"));
        }
        Pair pair = null;
        GenPolynomial<C> H = null;
        boolean goon = true;
        boolean doEnd = true;
        int reduction = 0;
        while (goon) {
            GBTransportMessReq req = new GBTransportMessReq();
            logger.debug((Object)"send request");
            try {
                this.pairChannel.send(this.pairTag, req);
            }
            catch (IOException e) {
                goon = false;
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                logger.info((Object)"receive pair, IOexception ");
                break;
            }
            logger.debug((Object)("receive pair, goon = " + goon));
            doEnd = true;
            Object pp = null;
            try {
                pp = this.pairChannel.receive(this.pairTag);
            }
            catch (InterruptedException e) {
                goon = false;
                e.printStackTrace();
            }
            catch (IOException e) {
                goon = false;
                if (!logger.isDebugEnabled()) break;
                e.printStackTrace();
                break;
            }
            catch (ClassNotFoundException e) {
                goon = false;
                e.printStackTrace();
            }
            if (this.debug) {
                logger.info((Object)("received pair = " + pp));
            }
            H = null;
            if (pp == null) continue;
            if (pp instanceof GBTransportMessEnd) {
                goon = false;
                continue;
            }
            if (pp instanceof GBTransportMessPair || pp instanceof GBTransportMessPairIndex) {
                GenPolynomial<C> ps = null;
                GenPolynomial<C> pj = null;
                GenPolynomial<C> pi = null;
                if (pp instanceof GBTransportMessPair) {
                    GBTransportMessPair tmp = (GBTransportMessPair)pp;
                    pair = tmp.pair;
                    if (pair != null) {
                        pi = pair.pi;
                        pj = pair.pj;
                    }
                }
                if (pp instanceof GBTransportMessPairIndex) {
                    GBTransportMessPairIndex tmpi = (GBTransportMessPairIndex)pp;
                    Integer pix = tmpi.i;
                    Integer pjx = tmpi.j;
                    Integer psx = tmpi.s;
                    pi = this.theList.getWait(pix);
                    pj = this.theList.getWait(pjx);
                    ps = this.theList.getWait(psx);
                }
                if (pi != null && pj != null) {
                    GenPolynomial S = this.red.SPolynomial(pi, pj);
                    if (!S.isZERO()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
                        }
                        H = this.red.normalform(this.theList, S);
                        ++reduction;
                        if (!H.isZERO()) {
                            H = H.monic();
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("ht(H) = " + H.leadingExpVector()));
                            }
                        }
                    }
                } else {
                    logger.info((Object)("pi = " + pi + ", pj = " + pj + ", ps = " + ps));
                }
            }
            if (pp instanceof GBTransportMess) {
                logger.debug((Object)"null pair results in null H poly");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("#distributed list = " + this.theList.size()));
                logger.debug((Object)("send H polynomial = " + H));
            }
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessPoly(H));
                doEnd = false;
            }
            catch (IOException e) {
                goon = false;
                e.printStackTrace();
            }
            try {
                pp = this.pairChannel.receive(this.ackTag);
            }
            catch (InterruptedException e) {
                goon = false;
                e.printStackTrace();
            }
            catch (IOException e) {
                goon = false;
                if (!logger.isDebugEnabled()) break;
                e.printStackTrace();
                break;
            }
            catch (ClassNotFoundException e) {
                goon = false;
                e.printStackTrace();
            }
            if (!(pp instanceof GBTransportMess)) {
                logger.error((Object)("invalid acknowledgement " + pp));
            }
            logger.info((Object)"received acknowledgment ");
        }
        logger.info((Object)("terminated, " + reduction + " reductions, " + this.theList.size() + " polynomials"));
        if (doEnd) {
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessEnd());
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.debug((Object)"terminated, send done");
        }
    }
}

