/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.structure.Power;
import java.math.MathContext;

public class Roots {
    public static BigInteger root(BigInteger A, int n) {
        BigInteger P;
        if (n == 1) {
            return A;
        }
        if (n == 2) {
            return Roots.sqrt(A);
        }
        if (n < 1) {
            throw new IllegalArgumentException("negative root not defined");
        }
        if (A == null || A.isZERO() || A.isONE()) {
            return A;
        }
        int s = A.val.bitLength() + 2;
        MathContext mc = new MathContext(s);
        BigDecimal Ap = new BigDecimal(A.val, mc);
        BigDecimal Ar = Roots.root(Ap, n);
        java.math.BigInteger RP = Ar.val.toBigInteger();
        BigInteger R = new BigInteger(RP);
        while (A.compareTo(P = Power.positivePower(R, n)) < 0) {
            R = R.subtract(BigInteger.ONE);
        }
        return R;
    }

    public static BigInteger sqrt(BigInteger A) {
        BigInteger P;
        if (A == null || A.isZERO() || A.isONE()) {
            return A;
        }
        int s = A.val.bitLength() + 2;
        MathContext mc = new MathContext(s);
        BigDecimal Ap = new BigDecimal(A.val, mc);
        BigDecimal Ar = Roots.sqrt(Ap);
        java.math.BigInteger RP = Ar.val.toBigInteger();
        BigInteger R = new BigInteger(RP);
        while (A.compareTo(P = R.multiply(R)) < 0) {
            R = R.subtract(BigInteger.ONE);
        }
        return R;
    }

    public static BigInteger sqrtInt(BigInteger A) {
        BigInteger R1;
        BigInteger R;
        if (A == null || A.isZERO() || A.isONE()) {
            return A;
        }
        int s = A.signum();
        if (s < 0) {
            throw new ArithmeticException("root of negative not defined");
        }
        if (s == 0) {
            return A;
        }
        int log2 = A.val.bitLength();
        int rootlog2 = log2 - log2 / 2;
        BigInteger d = R = new BigInteger(A.val.shiftRight(rootlog2));
        while (!d.isZERO()) {
            d = new BigInteger(d.val.shiftRight(1));
            R1 = R.sum(d);
            s = A.compareTo(R1.multiply(R1));
            if (s == 0) {
                return R1;
            }
            if (s <= 0) continue;
            R = R1;
        }
        do {
            if ((s = A.compareTo((R1 = R.sum(BigInteger.ONE)).multiply(R1))) == 0) {
                return R1;
            }
            if (s <= 0) continue;
            R = R1;
        } while (s >= 0);
        return R;
    }

    public static BigDecimal sqrt(BigDecimal A) {
        BigDecimal d;
        if (A == null || A.isZERO() || A.isONE()) {
            return A;
        }
        if (A.val.compareTo(BigDecimal.ONE.val) < 0) {
            BigDecimal Ap = A.inverse();
            Ap = Roots.sqrt(Ap);
            return Ap.inverse();
        }
        MathContext mc = A.context;
        BigDecimal Ap = new BigDecimal(A.val, mc);
        BigDecimal ninv = new BigDecimal(0.5, mc);
        BigDecimal R = Ap.multiply(ninv);
        do {
            BigDecimal R1 = R.sum(Ap.divide(R));
            R1 = R1.multiply(ninv);
            d = R.subtract(R1).abs();
            R = R1;
        } while (d.val.compareTo(BigDecimal.ONE.val) > 0);
        return R;
    }

    public static BigDecimal root(BigDecimal A, int n) {
        BigDecimal d;
        if (n == 1) {
            return A;
        }
        if (n == 2) {
            return Roots.sqrt(A);
        }
        if (n < 1) {
            throw new IllegalArgumentException("negative root not defined");
        }
        if (A == null || A.isZERO() || A.isONE()) {
            return A;
        }
        if (A.val.compareTo(BigDecimal.ONE.val) < 0) {
            BigDecimal Ap = A.inverse();
            Ap = Roots.root(Ap, n);
            return Ap.inverse();
        }
        MathContext mc = A.context;
        BigDecimal Ap = A;
        BigDecimal N = new BigDecimal(n, mc);
        BigDecimal ninv = new BigDecimal(1.0 / (double)n, mc);
        BigDecimal nsub = new BigDecimal(1.0, mc);
        nsub = nsub.subtract(ninv);
        BigDecimal half = new BigDecimal(BigDecimal.ONE.val.divide(java.math.BigDecimal.TEN));
        BigDecimal R = Ap.multiply(ninv);
        do {
            BigDecimal P = Power.positivePower(R, n - 1);
            BigDecimal R1 = Ap.divide(P.multiply(N));
            R1 = R.multiply(nsub).sum(R1);
            d = R.subtract(R1).abs();
            R = R1;
        } while (d.val.compareTo(half.val) > 0);
        return R;
    }
}

