/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class BigOctonion
implements StarRingElem<BigOctonion>,
GcdRingElem<BigOctonion>,
RingFactory<BigOctonion> {
    public final BigQuaternion or;
    public final BigQuaternion oi;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(BigOctonion.class);
    private final boolean debug = logger.isDebugEnabled();
    public static final BigOctonion ZERO = new BigOctonion();
    public static final BigOctonion ONE = new BigOctonion(BigQuaternion.ONE);
    public static final BigOctonion I = new BigOctonion(BigQuaternion.ZERO, BigQuaternion.ONE);

    public BigOctonion(BigQuaternion r, BigQuaternion i) {
        this.or = r;
        this.oi = i;
    }

    public BigOctonion(BigQuaternion r) {
        this(r, BigQuaternion.ZERO);
    }

    public BigOctonion(BigComplex r) {
        this(new BigQuaternion(r));
    }

    public BigOctonion(BigRational r) {
        this(new BigQuaternion(r));
    }

    public BigOctonion(long r) {
        this(new BigQuaternion(r));
    }

    public BigOctonion() {
        this(BigQuaternion.ZERO);
    }

    public BigOctonion(String s) throws NumberFormatException {
        if (s == null || s.length() == 0) {
            this.or = BigOctonion.ZERO.or;
            this.oi = BigOctonion.ZERO.oi;
            return;
        }
        int o = (s = s.trim()).indexOf("o");
        if (o == -1) {
            this.or = new BigQuaternion(s);
            this.oi = BigOctonion.ZERO.oi;
            return;
        }
        String sr = s.substring(0, o - 1);
        String so = s.substring(o + 1, s.length());
        this.or = new BigQuaternion(sr.trim());
        this.oi = new BigQuaternion(so.trim());
    }

    public BigOctonion factory() {
        return this;
    }

    @Override
    public List<BigOctonion> generators() {
        List<BigQuaternion> qg = this.or.generators();
        ArrayList<BigOctonion> g = new ArrayList<BigOctonion>(qg.size() * 2);
        for (BigQuaternion q : qg) {
            g.add(new BigOctonion(q));
        }
        for (BigQuaternion q : qg) {
            g.add(new BigOctonion(BigQuaternion.ZERO, q));
        }
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigOctonion copy() {
        return new BigOctonion(this.or, this.oi);
    }

    @Override
    public BigOctonion copy(BigOctonion c) {
        if (c == null) {
            return new BigOctonion();
        }
        return new BigOctonion(c.or, c.oi);
    }

    @Override
    public BigOctonion getZERO() {
        return ZERO;
    }

    @Override
    public BigOctonion getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigOctonion fromInteger(BigInteger a) {
        return new BigOctonion(BigOctonion.ONE.or.fromInteger(a));
    }

    @Override
    public BigOctonion fromInteger(long a) {
        return new BigOctonion(BigOctonion.ONE.or.fromInteger(a));
    }

    public BigQuaternion getR() {
        return this.or;
    }

    public BigQuaternion getI() {
        return this.oi;
    }

    public String toString() {
        String s = "" + this.or;
        int i = this.oi.compareTo(BigQuaternion.ZERO);
        if (this.debug) {
            logger.debug((Object)("compareTo " + i + " ? 0 = " + this.oi));
        }
        if (i == 0) {
            return s;
        }
        s = s + "o" + this.oi;
        return s;
    }

    @Override
    public String toScript() {
        boolean i = this.oi.isZERO();
        if (i && this.or.isZERO()) {
            return "0 ";
        }
        StringBuffer s = new StringBuffer();
        if (!this.or.isZERO()) {
            String rs = this.or.toScript();
            rs = rs.replaceAll("Q", "OR");
            s.append(rs);
            s.append(" ");
        }
        if (!i) {
            if (s.length() > 0) {
                s.append("+ ");
            }
            String is = this.oi.toScript();
            is = is.replaceAll("Q", "OI");
            s.append(is);
        }
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return "Oct()";
    }

    public static boolean isOZERO(BigOctonion A) {
        if (A == null) {
            return false;
        }
        return A.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.or.equals(BigQuaternion.ZERO) && this.oi.equals(BigQuaternion.ZERO);
    }

    public static boolean isOONE(BigOctonion A) {
        if (A == null) {
            return false;
        }
        return A.isONE();
    }

    @Override
    public boolean isONE() {
        return this.or.equals(BigQuaternion.ONE) && this.oi.equals(BigQuaternion.ZERO);
    }

    public boolean isIMAG() {
        return this.or.equals(BigQuaternion.ZERO) && this.oi.equals(BigQuaternion.ONE);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigOctonion)) {
            return false;
        }
        BigOctonion B = (BigOctonion)b;
        return this.or.equals(B.or) && this.oi.equals(B.oi);
    }

    @Override
    public int hashCode() {
        int h = 41 * this.or.hashCode();
        return h += 41 * this.oi.hashCode();
    }

    @Override
    public int compareTo(BigOctonion b) {
        int s = this.or.compareTo(b.or);
        if (s != 0) {
            return s;
        }
        return this.oi.compareTo(b.oi);
    }

    @Override
    public int signum() {
        int s = this.or.signum();
        if (s != 0) {
            return s;
        }
        return this.oi.signum();
    }

    @Override
    public BigOctonion sum(BigOctonion B) {
        return new BigOctonion(this.or.sum(B.or), this.oi.sum(B.oi));
    }

    public static BigOctonion OSUM(BigOctonion A, BigOctonion B) {
        if (A == null) {
            return null;
        }
        return A.sum(B);
    }

    public static BigOctonion ODIF(BigOctonion A, BigOctonion B) {
        if (A == null) {
            return null;
        }
        return A.subtract(B);
    }

    @Override
    public BigOctonion subtract(BigOctonion B) {
        return new BigOctonion(this.or.subtract(B.or), this.oi.subtract(B.oi));
    }

    public static BigOctonion ONEG(BigOctonion A) {
        if (A == null) {
            return null;
        }
        return A.negate();
    }

    @Override
    public BigOctonion negate() {
        return new BigOctonion(this.or.negate(), this.oi.negate());
    }

    public static BigOctonion OCON(BigOctonion A) {
        if (A == null) {
            return null;
        }
        return A.conjugate();
    }

    @Override
    public BigOctonion conjugate() {
        return new BigOctonion(this.or.conjugate(), this.oi.negate());
    }

    @Override
    public BigOctonion norm() {
        BigQuaternion v = this.or.norm();
        v = v.sum(this.oi.norm());
        return new BigOctonion(v);
    }

    @Override
    public BigOctonion abs() {
        BigOctonion n = this.norm();
        logger.error((Object)"abs() square root missing");
        return n;
    }

    public static BigRational OABS(BigOctonion A) {
        if (A == null) {
            return null;
        }
        return A.abs().or.re;
    }

    public static BigOctonion OPROD(BigOctonion A, BigOctonion B) {
        if (A == null) {
            return null;
        }
        return A.multiply(B);
    }

    @Override
    public BigOctonion multiply(BigOctonion B) {
        BigQuaternion r = this.or.multiply(B.or);
        r = r.subtract(B.oi.multiply(this.oi.conjugate()));
        BigQuaternion i = this.or.conjugate().multiply(B.oi);
        i = i.sum(B.or.multiply(this.oi));
        return new BigOctonion(r, i);
    }

    public static BigOctonion OINV(BigOctonion A) {
        if (A == null) {
            return null;
        }
        return A.inverse();
    }

    @Override
    public BigOctonion inverse() {
        BigRational a = this.norm().or.re;
        return this.conjugate().divide(a);
    }

    @Override
    public BigOctonion remainder(BigOctonion S) {
        if (S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public static BigOctonion OQ(BigOctonion A, BigOctonion B) {
        if (A == null) {
            return null;
        }
        return A.divide(B);
    }

    @Override
    public BigOctonion divide(BigOctonion b) {
        return this.multiply(b.inverse());
    }

    @Override
    public BigOctonion divide(BigRational b) {
        return new BigOctonion(this.or.divide(b), this.oi.divide(b));
    }

    public BigOctonion[] quotientRemainder(BigOctonion S) {
        return new BigOctonion[]{this.divide(S), ZERO};
    }

    @Override
    public BigOctonion random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigOctonion random(int n, Random rnd) {
        BigQuaternion rr = BigQuaternion.ONE.random(n, rnd);
        BigQuaternion ir = BigQuaternion.ONE.random(n, rnd);
        return new BigOctonion(rr, ir);
    }

    public static BigOctonion ORAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigOctonion parse(String s) {
        return new BigOctonion(s);
    }

    @Override
    public BigOctonion parse(Reader r) {
        return this.parse(StringUtil.nextString(r));
    }

    @Override
    public BigOctonion gcd(BigOctonion S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        return ONE;
    }

    public BigOctonion[] egcd(BigOctonion S) {
        BigOctonion[] ret = new BigOctonion[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        BigOctonion half = new BigOctonion(new BigRational(1L, 2L));
        ret[0] = ONE;
        ret[1] = this.inverse().multiply(half);
        ret[2] = S.inverse().multiply(half);
        return ret;
    }
}

