/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;

public class Residue<C extends GcdRingElem<C>>
implements GcdRingElem<Residue<C>> {
    public final ResidueRing<C> ring;
    public final GenPolynomial<C> val;
    protected int isunit = -1;

    public Residue(ResidueRing<C> r) {
        this(r, (GenPolynomial<C>)r.ring.getZERO(), 0);
    }

    public Residue(ResidueRing<C> r, GenPolynomial<C> a) {
        this(r, a, -1);
    }

    public Residue(ResidueRing<C> r, GenPolynomial<C> a, int u) {
        this.ring = r;
        this.val = this.ring.ideal.normalform(a);
        if (u == 0 || u == 1) {
            this.isunit = u;
            return;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
            return;
        }
        if (this.val.isUnit()) {
            this.isunit = 1;
        }
        this.isunit = -1;
    }

    @Override
    public ResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public Residue<C> copy() {
        return new Residue<C>(this.ring, this.val, this.isunit);
    }

    @Override
    public boolean isZERO() {
        return this.val.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.val.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        boolean u = this.ring.ideal.isUnit(this.val);
        this.isunit = u ? 1 : 0;
        return u;
    }

    public boolean isConstant() {
        return this.val.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return this.val.toString(this.ring.ring.getVars());
        }
        return "Residue[ " + this.val.toString() + " mod " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return this.val.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((ResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Residue<C> b) {
        GenPolynomial<C> v = b.val;
        if (!this.ring.equals(b.ring)) {
            v = this.ring.ideal.normalform(v);
        }
        return this.val.compareTo(v);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Residue)) {
            return false;
        }
        Residue a = null;
        try {
            a = (Residue)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.val.hashCode();
        return h;
    }

    @Override
    public Residue<C> abs() {
        return new Residue<C>(this.ring, this.val.abs(), this.isunit);
    }

    @Override
    public Residue<C> sum(Residue<C> S) {
        return new Residue<GenPolynomial<C>>(this.ring, this.val.sum(S.val));
    }

    @Override
    public Residue<C> negate() {
        return new Residue<C>(this.ring, this.val.negate(), this.isunit);
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public Residue<C> subtract(Residue<C> S) {
        return new Residue<GenPolynomial<C>>(this.ring, this.val.subtract(S.val));
    }

    @Override
    public Residue<C> divide(Residue<C> S) {
        if (this.ring.isField()) {
            return this.multiply((Residue<C>)S.inverse());
        }
        GenPolynomial<C> x = PolyUtil.basePseudoDivide(this.val, S.val);
        return new Residue<C>(this.ring, x);
    }

    @Override
    public Residue<C> inverse() {
        GenPolynomial x = this.ring.ideal.inverse(this.val);
        return new Residue<C>(this.ring, x, 1);
    }

    @Override
    public Residue<C> remainder(Residue<C> S) {
        GenPolynomial<C> x = PolyUtil.baseSparsePseudoRemainder(this.val, S.val);
        return new Residue<C>(this.ring, x);
    }

    @Override
    public Residue<C> multiply(Residue<C> S) {
        GenPolynomial<GenPolynomial<C>> x = this.val.multiply(S.val);
        int i = -1;
        if (this.isunit == 1 && S.isunit == 1) {
            i = 1;
        } else if (this.isunit == 0 || S.isunit == 0) {
            i = 0;
        }
        return new Residue<GenPolynomial<C>>(this.ring, x, i);
    }

    public Residue<C> monic() {
        return new Residue<C>(this.ring, this.val.monic(), this.isunit);
    }

    @Override
    public Residue<C> gcd(Residue<C> b) {
        GenPolynomial x = this.ring.engine.gcd(this.val, b.val);
        int i = -1;
        if (x.isONE()) {
            i = 1;
        } else {
            System.out.println("Residue gcd = " + x);
        }
        if (this.isunit == 1 && b.isunit == 1) {
            i = 1;
        }
        return new Residue<C>(this.ring, x, i);
    }

    public Residue<C>[] egcd(Residue<C> b) {
        throw new UnsupportedOperationException("egcd not implemented");
    }
}

