/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GBOptimized;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.OrderedMinPairlist;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.PairList;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBaseFGLM;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.gbufd.GroebnerBaseRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.QuotientRing;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class GBAlgorithmBuilder<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(GBAlgorithmBuilder.class);
    private GroebnerBaseAbstract<C> algo;
    public final GenPolynomialRing<C> ring;
    public final PairList<C> strategy;

    protected GBAlgorithmBuilder() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public GBAlgorithmBuilder(GenPolynomialRing<C> ring) {
        this(ring, null);
    }

    public GBAlgorithmBuilder(GenPolynomialRing<C> ring, GroebnerBaseAbstract<C> algo) {
        this(ring, algo, null);
    }

    public GBAlgorithmBuilder(GenPolynomialRing<C> ring, GroebnerBaseAbstract<C> algo, PairList<C> strategy) {
        if (ring == null) {
            throw new IllegalArgumentException("ring may not be null");
        }
        this.ring = ring;
        this.algo = algo;
        if (strategy == null) {
            strategy = new OrderedPairlist();
        }
        this.strategy = strategy;
    }

    public GroebnerBaseAbstract<C> build() {
        if (this.algo == null) {
            this.algo = this.strategy == null ? GBFactory.getImplementation(this.ring.coFac) : GBFactory.getImplementation(this.ring.coFac, this.strategy);
        }
        return this.algo;
    }

    public static <C extends GcdRingElem<C>> GBAlgorithmBuilder<C> polynomialRing(GenPolynomialRing<C> fac) {
        return new GBAlgorithmBuilder<C>(fac);
    }

    public GBAlgorithmBuilder<C> syzygyPairlist() {
        return new GBAlgorithmBuilder<C>(this.ring, this.algo, new OrderedSyzPairlist());
    }

    public GBAlgorithmBuilder<C> normalPairlist() {
        return new GBAlgorithmBuilder<C>(this.ring, this.algo, new OrderedPairlist());
    }

    public GBAlgorithmBuilder<C> simplePairlist() {
        return new GBAlgorithmBuilder<C>(this.ring, this.algo, new OrderedMinPairlist());
    }

    public GBAlgorithmBuilder<C> optimize() {
        return this.optimize(true);
    }

    public GBAlgorithmBuilder<C> optimize(boolean rP) {
        if (this.algo == null) {
            this.algo = GBFactory.getImplementation(this.ring.coFac, this.strategy);
        }
        GBOptimized<C> bb = new GBOptimized<C>(this.algo, rP);
        return new GBAlgorithmBuilder<C>(this.ring, bb);
    }

    public GBAlgorithmBuilder<C> fractionFree() {
        if (this.algo != null) {
            logger.warn((Object)("selected algorithm ignored: " + this.algo + ", use fractionFree before"));
        }
        if (this.ring.coFac instanceof BigRational) {
            GroebnerBaseAbstract<BigRational> bb;
            BigRational cf = (BigRational)this.ring.coFac;
            PairList<BigRational> sty = this.strategy;
            GroebnerBaseAbstract<BigRational> cbb = bb = GBFactory.getImplementation(cf, GBFactory.Algo.ffgb, sty);
            return new GBAlgorithmBuilder<BigRational>(this.ring, cbb);
        }
        if (this.ring.coFac instanceof QuotientRing) {
            GroebnerBaseAbstract bb;
            QuotientRing cf = (QuotientRing)this.ring.coFac;
            PairList sty = this.strategy;
            GroebnerBaseAbstract cbb = bb = GBFactory.getImplementation(cf, GBFactory.Algo.ffgb, sty);
            return new GBAlgorithmBuilder(this.ring, cbb);
        }
        logger.warn((Object)("no fraction free algorithm implemented for " + this.ring));
        return this;
    }

    public GBAlgorithmBuilder<C> euclideanDomain() {
        return this.domainAlgorithm(GBFactory.Algo.egb);
    }

    public GBAlgorithmBuilder<C> domainAlgorithm(GBFactory.Algo a) {
        if (this.ring.coFac instanceof BigInteger) {
            GroebnerBaseAbstract<BigInteger> bb;
            BigInteger cf = (BigInteger)this.ring.coFac;
            GroebnerBaseAbstract<BigInteger> cbb = bb = GBFactory.getImplementation(cf, a);
            return new GBAlgorithmBuilder<BigInteger>(this.ring, cbb);
        }
        logger.warn((Object)("no domain algorithm implemented for " + this.ring));
        return this;
    }

    public GBAlgorithmBuilder<C> parallel() {
        return this.parallel(ComputerThreads.N_CPUS);
    }

    public GBAlgorithmBuilder<C> parallel(int threads) {
        if (ComputerThreads.NO_THREADS) {
            logger.warn((Object)"parallel algorithms disabled");
            return this;
        }
        if (this.algo == null) {
            this.algo = GBFactory.getImplementation(this.ring.coFac, this.strategy);
        }
        if (this.ring.coFac instanceof BigRational) {
            GroebnerBaseAbstract bb = this.algo instanceof GroebnerBaseRational ? new GroebnerBaseRational(threads) : new GroebnerBaseParallel<C>(threads, this.strategy);
            GBProxy<BigRational> pbb = new GBProxy<BigRational>(this.algo, bb);
            return new GBAlgorithmBuilder<BigRational>(this.ring, pbb);
        }
        if (this.ring.coFac.isField()) {
            GroebnerBaseParallel<C> bb = new GroebnerBaseParallel<C>(threads, this.strategy);
            GBProxy<C> pbb = new GBProxy<C>(this.algo, bb);
            return new GBAlgorithmBuilder<C>(this.ring, pbb);
        }
        if (this.ring.coFac.getONE() instanceof GcdRingElem) {
            GroebnerBasePseudoParallel bb = new GroebnerBasePseudoParallel(threads, this.ring.coFac, this.strategy);
            GBProxy<C> pbb = new GBProxy<C>(this.algo, bb);
            return new GBAlgorithmBuilder<C>(this.ring, pbb);
        }
        logger.warn((Object)("no parallel algorithm implemented for " + this.ring));
        return this;
    }

    public GBAlgorithmBuilder<C> graded() {
        if (this.ring.coFac.isField()) {
            GroebnerBaseFGLM bb = this.algo == null ? new GroebnerBaseFGLM() : new GroebnerBaseFGLM<C>(this.algo);
            return new GBAlgorithmBuilder<C>(this.ring, bb);
        }
        logger.warn((Object)("no FGLM algorithm implemented for " + this.ring));
        return this;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(" ");
        if (this.algo != null) {
            s.append(this.algo.toString());
            s.append(" for ");
        }
        s.append(this.ring.toString());
        return s.toString();
    }

    public String toScript() {
        StringBuffer s = new StringBuffer(" ");
        if (this.algo != null) {
            s.append(this.algo.toString());
            s.append(" ");
        }
        s.append(this.ring.toScript());
        return s.toString();
    }
}

