/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.PolyUtilApp;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class EvaluateToComplexReal<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<GenPolynomial<Complex<C>>, Complex<RealAlgebraicNumber<C>>> {
    protected final GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> pfac;
    protected final ComplexRing<RealAlgebraicNumber<C>> cfac;
    protected final Complex<RealAlgebraicNumber<C>> root;

    public EvaluateToComplexReal(GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> fac, Complex<RealAlgebraicNumber<C>> r) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        if (r == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        this.pfac = fac;
        this.cfac = (ComplexRing)fac.coFac;
        this.root = r;
    }

    @Override
    public Complex<RealAlgebraicNumber<C>> eval(GenPolynomial<Complex<C>> c) {
        if (c == null) {
            return this.cfac.getZERO();
        }
        GenPolynomial<Complex<RealAlgebraicNumber<C>>> cp = PolyUtilApp.convertToComplexRealCoefficients(this.pfac, c);
        Complex<RealAlgebraicNumber<C>> cr = PolyUtil.evaluateMain(this.cfac, cp, this.root);
        return cr;
    }
}

