/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.DrawListener;
import edu.princeton.cs.algs4.StdDraw;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class Draw
implements ActionListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;
    public static final Color BOOK_BLUE = new Color(9, 90, 166);
    public static final Color BOOK_LIGHT_BLUE = new Color(103, 198, 243);
    public static final Color BOOK_RED = new Color(150, 35, 31);
    public static final Color PRINCETON_ORANGE = new Color(245, 128, 37);
    private static final Color DEFAULT_PEN_COLOR = BLACK;
    private static final Color DEFAULT_CLEAR_COLOR = WHITE;
    private static final double BORDER = 0.0;
    private static final double DEFAULT_XMIN = 0.0;
    private static final double DEFAULT_XMAX = 1.0;
    private static final double DEFAULT_YMIN = 0.0;
    private static final double DEFAULT_YMAX = 1.0;
    private static final int DEFAULT_SIZE = 512;
    private static final double DEFAULT_PEN_RADIUS = 0.002;
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 16);
    private Color penColor;
    private int width = 512;
    private int height = 512;
    private double penRadius;
    private boolean defer = false;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private String name = "Draw";
    private final Object mouseLock = new Object();
    private final Object keyLock = new Object();
    private Font font;
    private JLabel draw;
    private BufferedImage offscreenImage;
    private BufferedImage onscreenImage;
    private Graphics2D offscreen;
    private Graphics2D onscreen;
    private JFrame frame = new JFrame();
    private boolean isMousePressed = false;
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private final LinkedList<Character> keysTyped = new LinkedList();
    private final TreeSet<Integer> keysDown = new TreeSet();
    private final ArrayList<DrawListener> listeners = new ArrayList();

    public Draw(String name) {
        this.name = name;
        this.init();
    }

    public Draw() {
        this.init();
    }

    private void init() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.frame = new JFrame();
        this.offscreenImage = new BufferedImage(this.width, this.height, 2);
        this.onscreenImage = new BufferedImage(this.width, this.height, 2);
        this.offscreen = this.offscreenImage.createGraphics();
        this.onscreen = this.onscreenImage.createGraphics();
        this.setXscale();
        this.setYscale();
        this.offscreen.setColor(DEFAULT_CLEAR_COLOR);
        this.offscreen.fillRect(0, 0, this.width, this.height);
        this.setPenColor();
        this.setPenRadius();
        this.setFont();
        this.clear();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.offscreen.addRenderingHints(hints);
        ImageIcon icon = new ImageIcon(this.onscreenImage);
        this.draw = new JLabel(icon);
        this.draw.addMouseListener(this);
        this.draw.addMouseMotionListener(this);
        this.frame.setContentPane(this.draw);
        this.frame.addKeyListener(this);
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle(this.name);
        this.frame.setJMenuBar(this.createMenuBar());
        this.frame.pack();
        this.frame.requestFocusInWindow();
        this.frame.setVisible(true);
    }

    public void setLocationOnScreen(int x, int y) {
        if (x <= 0 || y <= 0) {
            throw new IllegalArgumentException();
        }
        this.frame.setLocation(x, y);
    }

    public void setDefaultCloseOperation(int value) {
        this.frame.setDefaultCloseOperation(value);
    }

    public void setCanvasSize(int canvasWidth, int canvasHeight) {
        if (canvasWidth < 1 || canvasHeight < 1) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        this.width = canvasWidth;
        this.height = canvasHeight;
        this.init();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem menuItem1 = new JMenuItem(" Save...   ");
        menuItem1.addActionListener(this);
        menuItem1.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem1);
        return menuBar;
    }

    public void setXscale() {
        this.setXscale(0.0, 1.0);
    }

    public void setYscale() {
        this.setYscale(0.0, 1.0);
    }

    public void setXscale(double min, double max) {
        double size = max - min;
        this.xmin = min - 0.0 * size;
        this.xmax = max + 0.0 * size;
    }

    public void setYscale(double min, double max) {
        double size = max - min;
        this.ymin = min - 0.0 * size;
        this.ymax = max + 0.0 * size;
    }

    private double scaleX(double x) {
        return (double)this.width * (x - this.xmin) / (this.xmax - this.xmin);
    }

    private double scaleY(double y) {
        return (double)this.height * (this.ymax - y) / (this.ymax - this.ymin);
    }

    private double factorX(double w) {
        return w * (double)this.width / Math.abs(this.xmax - this.xmin);
    }

    private double factorY(double h) {
        return h * (double)this.height / Math.abs(this.ymax - this.ymin);
    }

    private double userX(double x) {
        return this.xmin + x * (this.xmax - this.xmin) / (double)this.width;
    }

    private double userY(double y) {
        return this.ymax - y * (this.ymax - this.ymin) / (double)this.height;
    }

    public void clear() {
        this.clear(DEFAULT_CLEAR_COLOR);
    }

    public void clear(Color color) {
        this.offscreen.setColor(color);
        this.offscreen.fillRect(0, 0, this.width, this.height);
        this.offscreen.setColor(this.penColor);
        this.draw();
    }

    public double getPenRadius() {
        return this.penRadius;
    }

    public void setPenRadius() {
        this.setPenRadius(0.002);
    }

    public void setPenRadius(double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException("pen radius must be positive");
        }
        this.penRadius = r * 512.0;
        BasicStroke stroke = new BasicStroke((float)this.penRadius, 1, 1);
        this.offscreen.setStroke(stroke);
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor() {
        this.setPenColor(DEFAULT_PEN_COLOR);
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.offscreen.setColor(this.penColor);
    }

    public void setPenColor(int red, int green, int blue) {
        if (red < 0 || red >= 256) {
            throw new IllegalArgumentException("amount of red must be between 0 and 255");
        }
        if (green < 0 || green >= 256) {
            throw new IllegalArgumentException("amount of red must be between 0 and 255");
        }
        if (blue < 0 || blue >= 256) {
            throw new IllegalArgumentException("amount of red must be between 0 and 255");
        }
        this.setPenColor(new Color(red, green, blue));
    }

    public void xorOn() {
        this.offscreen.setXORMode(DEFAULT_CLEAR_COLOR);
    }

    public void xorOff() {
        this.offscreen.setPaintMode();
    }

    public JLabel getJLabel() {
        return this.draw;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont() {
        this.setFont(DEFAULT_FONT);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void line(double x0, double y0, double x1, double y1) {
        this.offscreen.draw(new Line2D.Double(this.scaleX(x0), this.scaleY(y0), this.scaleX(x1), this.scaleY(y1)));
        this.draw();
    }

    private void pixel(double x, double y) {
        this.offscreen.fillRect((int)Math.round(this.scaleX(x)), (int)Math.round(this.scaleY(y)), 1, 1);
    }

    public void point(double x, double y) {
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double r = this.penRadius;
        if (r <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.fill(new Ellipse2D.Double(xs - r / 2.0, ys - r / 2.0, r, r));
        }
        this.draw();
    }

    public void circle(double x, double y, double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException("circle radius can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * r);
        double hs = this.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.draw(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void filledCircle(double x, double y, double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException("circle radius can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * r);
        double hs = this.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.fill(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void ellipse(double x, double y, double semiMajorAxis, double semiMinorAxis) {
        if (semiMajorAxis < 0.0) {
            throw new IllegalArgumentException("ellipse semimajor axis can't be negative");
        }
        if (semiMinorAxis < 0.0) {
            throw new IllegalArgumentException("ellipse semiminor axis can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * semiMajorAxis);
        double hs = this.factorY(2.0 * semiMinorAxis);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.draw(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void filledEllipse(double x, double y, double semiMajorAxis, double semiMinorAxis) {
        if (semiMajorAxis < 0.0) {
            throw new IllegalArgumentException("ellipse semimajor axis can't be negative");
        }
        if (semiMinorAxis < 0.0) {
            throw new IllegalArgumentException("ellipse semiminor axis can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * semiMajorAxis);
        double hs = this.factorY(2.0 * semiMinorAxis);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.fill(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void arc(double x, double y, double r, double angle1, double angle2) {
        if (r < 0.0) {
            throw new IllegalArgumentException("arc radius can't be negative");
        }
        while (angle2 < angle1) {
            angle2 += 360.0;
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * r);
        double hs = this.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.draw(new Arc2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs, angle1, angle2 - angle1, 0));
        }
        this.draw();
    }

    public void square(double x, double y, double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException("square side length can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * r);
        double hs = this.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.draw(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void filledSquare(double x, double y, double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException("square side length can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * r);
        double hs = this.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.fill(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void rectangle(double x, double y, double halfWidth, double halfHeight) {
        if (halfWidth < 0.0) {
            throw new IllegalArgumentException("half width can't be negative");
        }
        if (halfHeight < 0.0) {
            throw new IllegalArgumentException("half height can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * halfWidth);
        double hs = this.factorY(2.0 * halfHeight);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.draw(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void filledRectangle(double x, double y, double halfWidth, double halfHeight) {
        if (halfWidth < 0.0) {
            throw new IllegalArgumentException("half width can't be negative");
        }
        if (halfHeight < 0.0) {
            throw new IllegalArgumentException("half height can't be negative");
        }
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(2.0 * halfWidth);
        double hs = this.factorY(2.0 * halfHeight);
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.fill(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        this.draw();
    }

    public void polygon(double[] x, double[] y) {
        int n = x.length;
        GeneralPath path = new GeneralPath();
        path.moveTo((float)this.scaleX(x[0]), (float)this.scaleY(y[0]));
        for (int i = 0; i < n; ++i) {
            path.lineTo((float)this.scaleX(x[i]), (float)this.scaleY(y[i]));
        }
        path.closePath();
        this.offscreen.draw(path);
        this.draw();
    }

    public void filledPolygon(double[] x, double[] y) {
        int n = x.length;
        GeneralPath path = new GeneralPath();
        path.moveTo((float)this.scaleX(x[0]), (float)this.scaleY(y[0]));
        for (int i = 0; i < n; ++i) {
            path.lineTo((float)this.scaleX(x[i]), (float)this.scaleY(y[i]));
        }
        path.closePath();
        this.offscreen.fill(path);
        this.draw();
    }

    private static BufferedImage getImage(String filename) {
        try {
            URL url = new URL(filename);
            return ImageIO.read(url);
        }
        catch (IOException url) {
            try {
                URL url2 = StdDraw.class.getResource(filename);
                return ImageIO.read(url2);
            }
            catch (IOException url2) {
                try {
                    URL url3 = StdDraw.class.getResource("/" + filename);
                    return ImageIO.read(url3);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("image " + filename + " not found");
                }
            }
        }
    }

    public void picture(double x, double y, String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename argument is null");
        }
        BufferedImage image = Draw.getImage(filename);
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        int ws = image.getWidth();
        int hs = image.getHeight();
        if (ws < 0 || hs < 0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        this.offscreen.drawImage((Image)image, (int)Math.round(xs - (double)ws / 2.0), (int)Math.round(ys - (double)hs / 2.0), null);
        this.draw();
    }

    public void picture(double x, double y, String filename, double degrees) {
        if (filename == null) {
            throw new IllegalArgumentException("filename argument is null");
        }
        BufferedImage image = Draw.getImage(filename);
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        int ws = image.getWidth();
        int hs = image.getHeight();
        if (ws < 0 || hs < 0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        this.offscreen.rotate(Math.toRadians(-degrees), xs, ys);
        this.offscreen.drawImage((Image)image, (int)Math.round(xs - (double)ws / 2.0), (int)Math.round(ys - (double)hs / 2.0), null);
        this.offscreen.rotate(Math.toRadians(degrees), xs, ys);
        this.draw();
    }

    public void picture(double x, double y, String filename, double w, double h) {
        if (filename == null) {
            throw new IllegalArgumentException("filename argument is null");
        }
        BufferedImage image = Draw.getImage(filename);
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(w);
        double hs = this.factorY(h);
        if (ws < 0.0 || hs < 0.0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        } else {
            this.offscreen.drawImage(image, (int)Math.round(xs - ws / 2.0), (int)Math.round(ys - hs / 2.0), (int)Math.round(ws), (int)Math.round(hs), null);
        }
        this.draw();
    }

    public void picture(double x, double y, String filename, double w, double h, double degrees) {
        if (filename == null) {
            throw new IllegalArgumentException("filename argument is null");
        }
        BufferedImage image = Draw.getImage(filename);
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        double ws = this.factorX(w);
        double hs = this.factorY(h);
        if (ws < 0.0 || hs < 0.0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        if (ws <= 1.0 && hs <= 1.0) {
            this.pixel(x, y);
        }
        this.offscreen.rotate(Math.toRadians(-degrees), xs, ys);
        this.offscreen.drawImage(image, (int)Math.round(xs - ws / 2.0), (int)Math.round(ys - hs / 2.0), (int)Math.round(ws), (int)Math.round(hs), null);
        this.offscreen.rotate(Math.toRadians(degrees), xs, ys);
        this.draw();
    }

    public void text(double x, double y, String s) {
        this.offscreen.setFont(this.font);
        FontMetrics metrics = this.offscreen.getFontMetrics();
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        int ws = metrics.stringWidth(s);
        int hs = metrics.getDescent();
        this.offscreen.drawString(s, (float)(xs - (double)ws / 2.0), (float)(ys + (double)hs));
        this.draw();
    }

    public void text(double x, double y, String s, double degrees) {
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        this.offscreen.rotate(Math.toRadians(-degrees), xs, ys);
        this.text(x, y, s);
        this.offscreen.rotate(Math.toRadians(degrees), xs, ys);
    }

    public void textLeft(double x, double y, String s) {
        this.offscreen.setFont(this.font);
        FontMetrics metrics = this.offscreen.getFontMetrics();
        double xs = this.scaleX(x);
        double ys = this.scaleY(y);
        int hs = metrics.getDescent();
        this.offscreen.drawString(s, (float)xs, (float)(ys + (double)hs));
        this.draw();
    }

    @Deprecated
    public void show(int t) {
        this.show();
        this.pause(t);
        this.enableDoubleBuffering();
    }

    public void pause(int t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            System.out.println("Error sleeping");
        }
    }

    public void show() {
        this.onscreen.drawImage((Image)this.offscreenImage, 0, 0, null);
        this.frame.repaint();
    }

    private void draw() {
        if (!this.defer) {
            this.show();
        }
    }

    public void enableDoubleBuffering() {
        this.defer = true;
    }

    public void disableDoubleBuffering() {
        this.defer = false;
    }

    public void save(String filename) {
        File file = new File(filename);
        String suffix = filename.substring(filename.lastIndexOf(46) + 1);
        if ("png".equalsIgnoreCase(suffix)) {
            try {
                ImageIO.write((RenderedImage)this.offscreenImage, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if ("jpg".equalsIgnoreCase(suffix)) {
            WritableRaster raster = this.offscreenImage.getRaster();
            WritableRaster newRaster = raster.createWritableChild(0, 0, this.width, this.height, 0, 0, new int[]{0, 1, 2});
            DirectColorModel cm = (DirectColorModel)this.offscreenImage.getColorModel();
            DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
            BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
            try {
                ImageIO.write((RenderedImage)rgbBuffer, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Invalid image file type: " + suffix);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileDialog chooser = new FileDialog((Frame)this.frame, "Use a .png or .jpg extension", 1);
        chooser.setVisible(true);
        String filename = chooser.getFile();
        if (filename != null) {
            this.save(chooser.getDirectory() + File.separator + chooser.getFile());
        }
    }

    public void addListener(DrawListener listener) {
        this.show();
        this.listeners.add(listener);
        this.frame.addKeyListener(this);
        this.frame.addMouseListener(this);
        this.frame.addMouseMotionListener(this);
        this.frame.setFocusable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMousePressed() {
        Object object = this.mouseLock;
        synchronized (object) {
            return this.isMousePressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean mousePressed() {
        Object object = this.mouseLock;
        synchronized (object) {
            return this.isMousePressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double mouseX() {
        Object object = this.mouseLock;
        synchronized (object) {
            return this.mouseX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double mouseY() {
        Object object = this.mouseLock;
        synchronized (object) {
            return this.mouseY;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        Iterator<DrawListener> iterator = this.mouseLock;
        synchronized (iterator) {
            this.mouseX = this.userX(e.getX());
            this.mouseY = this.userY(e.getY());
            this.isMousePressed = true;
        }
        if (e.getButton() == 1) {
            for (DrawListener listener : this.listeners) {
                listener.mousePressed(this.userX(e.getX()), this.userY(e.getY()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        Iterator<DrawListener> iterator = this.mouseLock;
        synchronized (iterator) {
            this.isMousePressed = false;
        }
        if (e.getButton() == 1) {
            for (DrawListener listener : this.listeners) {
                listener.mouseReleased(this.userX(e.getX()), this.userY(e.getY()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        Iterator<DrawListener> iterator = this.mouseLock;
        synchronized (iterator) {
            this.mouseX = this.userX(e.getX());
            this.mouseY = this.userY(e.getY());
        }
        for (DrawListener listener : this.listeners) {
            listener.mouseDragged(this.userX(e.getX()), this.userY(e.getY()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e) {
        Object object = this.mouseLock;
        synchronized (object) {
            this.mouseX = this.userX(e.getX());
            this.mouseY = this.userY(e.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextKeyTyped() {
        Object object = this.keyLock;
        synchronized (object) {
            return !this.keysTyped.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char nextKeyTyped() {
        Object object = this.keyLock;
        synchronized (object) {
            return this.keysTyped.removeLast().charValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeyPressed(int keycode) {
        Object object = this.keyLock;
        synchronized (object) {
            return this.keysDown.contains(keycode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent e) {
        Iterator<DrawListener> iterator = this.keyLock;
        synchronized (iterator) {
            this.keysTyped.addFirst(Character.valueOf(e.getKeyChar()));
        }
        for (DrawListener listener : this.listeners) {
            listener.keyTyped(e.getKeyChar());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        Iterator<DrawListener> iterator = this.keyLock;
        synchronized (iterator) {
            this.keysDown.add(e.getKeyCode());
        }
        for (DrawListener listener : this.listeners) {
            listener.keyPressed(e.getKeyCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        Iterator<DrawListener> iterator = this.keyLock;
        synchronized (iterator) {
            this.keysDown.remove(e.getKeyCode());
        }
        for (DrawListener listener : this.listeners) {
            listener.keyPressed(e.getKeyCode());
        }
    }

    public static void main(String[] args) {
        Draw draw1 = new Draw("Test client 1");
        draw1.square(0.2, 0.8, 0.1);
        draw1.filledSquare(0.8, 0.8, 0.2);
        draw1.circle(0.8, 0.2, 0.2);
        draw1.setPenColor(MAGENTA);
        draw1.setPenRadius(0.02);
        draw1.arc(0.8, 0.2, 0.1, 200.0, 45.0);
        Draw draw2 = new Draw("Test client 2");
        draw2.setCanvasSize(900, 200);
        draw2.setPenRadius();
        draw2.setPenColor(BLUE);
        double[] x = new double[]{0.1, 0.2, 0.3, 0.2};
        double[] y = new double[]{0.2, 0.3, 0.2, 0.1};
        draw2.filledPolygon(x, y);
        draw2.setPenColor(BLACK);
        draw2.text(0.2, 0.5, "bdfdfdfdlack text");
        draw2.setPenColor(WHITE);
        draw2.text(0.8, 0.8, "white text");
    }
}

