/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.CircleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FixedCircleObject;
import carmetal.objects.PointObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class SetFixedCircle
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    FixedCircleObject C;
    PointObject P1;
    PointObject P2;

    public SetFixedCircle(ZirkelCanvas zc, FixedCircleObject c2, ObjectConstructor oc) {
        this.C = c2;
        this.OC = oc;
        c2.setSelected(true);
        zc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P1 == null) {
            ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
            if (o == null) {
                return;
            }
            if (o instanceof PointObject) {
                this.P1 = (PointObject)o;
                this.P1.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
                return;
            }
            this.C.setFixed(o.getName());
            this.C.setDragable(false);
            this.C.updateText();
            this.reset(zc);
        } else {
            this.P2 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P2 == null) {
                return;
            }
            this.C.setFixed("d(" + this.P1.getName() + "," + this.P2.getName() + ")");
            this.reset(zc);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Global.name("message.setfixedcircle.first"));
        } else {
            zc.showStatus(Global.name("message.setfixedcircle.second"));
        }
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        this.showStatus(zc);
        zc.repaint();
        zc.check();
    }

    @Override
    public boolean useSmartBoard() {
        return this.P1 != null;
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return (o instanceof PointObject || o instanceof SegmentObject || o instanceof FixedCircleObject || o instanceof CircleObject || o instanceof ExpressionObject) && !zc.getConstruction().dependsOn(o, this.C);
    }
}

