/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.constructors.ObjectConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.tools.ReorderDialog;
import java.awt.event.MouseEvent;

public class ReorderTool
extends ObjectConstructor {
    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        zc.y(e2.getY());
        ConstructionObject o = zc.selectObject(e2.getX(), e2.getY());
        if (o == null) {
            return;
        }
        ReorderDialog d2 = new ReorderDialog(zc, o);
        if (!d2.isAborted()) {
            String name = d2.getResult();
            if (!name.equals("")) {
                ConstructionObject u = zc.getConstruction().find(name);
                if (u == null) {
                    zc.warning(Global.name("reorder.notfound"));
                    return;
                }
                if (!zc.getConstruction().reorder(o, u)) {
                    zc.warning(Global.name("reorder.warning"));
                }
            } else if (!zc.getConstruction().reorder(o, null)) {
                zc.warning(Global.name("reorder.warning"));
            }
        }
        zc.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateObjects(e2.getX(), e2.getY());
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.reorder", "Reorder: Select an object!"));
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

