/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.graphics;

import carmetal.objects.FunctionObject;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.structures.Coordinates;
import java.util.Enumeration;
import java.util.Vector;

public class FunctionPolygonFiller {
    MyGraphics G;
    FunctionObject O;
    Vector V;
    double Ymin;
    double Ymax;
    boolean cartesian = true;

    public FunctionPolygonFiller(MyGraphics g, FunctionObject o, double ymin, double ymax) {
        this.G = g;
        this.O = o;
        this.Ymin = ymin - 100.0;
        this.Ymax = ymax + 100.0;
        this.cartesian = this.O.isCartesian();
        this.V = new Vector();
    }

    public void add(double c2, double r) {
        double r0 = r;
        if (r > this.Ymax) {
            r0 = this.Ymax;
        } else if (r < this.Ymin) {
            r0 = this.Ymin;
        }
        this.V.add(new Coordinates(c2, r0));
    }

    public void fillPolygon(double origin) {
        int bord = this.cartesian ? 2 : 0;
        int nx = this.V.size() + bord;
        if (nx > bord) {
            Coordinates c2;
            double[] x = new double[nx];
            double[] y = new double[nx];
            Enumeration e2 = this.V.elements();
            int i = 0;
            if (e2.hasMoreElements()) {
                c2 = (Coordinates)e2.nextElement();
                if (this.cartesian) {
                    x[i] = c2.X;
                    y[i++] = origin;
                    x[i] = c2.X;
                    y[i++] = c2.Y;
                } else {
                    x[i] = c2.X;
                    y[i++] = c2.Y;
                }
            }
            while (e2.hasMoreElements()) {
                c2 = (Coordinates)e2.nextElement();
                x[i] = c2.X;
                y[i++] = c2.Y;
            }
            if (this.cartesian) {
                x[i] = x[i - 1];
                y[i] = origin;
            }
            this.G.fillPolygon(x, y, nx, false, true, this.O);
            this.V.removeAllElements();
        }
    }
}

