/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.expression.BasicExpression;
import carmetal.rene.zirkel.expression.ExpressionText;
import carmetal.rene.zirkel.expression.FunctionExpression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.expression.ObjectExpression;
import carmetal.rene.zirkel.expression.Translator;

class FindObjectExpression
extends ObjectExpression
implements Translator {
    String Name;
    String Var = null;
    Construction C;
    ConstructionObject O = null;

    public FindObjectExpression(String name, Construction c2) {
        super(null);
        this.Name = name;
        this.C = c2;
    }

    @Override
    public ConstructionObject getObject() {
        if (this.C == null) {
            return null;
        }
        if (this.O != null && this.O.getConstruction() == this.C && this.O.isInConstruction() && this.O.getName().equals(this.Name)) {
            return this.O;
        }
        this.O = this.C.find(this.Name);
        return this.O;
    }

    @Override
    public double getValue() throws ConstructionException {
        if (this.C == null) {
            throw new InvalidException("");
        }
        if (this.O != null && this.O.getConstruction() == this.C && this.O.isInConstruction() && this.O.getName().equals(this.Name)) {
            return this.O.getValue();
        }
        this.O = this.C.find(this.Name);
        if (this.O == null) {
            throw new InvalidException("");
        }
        return this.O.getValue();
    }

    public static BasicExpression scan(ExpressionText t, boolean quotes) throws ConstructionException {
        char c2;
        if (!quotes && t.next() == '\"') {
            t.advance();
            BasicExpression E = FindObjectExpression.scan(t, true);
            if (t.next() != '\"') {
                throw new ConstructionException(Global.name("exception.quotes"));
            }
            t.advance();
            return E;
        }
        StringBuffer b2 = new StringBuffer();
        while (Character.isLetterOrDigit(c2 = t.next(quotes)) || c2 == '\\' || c2 == '\'' || quotes && c2 != '\"' && c2 != '\u0000' || quotes && c2 == ' ') {
            b2.append(c2);
            t.advance(quotes);
        }
        if (!quotes && t.next() == '(') {
            return FunctionExpression.scan(t, b2.toString());
        }
        String s = b2.toString();
        return new FindObjectExpression(s, t.getConstruction());
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        return FindObjectExpression.scan(t, false);
    }

    @Override
    public void translate() {
        this.C = this.C.getTranslation();
        this.C.addTranslator(this);
    }

    @Override
    public String toString() {
        if (this.Var != null) {
            return this.Var;
        }
        return "@" + ObjectExpression.quote(this.Name);
    }

    @Override
    public void laterTranslate(Construction from) {
        if (this.C == null) {
            return;
        }
        ConstructionObject o = from.find(this.Name);
        if (o == null || o.getTranslation() == null) {
            from.addError(ConstructionObject.text1(Global.name("warning.macrodefinition"), this.Name));
            return;
        }
        this.Name = o.getTranslation().getName();
        this.O = null;
    }
}

