/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.expression.BasicExpression;
import carmetal.rene.zirkel.expression.ExpressionText;

class DoubleExpression
extends BasicExpression {
    double X;

    public DoubleExpression(double x) {
        this.X = x;
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        boolean Punkt = false;
        boolean Digit = false;
        boolean Expo = false;
        String num = "";
        char c2 = t.next();
        if (c2 == '+' || c2 == '-') {
            num = num + c2;
            t.advance();
        }
        while (true) {
            if ((c2 = t.next()) >= '0' && c2 <= '9') {
                num = num + c2;
                t.advance();
                Digit = true;
                continue;
            }
            if (c2 == '.') {
                if (Punkt) {
                    throw new ConstructionException(Global.name("exception.dot"));
                }
                Punkt = true;
                num = num + c2;
                t.advance();
                continue;
            }
            if (!Digit || c2 != 'E') break;
            if (Expo) {
                throw new ConstructionException("Exponential notation error");
            }
            Expo = true;
            num = num + c2;
            t.advance();
            c2 = t.next();
            if (c2 != '+' && c2 != '-') continue;
            num = num + c2;
            t.advance();
        }
        if (!Digit) {
            throw new ConstructionException(Global.name("exception.nodigit"));
        }
        return new DoubleExpression(Double.valueOf(num));
    }

    @Override
    public double getValue() throws ConstructionException {
        return this.X;
    }

    public String toString() {
        String s = "" + this.X;
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    @Override
    public void translate() {
    }

    @Override
    public boolean isNumber() {
        return true;
    }
}

