/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.objects.Evaluator;

public class ConvexMin {
    public static double computeMin(Evaluator F, double a2, double b2, double eps) throws ConstructionException {
        double lambda = (Math.sqrt(5.0) - 1.0) / 2.0;
        double x2 = lambda * a2 + (1.0 - lambda) * b2;
        double y2 = F.evaluateF(x2);
        double x3 = (1.0 - lambda) * a2 + lambda * b2;
        double y3 = F.evaluateF(x3);
        while (b2 - a2 > eps) {
            if (y2 < y3) {
                b2 = x3;
                x3 = x2;
                y3 = y2;
                x2 = lambda * a2 + (1.0 - lambda) * b2;
                y2 = F.evaluateF(x2);
                continue;
            }
            a2 = x2;
            x2 = x3;
            y2 = y3;
            x3 = (1.0 - lambda) * a2 + lambda * b2;
            y3 = F.evaluateF(x3);
        }
        return (a2 + b2) / 2.0;
    }

    public static double computeMax(Evaluator F, double a2, double b2, double eps) throws ConstructionException {
        double lambda = (Math.sqrt(5.0) - 1.0) / 2.0;
        double x2 = lambda * a2 + (1.0 - lambda) * b2;
        double y2 = F.evaluateF(x2);
        double x3 = (1.0 - lambda) * a2 + lambda * b2;
        double y3 = F.evaluateF(x3);
        while (b2 - a2 > eps) {
            if (y2 > y3) {
                b2 = x3;
                x3 = x2;
                y3 = y2;
                x2 = lambda * a2 + (1.0 - lambda) * b2;
                y2 = F.evaluateF(x2);
                continue;
            }
            a2 = x2;
            x2 = x3;
            y2 = y3;
            x3 = (1.0 - lambda) * a2 + lambda * b2;
            y3 = F.evaluateF(x3);
        }
        return (a2 + b2) / 2.0;
    }
}

