/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.dialogs;

import carmetal.construction.Construction;
import carmetal.objects.ConstructionObject;
import carmetal.objects.TextObject;
import carmetal.rene.gui.CloseDialog;
import carmetal.rene.gui.Global;
import carmetal.rene.gui.IconBarListener;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;

public class Replay
extends CloseDialog
implements IconBarListener {
    private static final long serialVersionUID = 1L;
    ZirkelCanvas ZC;
    int Last;
    Construction C;
    Vector V;
    boolean HaveBreaks;
    ConstructionObject O = null;

    public Replay(Frame f2, ZirkelCanvas zc) {
        super(f2, Global.name("replay.title"), true);
        this.ZC = zc;
        this.C = this.ZC.getConstruction();
        this.V = new Vector();
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.mustHide(this.ZC) && !o.isBreakHide() && (!(o instanceof TextObject) || !o.valid() || o.isSuperHidden())) continue;
            this.V.addElement(o);
        }
        this.HaveBreaks = this.haveBreaks();
        this.Last = 0;
        this.setLast();
        this.setEnabled(true);
        this.pack();
    }

    public void newHistory() {
        this.V.clear();
        this.C = this.ZC.getConstruction();
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.mustHide(this.ZC) && !o.isBreakHide() && (!(o instanceof TextObject) || !o.valid() || o.isSuperHidden())) continue;
            this.V.addElement(o);
        }
        this.HaveBreaks = this.haveBreaks();
    }

    @Override
    public void iconPressed(String o) {
        if (o.equals("close")) {
            this.doclose();
        } else if (o.equals("allback")) {
            this.Last = 0;
            this.setLast();
        } else if (o.equals("allforward")) {
            this.Last = this.V.size();
            this.setLast();
        } else if (o.equals("fastback")) {
            this.Last -= 10;
            if (this.Last < 0) {
                this.Last = 0;
            }
            this.setLast();
        } else if (o.equals("fastforward")) {
            this.Last += 10;
            if (this.Last > this.V.size()) {
                this.Last = this.V.size();
            }
            this.setLast();
        } else if (o.equals("oneforward")) {
            ++this.Last;
            if (this.Last > this.V.size()) {
                this.Last = this.V.size();
            }
            this.setLast();
        } else if (o.equals("nextbreak")) {
            do {
                ++this.Last;
                if (this.Last <= this.V.size()) continue;
                this.Last = this.V.size();
                break;
            } while (this.Last < this.V.size() && (this.Last <= 0 || !((ConstructionObject)this.V.elementAt(this.Last)).isBreak()));
            this.setLast();
        } else if (o.equals("setbreak")) {
            if (this.Last > 0) {
                ConstructionObject ob;
                ob.setBreak(!(ob = (ConstructionObject)this.V.elementAt(this.Last)).isBreak());
                if (ob.isBreak()) {
                    ob.setHideBreak(true);
                }
            }
            this.HaveBreaks = this.haveBreaks();
        } else if (o.equals("oneback")) {
            --this.Last;
            if (this.Last < 0) {
                this.Last = 0;
            }
            this.setLast();
        }
        this.start();
    }

    public void start() {
    }

    @Override
    public void doclose() {
        this.ZC.paintUntil(null);
        this.ZC.showStatus();
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof TextObject)) continue;
            ((TextObject)o).setDoShow(false);
        }
        this.ZC.repaint();
        super.doclose();
    }

    public void checkLast() {
        if (this.O != null) {
            ((TextObject)this.O).setDoShow(false);
        }
        this.O = null;
        if (this.Last > this.V.size() - 1) {
            return;
        }
        this.O = (ConstructionObject)this.V.elementAt(this.Last);
        if (this.O != null && this.O instanceof TextObject) {
            ((TextObject)this.O).setDoShow(true);
        } else {
            this.O = null;
        }
    }

    public void setLast() {
        ConstructionObject o;
        if (this.Last < this.V.size()) {
            o = (ConstructionObject)this.V.elementAt(this.Last);
            this.checkLast();
            this.ZC.paintUntil(o);
        } else {
            this.Last = this.V.size();
            this.checkLast();
            this.ZC.paintUntil(null);
        }
        if (this.Last >= 0 && this.Last < this.V.size()) {
            o = (ConstructionObject)this.V.elementAt(this.Last);
            this.ZC.showStatus(o.getName() + " : " + o.getText());
        }
    }

    public boolean haveBreaks() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            if (!((ConstructionObject)e2.nextElement()).isBreak()) continue;
            return true;
        }
        return false;
    }
}

