/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.gui;

import carmetal.rene.gui.Global;
import carmetal.rene.gui.Keyboard;
import carmetal.rene.gui.KeyboardInterface;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyboardController
implements KeyListener {
    boolean Escape = false;
    boolean IgnoreTyped = false;
    int CommandType = 0;
    Component C = null;
    KeyboardInterface Primary = null;
    KeyboardInterface Secondary = null;
    boolean scaled = false;
    long scale;

    @Override
    public synchronized void keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 16) {
            return;
        }
        if (e2.getKeyCode() == 17) {
            return;
        }
        if (e2.getKeyCode() == 18) {
            return;
        }
        if (this.old(e2)) {
            return;
        }
        String s = Keyboard.findKey(e2, this.CommandType);
        this.IgnoreTyped = false;
        if (s.startsWith("command.")) {
            if (s.equals("command.escape")) {
                this.Escape = !this.Escape;
            } else {
                try {
                    this.CommandType = Integer.parseInt(s.substring(8));
                    this.Escape = false;
                }
                catch (Exception ex) {
                    this.CommandType = 0;
                }
            }
            this.IgnoreTyped = true;
        } else if (s.startsWith("charkey.")) {
            this.keyboardCommand(e2, s);
            this.IgnoreTyped = true;
            this.Escape = false;
            this.CommandType = 0;
        } else if (this.Escape) {
            char c2 = e2.getKeyChar();
            this.IgnoreTyped = true;
            this.keyboardEscape(e2, c2);
            this.Escape = false;
        } else if (!s.equals("")) {
            this.keyboardCommand(e2, s);
            this.IgnoreTyped = false;
            this.Escape = false;
            this.CommandType = 0;
        } else if (!e2.isActionKey()) {
            if (!Global.getParameter("keyboard.compose", true)) {
                this.keyboardChar(e2, e2.getKeyChar());
                this.Escape = false;
                this.CommandType = 0;
            } else {
                this.Escape = false;
                this.CommandType = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        if (!Global.getParameter("keyboard.compose", true)) {
            return;
        }
        if (this.IgnoreTyped) {
            return;
        }
        this.IgnoreTyped = false;
        this.keyboardChar(e2, e2.getKeyChar());
        this.Escape = false;
        this.CommandType = 0;
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }

    public void keyboardCommand(KeyEvent e2, String command) {
        if (!(this.Primary != null && this.Primary.keyboardCommand(e2, command) || this.Secondary == null)) {
            this.Secondary.keyboardCommand(e2, command);
        }
    }

    public void keyboardEscape(KeyEvent e2, char c2) {
        if (!(this.Primary != null && this.Primary.keyboardEscape(e2, c2) || this.Secondary == null)) {
            this.Secondary.keyboardEscape(e2, c2);
        }
    }

    public void keyboardChar(KeyEvent e2, char c2) {
        if (!(this.Primary != null && this.Primary.keyboardChar(e2, c2) || this.Secondary == null)) {
            this.Secondary.keyboardChar(e2, c2);
        }
    }

    boolean old(KeyEvent e2) {
        if (!this.scaled) {
            this.scaled = true;
            this.scale = System.currentTimeMillis() - e2.getWhen();
            return false;
        }
        long delay = System.currentTimeMillis() - e2.getWhen() - this.scale;
        if (delay > 10000L) {
            return false;
        }
        return delay > 200L;
    }

    public void listenTo(Component c2) {
        if (this.C != null) {
            this.C.removeKeyListener(this);
        }
        this.C = c2;
        if (this.C != null) {
            this.C.addKeyListener(this);
        }
    }

    public void setPrimary(KeyboardInterface i) {
        this.Primary = i;
    }

    public void setSecondary(KeyboardInterface i) {
        this.Secondary = i;
    }
}

