/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.gui;

import carmetal.rene.gui.CloseFrame;
import carmetal.rene.gui.DoActionListener;
import carmetal.rene.gui.Global;
import carmetal.rene.gui.HistoryTextFieldChoice;
import carmetal.rene.gui.MenuItemAction;
import carmetal.rene.gui.TextFieldAction;
import carmetal.rene.util.FileName;
import carmetal.rene.util.list.ListClass;
import carmetal.rene.util.list.ListElement;
import java.awt.BorderLayout;
import java.awt.PopupMenu;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class HistoryTextField
extends TextFieldAction
implements KeyListener,
DoActionListener {
    private static final long serialVersionUID = 1L;
    ListClass H = new ListClass();
    PopupMenu M = null;
    boolean Trigger = false;
    public int MaxLength = 48;
    String Last = "";

    public HistoryTextField(DoActionListener l, String name) {
        super(l, name);
        this.H.append(new ListElement(""));
        this.addKeyListener(this);
    }

    public HistoryTextField(DoActionListener l, String name, int s) {
        super(l, name, s);
        this.H.append(new ListElement(""));
        this.addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent ev) {
        switch (ev.getKeyCode()) {
            case 38: 
            case 40: {
                if (this.M == null) {
                    this.M = new PopupMenu();
                    ListElement e2 = this.H.last();
                    int n = Global.getParameter("history.length", 10);
                    for (int i = 0; e2 != null && i < n; e2 = e2.previous(), ++i) {
                        String t = (String)e2.content();
                        if (t.equals("")) continue;
                        MenuItemAction item = new MenuItemAction(this, FileName.chop(t, this.MaxLength), t);
                        this.M.add(item);
                    }
                    this.add(this.M);
                }
                this.M.show(this, 10, 10);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    public void remember(String s) {
        if (s.equals(this.Last)) {
            return;
        }
        this.deleteFromHistory(s);
        this.Last = s;
        this.H.last().content(s);
        this.H.append(new ListElement(""));
        this.M = null;
    }

    public void deleteFromHistory(String s) {
        ListElement e2 = this.H.first();
        while (e2 != null) {
            String t = (String)e2.content();
            ListElement next = e2.next();
            if (t.equals(s)) {
                this.H.remove(e2);
                if (this.H.first() == null) {
                    this.H.append(new ListElement(""));
                }
            }
            e2 = next;
        }
    }

    public void remember() {
        this.remember(this.getText());
    }

    public void saveHistory(String name) {
        ListElement e2;
        int n = Global.getParameter("history.length", 10);
        Global.removeAllParameters("history." + name);
        if (e2 == null) {
            return;
        }
        int i = 0;
        for (e2 = this.H.last(); i < n && e2 != null; e2 = e2.previous()) {
            String s = (String)e2.content();
            if (s.equals("")) continue;
            Global.setParameter("history." + name + "." + ++i, s);
        }
    }

    public void loadHistory(String name) {
        int i = 1;
        this.H = new ListClass();
        this.H.append(new ListElement(""));
        while (Global.haveParameter("history." + name + "." + i)) {
            String s = Global.getParameter("history." + name + "." + i, "");
            if (!s.equals("") && this.filterHistory(s)) {
                this.H.prepend(new ListElement(s));
            }
            ++i;
        }
    }

    public boolean filterHistory(String name) {
        return true;
    }

    public ListClass getHistory() {
        return this.H;
    }

    public void setTrigger(boolean f2) {
        this.Trigger = f2;
    }

    @Override
    public void doAction(String o) {
        if (!o.equals("")) {
            this.setText(o);
            if (this.Trigger) {
                this.triggerAction();
            }
        }
    }

    @Override
    public void itemAction(String o, boolean flag) {
    }

    public static void main(String[] args) {
        CloseFrame f2 = new CloseFrame("test");
        HistoryTextField t = new HistoryTextField((DoActionListener)f2, "Test", 30);
        t.remember("AAAA");
        t.remember("BBBB");
        t.remember("CCCC");
        t.remember("DDDD");
        f2.setLayout(new BorderLayout());
        f2.add("Center", t);
        f2.add("South", new HistoryTextFieldChoice(t));
        f2.pack();
        f2.setVisible(true);
    }
}

