/*
 * Decompiled with CFR 0.152.
 */
package carmetal.org.mozilla.javascript;

import carmetal.org.mozilla.javascript.Callable;
import carmetal.org.mozilla.javascript.Context;
import carmetal.org.mozilla.javascript.IdFunctionObject;
import carmetal.org.mozilla.javascript.IdScriptableObject;
import carmetal.org.mozilla.javascript.NativeArray;
import carmetal.org.mozilla.javascript.ScriptRuntime;
import carmetal.org.mozilla.javascript.Scriptable;
import carmetal.org.mozilla.javascript.ScriptableObject;
import carmetal.org.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptableObject {
    static final long serialVersionUID = -6345305608474346996L;
    private static final Object OBJECT_TAG = "Object";
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int Id___defineGetter__ = 9;
    private static final int Id___defineSetter__ = 10;
    private static final int Id___lookupGetter__ = 11;
    private static final int Id___lookupSetter__ = 12;
    private static final int MAX_PROTOTYPE_ID = 12;

    static void init(Scriptable scope, boolean sealed) {
        NativeObject obj = new NativeObject();
        obj.exportAsJSClass(12, scope, sealed);
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    public String toString() {
        return ScriptRuntime.defaultObjectToString(this);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toLocaleString";
                break;
            }
            case 4: {
                arity = 0;
                s = "valueOf";
                break;
            }
            case 5: {
                arity = 1;
                s = "hasOwnProperty";
                break;
            }
            case 6: {
                arity = 1;
                s = "propertyIsEnumerable";
                break;
            }
            case 7: {
                arity = 1;
                s = "isPrototypeOf";
                break;
            }
            case 8: {
                arity = 0;
                s = "toSource";
                break;
            }
            case 9: {
                arity = 2;
                s = "__defineGetter__";
                break;
            }
            case 10: {
                arity = 2;
                s = "__defineSetter__";
                break;
            }
            case 11: {
                arity = 1;
                s = "__lookupGetter__";
                break;
            }
            case 12: {
                arity = 1;
                s = "__lookupSetter__";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(OBJECT_TAG, id, s, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f2.hasTag(OBJECT_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args);
        }
        int id = f2.methodId();
        switch (id) {
            case 1: {
                if (thisObj != null) {
                    return f2.construct(cx, scope, args);
                }
                if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
                    return new NativeObject();
                }
                return ScriptRuntime.toObject(cx, scope, args[0]);
            }
            case 2: 
            case 3: {
                if (cx.hasFeature(4)) {
                    String s = ScriptRuntime.defaultObjectToSource(cx, scope, thisObj, args);
                    int L = s.length();
                    if (L != 0 && s.charAt(0) == '(' && s.charAt(L - 1) == ')') {
                        s = s.substring(1, L - 1);
                    }
                    return s;
                }
                return ScriptRuntime.defaultObjectToString(thisObj);
            }
            case 4: {
                return thisObj;
            }
            case 5: {
                boolean result;
                if (args.length == 0) {
                    result = false;
                } else {
                    String s = ScriptRuntime.toStringIdOrIndex(cx, args[0]);
                    if (s == null) {
                        int index = ScriptRuntime.lastIndexResult(cx);
                        result = thisObj.has(index, thisObj);
                    } else {
                        result = thisObj.has(s, thisObj);
                    }
                }
                return ScriptRuntime.wrapBoolean(result);
            }
            case 6: {
                boolean result;
                if (args.length == 0) {
                    result = false;
                } else {
                    String s = ScriptRuntime.toStringIdOrIndex(cx, args[0]);
                    if (s == null) {
                        int index = ScriptRuntime.lastIndexResult(cx);
                        result = thisObj.has(index, thisObj);
                        if (result && thisObj instanceof ScriptableObject) {
                            ScriptableObject so = (ScriptableObject)thisObj;
                            int attrs = so.getAttributes(index);
                            result = (attrs & 2) == 0;
                        }
                    } else {
                        result = thisObj.has(s, thisObj);
                        if (result && thisObj instanceof ScriptableObject) {
                            ScriptableObject so = (ScriptableObject)thisObj;
                            int attrs = so.getAttributes(s);
                            result = (attrs & 2) == 0;
                        }
                    }
                }
                return ScriptRuntime.wrapBoolean(result);
            }
            case 7: {
                boolean result = false;
                if (args.length != 0 && args[0] instanceof Scriptable) {
                    Scriptable v = (Scriptable)args[0];
                    do {
                        if ((v = v.getPrototype()) != thisObj) continue;
                        result = true;
                        break;
                    } while (v != null);
                }
                return ScriptRuntime.wrapBoolean(result);
            }
            case 8: {
                return ScriptRuntime.defaultObjectToSource(cx, scope, thisObj, args);
            }
            case 9: 
            case 10: {
                if (args.length < 2 || !(args[1] instanceof Callable)) {
                    Object badArg = args.length >= 2 ? args[1] : Undefined.instance;
                    throw ScriptRuntime.notFunctionError(badArg);
                }
                if (!(thisObj instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", thisObj.getClass().getName(), String.valueOf(args[0]));
                }
                ScriptableObject so = (ScriptableObject)thisObj;
                String name = ScriptRuntime.toStringIdOrIndex(cx, args[0]);
                int index = name != null ? 0 : ScriptRuntime.lastIndexResult(cx);
                Callable getterOrSetter = (Callable)args[1];
                boolean isSetter = id == 10;
                so.setGetterOrSetter(name, index, getterOrSetter, isSetter);
                if (so instanceof NativeArray) {
                    ((NativeArray)so).setDenseOnly(false);
                }
                return Undefined.instance;
            }
            case 11: 
            case 12: {
                Scriptable v;
                Object gs;
                boolean isSetter;
                if (args.length < 1 || !(thisObj instanceof ScriptableObject)) {
                    return Undefined.instance;
                }
                ScriptableObject so = (ScriptableObject)thisObj;
                String name = ScriptRuntime.toStringIdOrIndex(cx, args[0]);
                int index = name != null ? 0 : ScriptRuntime.lastIndexResult(cx);
                boolean bl = isSetter = id == 12;
                while ((gs = so.getGetterOrSetter(name, index, isSetter)) == null && (v = so.getPrototype()) != null && v instanceof ScriptableObject) {
                    so = (ScriptableObject)v;
                }
                if (gs != null) {
                    return gs;
                }
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    protected int findPrototypeId(String s) {
        int id;
        block14: {
            id = 0;
            String X = null;
            switch (s.length()) {
                case 7: {
                    X = "valueOf";
                    id = 4;
                    break;
                }
                case 8: {
                    char c2 = s.charAt(3);
                    if (c2 == 'o') {
                        X = "toSource";
                        id = 8;
                        break;
                    }
                    if (c2 != 't') break;
                    X = "toString";
                    id = 2;
                    break;
                }
                case 11: {
                    X = "constructor";
                    id = 1;
                    break;
                }
                case 13: {
                    X = "isPrototypeOf";
                    id = 7;
                    break;
                }
                case 14: {
                    char c3 = s.charAt(0);
                    if (c3 == 'h') {
                        X = "hasOwnProperty";
                        id = 5;
                        break;
                    }
                    if (c3 != 't') break;
                    X = "toLocaleString";
                    id = 3;
                    break;
                }
                case 16: {
                    char c4 = s.charAt(2);
                    if (c4 == 'd') {
                        c4 = s.charAt(8);
                        if (c4 == 'G') {
                            X = "__defineGetter__";
                            id = 9;
                            break;
                        }
                        if (c4 != 'S') break;
                        X = "__defineSetter__";
                        id = 10;
                        break;
                    }
                    if (c4 != 'l') break;
                    c4 = s.charAt(8);
                    if (c4 == 'G') {
                        X = "__lookupGetter__";
                        id = 11;
                        break;
                    }
                    if (c4 != 'S') break;
                    X = "__lookupSetter__";
                    id = 12;
                    break;
                }
                case 20: {
                    X = "propertyIsEnumerable";
                    id = 6;
                    break;
                }
            }
            if (X == null || X == s || X.equals(s)) break block14;
            id = 0;
        }
        return id;
    }
}

