/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.Count;
import carmetal.objects.ConstructionObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Quartic;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.PolygonDrawer;
import java.awt.Color;
import java.util.Enumeration;

public class QuadricObject
extends ConstructionObject
implements PointonObject,
MoveableObject {
    public PointObject[] P;
    static Count N = new Count();
    public double[] X;
    public static String[] Tags = new String[]{"x^2", "y^2", "x", "y", "xy"};
    double[] xd;
    double[] yd;
    double x1;
    double y1;

    public QuadricObject(Construction c2, PointObject[] p) {
        super(c2);
        this.P = p;
        this.validate();
        this.updateText();
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.circle.shownames", false));
        this.setShowValue(Global.getParameter("options.circle.showvalues", false));
        this.setColor(Global.getParameter("options.circle.color", 0), Global.getParameter("options.circle.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.circle.colortype", 0));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
        this.setPartial(this.Cn.Partial);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.circle.shownames", false));
        this.setShowValue(Global.getParameter("options.circle.showvalues", false));
        this.setColor(Global.getParameter("options.circle.color", 0), Global.getParameter("options.circle.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.circle.colortype", 0));
    }

    @Override
    public String getTag() {
        return "Quadric";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        try {
            String[] Names = new String[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                Names[i] = this.P[i].getName();
            }
            this.setText(QuadricObject.textAny(Global.name("text.quadric"), Names));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void validate() {
        int i;
        for (int i2 = 0; i2 < this.P.length; ++i2) {
            if (this.P[i2].valid()) continue;
            this.Valid = false;
            return;
        }
        this.Valid = true;
        double[][] A = new double[5][6];
        for (int i3 = 0; i3 < 5; ++i3) {
            int j;
            double x = this.P[i3].getX();
            double y = this.P[i3].getY();
            A[i3][0] = x * x;
            A[i3][1] = y * y;
            A[i3][2] = x;
            A[i3][3] = y;
            A[i3][4] = x * y;
            A[i3][5] = 1.0;
            double sum = 0.0;
            for (j = 0; j < 6; ++j) {
                sum += A[i3][j] * A[i3][j];
            }
            sum = Math.sqrt(sum);
            j = 0;
            while (j < 6) {
                double[] dArray = A[i3];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        int r = 0;
        int[] colindex = new int[6];
        for (int c2 = 0; c2 < 6; ++c2) {
            int i4;
            if (r >= 5) {
                colindex[c2] = -1;
                continue;
            }
            double max = Math.abs(A[r][c2]);
            int imax = r;
            for (i4 = r + 1; i4 < 5; ++i4) {
                double h = Math.abs(A[i4][c2]);
                if (!(h > max)) continue;
                max = h;
                imax = i4;
            }
            if (max > 1.0E-13) {
                if (imax != r) {
                    double[] h = A[imax];
                    A[imax] = A[r];
                    A[r] = h;
                }
                for (i4 = r + 1; i4 < 5; ++i4) {
                    double lambda = A[i4][c2] / A[r][c2];
                    for (int j = c2 + 1; j < 6; ++j) {
                        double[] dArray = A[i4];
                        int n = j;
                        dArray[n] = dArray[n] - lambda * A[r][j];
                    }
                }
                colindex[c2] = r++;
                continue;
            }
            colindex[c2] = -1;
        }
        this.X = new double[6];
        for (int j = 5; j >= 0; --j) {
            if (colindex[j] < 0) {
                this.X[j] = 1.0;
                continue;
            }
            double h = 0.0;
            int i5 = colindex[j];
            for (int k = j + 1; k < 6; ++k) {
                h += A[i5][k] * this.X[k];
            }
            this.X[j] = -h / A[i5][j];
        }
        double sum = 0.0;
        for (i = 0; i <= 5; ++i) {
            sum += Math.abs(this.X[i]);
        }
        if (sum < 1.0E-10) {
            this.Valid = false;
        }
        i = 0;
        while (i <= 5) {
            int n = i++;
            this.X[n] = this.X[n] / sum;
        }
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        double r;
        double c2;
        double start;
        double x;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        g.setColor(this);
        double end = zc.maxX();
        double h = zc.dx(1);
        boolean valid = false;
        boolean ptext = false;
        double c0 = 0.0;
        double r0 = 0.0;
        double ctext = 20.0;
        double rtext = 20.0;
        PolygonDrawer pd = new PolygonDrawer(g, this);
        for (x = start = zc.minX(); x <= end; x += h) {
            try {
                double y = this.computeLower(x);
                c2 = zc.col(x);
                r = zc.row(y);
                if (valid) {
                    pd.drawTo(c2, r);
                    if (!ptext && r0 - r > c2 - c0 && zc.isInside(x, y)) {
                        ctext = c2;
                        rtext = r;
                        ptext = true;
                    }
                } else {
                    pd.startPolygon(c2, r);
                }
                c0 = c2;
                r0 = r;
                valid = true;
                continue;
            }
            catch (RuntimeException e2) {
                valid = false;
            }
        }
        pd.finishPolygon();
        valid = false;
        for (x = start - 2.0 * h; x <= end + 2.0 * h; x += h) {
            try {
                double y = this.computeUpper(x);
                c2 = zc.col(x);
                r = zc.row(y);
                if (valid) {
                    pd.drawTo(c2, r);
                    if (!ptext && r0 - r > c2 - c0 && zc.isInside(x, y)) {
                        ctext = c2;
                        rtext = r;
                        ptext = true;
                    }
                } else {
                    try {
                        double y1 = this.computeLower(x);
                        if (x >= start - h && x <= end + h) {
                            g.drawLine(c2, zc.row(y1), c2, r, this);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    pd.startPolygon(c2, r);
                }
                c0 = c2;
                r0 = r;
                valid = true;
                continue;
            }
            catch (RuntimeException e3) {
                if (valid) {
                    try {
                        double y1 = this.computeLower(x - h);
                        if (x - h >= start - h && x - h <= end + h) {
                            g.drawLine(c0, zc.row(y1), c0, r0, this);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                valid = false;
            }
        }
        pd.finishPolygon();
        String s = this.getDisplayText();
        if (!s.equals("")) {
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            this.TX1 = ctext + zc.col(this.XcOffset) - zc.col(0.0);
            this.TY1 = rtext + zc.row(this.YcOffset) - zc.row(0.0);
            this.drawLabel(g, s);
        }
    }

    @Override
    public String getDisplayValue() {
        String s = "";
        s = s + "(" + Global.getLocaleNumber(-this.X[0], "length");
        s = s + "*";
        s = s + Tags[0] + ")";
        for (int i = 1; i < 5; ++i) {
            s = s + "+";
            s = s + "(" + Global.getLocaleNumber(-this.X[i], "length");
            s = s + "*";
            s = s + Tags[i] + ")";
        }
        return s + "=" + Global.getLocaleNumber(this.X[5], "length");
    }

    @Override
    public String getEquation() {
        return this.getDisplayValue();
    }

    @Override
    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        double start;
        if (!this.displays(zc)) {
            return false;
        }
        int size = (int)zc.selectionSize();
        double end = zc.maxX();
        double h = zc.dx(1);
        for (double x = start = zc.minX(); x <= end; x += h) {
            double r;
            double c2;
            double y2;
            try {
                y2 = this.computeUpper(x);
                c2 = zc.col(x);
                r = zc.row(y2);
                if (Math.abs((double)cc - c2) <= (double)(size * 3 / 2) && Math.abs((double)rr - r) <= (double)(size * 3 / 2)) {
                    return true;
                }
            }
            catch (Exception y2) {
                // empty catch block
            }
            try {
                y2 = this.computeLower(x);
                c2 = zc.col(x);
                r = zc.row(y2);
                if (!(Math.abs((double)cc - c2) <= (double)(size * 3 / 2)) || !(Math.abs((double)rr - r) <= (double)(size * 3 / 2))) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public double computeUpper(double x) {
        if (Math.abs(this.X[1]) > 1.0E-13) {
            double p = (this.X[3] + x * this.X[4]) / this.X[1];
            double q = (this.X[0] * x * x + this.X[2] * x + this.X[5]) / this.X[1];
            double h = p * p / 4.0 - q;
            if (h < 0.0) {
                throw new RuntimeException("");
            }
            return -p / 2.0 + Math.sqrt(h);
        }
        return -(this.X[0] * x * x + this.X[2] * x + this.X[5]) / (this.X[3] + this.X[4] * x);
    }

    public double computeLower(double x) {
        if (Math.abs(this.X[1]) > 1.0E-13) {
            double p = (this.X[3] + x * this.X[4]) / this.X[1];
            double q = (this.X[0] * x * x + this.X[2] * x + this.X[5]) / this.X[1];
            double h = p * p / 4.0 - q;
            if (h < 0.0) {
                throw new RuntimeException("");
            }
            return -p / 2.0 - Math.sqrt(h);
        }
        throw new RuntimeException("");
    }

    @Override
    public void printArgs(XmlWriter xml) {
        for (int i = 0; i < this.P.length; ++i) {
            xml.printArg("point" + (i + 1), this.P[i].getName());
        }
    }

    @Override
    public Enumeration depending() {
        DL.reset();
        for (PointObject element : this.P) {
            DL.add(element);
        }
        return DL.elements();
    }

    @Override
    public void translate() {
        for (int i = 0; i < this.P.length; ++i) {
            this.P[i] = (PointObject)this.P[i].getTranslation();
        }
    }

    @Override
    public ConstructionObject copy(double x, double y) {
        try {
            QuadricObject o = (QuadricObject)this.clone();
            this.setTranslation(o);
            o.P = new PointObject[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                o.P[i] = this.P[i];
            }
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            o.setTarget(false);
            return o;
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    @Override
    public boolean equals(ConstructionObject o) {
        if (!(o instanceof QuadricObject) || !o.valid()) {
            return false;
        }
        try {
            for (int i = 0; i < 6; ++i) {
                if (this.equals(this.X[i], ((QuadricObject)o).X[i])) continue;
                return false;
            }
        }
        catch (RuntimeException e2) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasUnit() {
        return false;
    }

    public void keepBaricentricCoords(PointObject P) {
        if (!P.isPointOn()) {
            return;
        }
        if (P.BarycentricCoordsInitialzed) {
            PointObject AA = this.P[0];
            PointObject BB = this.P[1];
            PointObject CC = this.P[2];
            double xa = AA.getX();
            double ya = AA.getY();
            double xb = BB.getX();
            double yb = BB.getY();
            double xc = CC.getX();
            double yc = CC.getY();
            double xm = xa + P.Gx * (xb - xa) + P.Gy * (xc - xa);
            double ym = ya + P.Gx * (yb - ya) + P.Gy * (yc - ya);
            P.move(xm, ym);
        } else {
            P.computeBarycentricCoords();
        }
    }

    @Override
    public int getDistance(PointObject P) {
        double yc;
        double a2 = this.X[0];
        double b2 = this.X[1];
        double c2 = this.X[2];
        double d2 = this.X[3];
        double e2 = this.X[4];
        double r = this.X[5];
        double xc = P.getX();
        if (Math.abs(a2 * xc * xc + b2 * (yc = P.getY()) * yc + c2 * xc + d2 * yc + e2 * xc * yc + r) < 1.0E-13) {
            return 0;
        }
        double[] t = new double[5];
        double[] s = new double[5];
        t[0] = a2 * e2 * e2 * d2 * d2 - 4.0 * a2 * b2 * b2 * c2 * c2 + 4.0 * a2 * e2 * d2 * b2 * c2 - 4.0 * b2 * a2 * a2 * d2 * d2 + b2 * c2 * c2 * e2 * e2 - c2 * Math.pow(e2, 3.0) * d2 + r * Math.pow(e2, 4.0) - 8.0 * r * e2 * e2 * b2 * a2 + 16.0 * r * b2 * b2 * a2 * a2;
        t[1] = 8.0 * b2 * b2 * c2 * c2 + 8.0 * a2 * a2 * d2 * d2 - 8.0 * e2 * d2 * b2 * c2 - 8.0 * a2 * d2 * c2 * e2 + 8.0 * r * e2 * e2 * b2 + 8.0 * a2 * b2 * c2 * c2 + 8.0 * b2 * a2 * d2 * d2 + 8.0 * r * e2 * e2 * a2 - 32.0 * r * b2 * b2 * a2 - 32.0 * r * b2 * a2 * a2;
        t[2] = 12.0 * e2 * d2 * c2 + 16.0 * r * b2 * b2 - 4.0 * b2 * d2 * d2 - 8.0 * r * e2 * e2 + 4.0 * e2 * e2 * d2 * yc + 16.0 * b2 * b2 * xc * c2 - 16.0 * b2 * c2 * c2 - 16.0 * a2 * d2 * d2 - 4.0 * a2 * c2 * c2 + 16.0 * r * a2 * a2 + 16.0 * a2 * a2 * d2 * yc + 4.0 * xc * e2 * e2 * c2 - 8.0 * e2 * d2 * b2 * xc - 8.0 * e2 * yc * b2 * c2 - 8.0 * a2 * d2 * xc * e2 - 8.0 * a2 * yc * c2 * e2 + 16.0 * a2 * b2 * b2 * xc * xc - 4.0 * a2 * e2 * e2 * yc * yc + 16.0 * b2 * a2 * a2 * yc * yc - 4.0 * b2 * xc * xc * e2 * e2 + 4.0 * Math.pow(e2, 3.0) * yc * xc + 64.0 * r * b2 * a2 - 16.0 * a2 * b2 * xc * e2 * yc;
        t[3] = -32.0 * r * b2 + 8.0 * d2 * d2 + 8.0 * c2 * c2 + 16.0 * e2 * d2 * xc + 8.0 * e2 * e2 * yc * yc + 8.0 * xc * xc * e2 * e2 - 32.0 * r * a2 - 32.0 * b2 * xc * c2 + 16.0 * e2 * yc * c2 - 32.0 * a2 * d2 * yc - 32.0 * a2 * b2 * xc * xc - 32.0 * b2 * a2 * yc * yc;
        t[4] = 16.0 * b2 * yc * yc + 16.0 * d2 * yc + 16.0 * c2 * xc + 16.0 * xc * e2 * yc + 16.0 * r + 16.0 * a2 * xc * xc;
        int k = Quartic.solve(t, s);
        double dmin = 1.0E30;
        double xmin = xc;
        double ymin = yc;
        for (int i = 0; i < k; ++i) {
            double l = s[i];
            double px = -(-e2 * d2 + 4.0 * b2 * l * xc - 2.0 * e2 * l * yc - 4.0 * l * l * xc + 2.0 * b2 * c2 - 2.0 * l * c2) / (-e2 * e2 + 4.0 * b2 * a2 - 4.0 * b2 * l - 4.0 * l * a2 + 4.0 * l * l);
            double py = -(2.0 * a2 * d2 + 4.0 * a2 * l * yc - 2.0 * l * d2 - 4.0 * l * l * yc - 2.0 * l * xc * e2 - c2 * e2) / (-e2 * e2 + 4.0 * b2 * a2 - 4.0 * b2 * l - 4.0 * l * a2 + 4.0 * l * l);
            double dist = (px - xc) * (px - xc) + (py - yc) * (py - yc);
            if (!(dist < dmin)) continue;
            dmin = dist;
            xmin = px;
            ymin = py;
        }
        double dd = Math.sqrt((P.getX() - xmin) * (P.getX() - xmin) + (P.getY() - ymin) * (P.getY() - ymin));
        return (int)Math.round(dd * this.Cn.getPixel());
    }

    @Override
    public void project(PointObject P) {
        this.keepBaricentricCoords(P);
        double a2 = this.X[0];
        double b2 = this.X[1];
        double c2 = this.X[2];
        double d2 = this.X[3];
        double e2 = this.X[4];
        double r = this.X[5];
        double xc = P.getX();
        double yc = P.getY();
        if (Math.abs(a2 * xc * xc + b2 * yc * yc + c2 * xc + d2 * yc + e2 * xc * yc + r) < 1.0E-13) {
            return;
        }
        double[] t = new double[5];
        double[] s = new double[5];
        t[0] = a2 * e2 * e2 * d2 * d2 - 4.0 * a2 * b2 * b2 * c2 * c2 + 4.0 * a2 * e2 * d2 * b2 * c2 - 4.0 * b2 * a2 * a2 * d2 * d2 + b2 * c2 * c2 * e2 * e2 - c2 * Math.pow(e2, 3.0) * d2 + r * Math.pow(e2, 4.0) - 8.0 * r * e2 * e2 * b2 * a2 + 16.0 * r * b2 * b2 * a2 * a2;
        t[1] = 8.0 * b2 * b2 * c2 * c2 + 8.0 * a2 * a2 * d2 * d2 - 8.0 * e2 * d2 * b2 * c2 - 8.0 * a2 * d2 * c2 * e2 + 8.0 * r * e2 * e2 * b2 + 8.0 * a2 * b2 * c2 * c2 + 8.0 * b2 * a2 * d2 * d2 + 8.0 * r * e2 * e2 * a2 - 32.0 * r * b2 * b2 * a2 - 32.0 * r * b2 * a2 * a2;
        t[2] = 12.0 * e2 * d2 * c2 + 16.0 * r * b2 * b2 - 4.0 * b2 * d2 * d2 - 8.0 * r * e2 * e2 + 4.0 * e2 * e2 * d2 * yc + 16.0 * b2 * b2 * xc * c2 - 16.0 * b2 * c2 * c2 - 16.0 * a2 * d2 * d2 - 4.0 * a2 * c2 * c2 + 16.0 * r * a2 * a2 + 16.0 * a2 * a2 * d2 * yc + 4.0 * xc * e2 * e2 * c2 - 8.0 * e2 * d2 * b2 * xc - 8.0 * e2 * yc * b2 * c2 - 8.0 * a2 * d2 * xc * e2 - 8.0 * a2 * yc * c2 * e2 + 16.0 * a2 * b2 * b2 * xc * xc - 4.0 * a2 * e2 * e2 * yc * yc + 16.0 * b2 * a2 * a2 * yc * yc - 4.0 * b2 * xc * xc * e2 * e2 + 4.0 * Math.pow(e2, 3.0) * yc * xc + 64.0 * r * b2 * a2 - 16.0 * a2 * b2 * xc * e2 * yc;
        t[3] = -32.0 * r * b2 + 8.0 * d2 * d2 + 8.0 * c2 * c2 + 16.0 * e2 * d2 * xc + 8.0 * e2 * e2 * yc * yc + 8.0 * xc * xc * e2 * e2 - 32.0 * r * a2 - 32.0 * b2 * xc * c2 + 16.0 * e2 * yc * c2 - 32.0 * a2 * d2 * yc - 32.0 * a2 * b2 * xc * xc - 32.0 * b2 * a2 * yc * yc;
        t[4] = 16.0 * b2 * yc * yc + 16.0 * d2 * yc + 16.0 * c2 * xc + 16.0 * xc * e2 * yc + 16.0 * r + 16.0 * a2 * xc * xc;
        int k = Quartic.solve(t, s);
        double dmin = 1.0E30;
        double xmin = xc;
        double ymin = yc;
        for (int i = 0; i < k; ++i) {
            double l = s[i];
            double px = -(-e2 * d2 + 4.0 * b2 * l * xc - 2.0 * e2 * l * yc - 4.0 * l * l * xc + 2.0 * b2 * c2 - 2.0 * l * c2) / (-e2 * e2 + 4.0 * b2 * a2 - 4.0 * b2 * l - 4.0 * l * a2 + 4.0 * l * l);
            double py = -(2.0 * a2 * d2 + 4.0 * a2 * l * yc - 2.0 * l * d2 - 4.0 * l * l * yc - 2.0 * l * xc * e2 - c2 * e2) / (-e2 * e2 + 4.0 * b2 * a2 - 4.0 * b2 * l - 4.0 * l * a2 + 4.0 * l * l);
            double dist = (px - xc) * (px - xc) + (py - yc) * (py - yc);
            if (!(dist < dmin)) continue;
            dmin = dist;
            xmin = px;
            ymin = py;
        }
        P.move(xmin, ymin);
    }

    @Override
    public void project(PointObject P, double alpha) {
        this.project(P);
    }

    @Override
    public void dragTo(double x, double y) {
        for (int i = 0; i < 5; ++i) {
            this.P[i].move(this.xd[i] + (x - this.x1), this.yd[i] + (y - this.y1));
        }
    }

    @Override
    public void move(double x, double y) {
    }

    @Override
    public boolean moveable() {
        for (int i = 0; i < 5; ++i) {
            if (this.P[i].moveable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void startDrag(double x, double y) {
        if (this.xd == null) {
            this.xd = new double[5];
            this.yd = new double[5];
        }
        for (int i = 0; i < 5; ++i) {
            this.xd[i] = this.P[i].getX();
            this.yd[i] = this.P[i].getY();
        }
        this.x1 = x;
        this.y1 = y;
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            for (int i = 0; i < 5; ++i) {
                this.P[i].snap(zc);
            }
        }
    }

    @Override
    public boolean canInteresectWith(ConstructionObject o) {
        return true;
    }

    @Override
    public void repulse(PointObject P) {
        this.project(P);
    }
}

