/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.Count;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.RayObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.util.Enumeration;

public class PlumbObject
extends PrimitiveLineObject
implements MoveableObject {
    PrimitiveLineObject L;
    static Count N = new Count();
    protected boolean Restricted = false;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public PlumbObject(Construction c2, PrimitiveLineObject l, PointObject p) {
        super(c2);
        this.P1 = p;
        this.L = l;
        this.validate();
        this.updateText();
    }

    @Override
    public String getTag() {
        return "Plumb";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        this.setText(PlumbObject.text2(Global.name("text.plumb"), this.P1.getName(), this.L.getName()));
    }

    @Override
    public void validate() {
        if (!this.P1.valid() || !this.L.valid()) {
            this.Valid = false;
        } else {
            this.Valid = true;
            this.X1 = this.P1.getX();
            this.Y1 = this.P1.getY();
            this.DX = -this.L.getDY();
            this.DY = this.L.getDX();
            if (this.L instanceof SegmentObject && ((SegmentObject)this.L).getLength() == 0.0) {
                this.Valid = false;
            }
            if (this.Restricted && !this.L.contains(this.X1, this.Y1)) {
                this.Valid = false;
            }
        }
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("point", this.P1.getName());
        xml.printArg("line", this.L.getName());
        if (!this.Restricted) {
            xml.printArg("valid", "true");
        }
        super.printArgs(xml);
    }

    public boolean isRestricted() {
        return this.Restricted;
    }

    public void setRestricted(boolean flag) {
        this.Restricted = flag;
    }

    public boolean canRestrict() {
        return this.L instanceof SegmentObject || this.L instanceof RayObject;
    }

    @Override
    public void setMainParameter(boolean b2) {
        this.MainParameter = true;
    }

    @Override
    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.L);
    }

    @Override
    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.L = (PrimitiveLineObject)this.L.getTranslation();
    }

    @Override
    public boolean contains(PointObject p) {
        return p == this.P1;
    }

    @Override
    public boolean hasUnit() {
        return false;
    }

    @Override
    public void dragTo(double x, double y) {
        this.P1.move(this.x1 + (x - this.x3), this.y1 + (y - this.y3));
    }

    @Override
    public void move(double x, double y) {
    }

    @Override
    public boolean moveable() {
        return this.P1.moveable();
    }

    @Override
    public void startDrag(double x, double y) {
        this.x1 = this.P1.getX();
        this.y1 = this.P1.getY();
        this.x3 = x;
        this.y3 = y;
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            this.P1.snap(zc);
        }
    }
}

