/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.Count;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import java.util.Enumeration;

public class MidpointObject
extends PointObject {
    PointObject P1;
    PointObject P2;
    static Count N = new Count();

    public MidpointObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2, 0.0, 0.0);
        this.P1 = p1;
        this.P2 = p2;
        this.Moveable = false;
        this.validate();
        this.updateText();
    }

    @Override
    public String getTag() {
        return "Midpoint";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        try {
            this.setText(MidpointObject.text2(Global.name("text.midpoint"), this.P1.getName(), this.P2.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void validate() {
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
        } else {
            this.Valid = true;
            this.setXY((this.P1.getX() + this.P2.getX()) / 2.0, (this.P1.getY() + this.P2.getY()) / 2.0);
        }
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("first", this.P1.getName());
        xml.printArg("second", this.P2.getName());
        this.printType(xml);
    }

    @Override
    public Enumeration depending() {
        super.depending();
        DL.add(this.P1);
        DL.add(this.P2);
        return DL.elements();
    }

    @Override
    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
    }
}

