/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.Count;
import carmetal.eric.Media;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.objects.QuadricObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.FileName;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.graphics.MyGraphics;
import java.awt.Image;
import java.util.Enumeration;

public class ImageObject
extends ConstructionObject {
    PointObject[] P;
    static Count N = new Count();
    String Filename;
    Image I;

    public ImageObject(Construction c2, PointObject[] p, String filename) {
        super(c2);
        this.P = p;
        this.Filename = FileName.filename(filename);
        this.updateText();
    }

    @Override
    public String getTag() {
        return "Image";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        try {
            String[] Names = new String[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                Names[i] = this.P[i].getName();
            }
            this.setText(ImageObject.textAny(Global.name("text.image"), Names));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        if (this.I == null) {
            this.I = Media.getImage(this.Filename);
            if (this.I == null || this.I.getWidth(zc) == 0 || this.I.getHeight(zc) == 0) {
                this.Valid = false;
                return;
            }
            this.Valid = true;
        }
        if (this.P[1] == this.P[2] || this.P[0] == this.P[2]) {
            this.I.getWidth(zc);
            double dx = this.P[1].getX() - this.P[0].getX();
            double dy = this.P[1].getY() - this.P[0].getY();
            g.drawImage(this.I, zc.col(this.P[0].getX()), zc.row(this.P[0].getY()), zc.col(this.P[1].getX()), zc.row(this.P[1].getY()), zc.col(this.P[0].getX() + dy), zc.row(this.P[0].getY() - dx), zc);
        }
        g.drawImage(this.I, zc.col(this.P[0].getX()), zc.row(this.P[0].getY()), zc.col(this.P[1].getX()), zc.row(this.P[1].getY()), zc.col(this.P[2].getX()), zc.row(this.P[2].getY()), zc);
    }

    @Override
    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        return this.P[0].nearto(cc, rr, zc) || this.P[1].nearto(cc, rr, zc) || this.P[2].nearto(cc, rr, zc);
    }

    @Override
    public void printArgs(XmlWriter xml) {
        for (int i = 0; i < this.P.length; ++i) {
            xml.printArg("point" + (i + 1), this.P[i].getName());
        }
        xml.printArg("filename", FileName.filename(this.Filename));
    }

    @Override
    public Enumeration depending() {
        DL.reset();
        for (PointObject element : this.P) {
            DL.add(element);
        }
        return DL.elements();
    }

    @Override
    public void translate() {
        for (int i = 0; i < this.P.length; ++i) {
            this.P[i] = (PointObject)this.P[i].getTranslation();
        }
    }

    @Override
    public ConstructionObject copy(double x, double y) {
        try {
            QuadricObject o = (QuadricObject)this.clone();
            this.setTranslation(o);
            o.P = new PointObject[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                o.P[i] = this.P[i];
            }
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            o.setTarget(false);
            return o;
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return this.nearto(x, y, zc);
    }

    @Override
    public boolean hasUnit() {
        return false;
    }
}

