/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.monkey;

import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.util.ArrayList;
import java.util.Enumeration;

public class monkey {
    private ZirkelCanvas ZC;
    private long waitTime = 5L;
    private ArrayList<PointObject> mobiles = new ArrayList();
    private ArrayList<double[]> mobilesCoords = new ArrayList();
    private boolean inprogress = false;
    private static Thread shakeThread = null;

    public monkey(ZirkelCanvas zc) {
        this.ZC = zc;
        this.initMobiles();
    }

    public void initMobiles() {
        this.mobiles.clear();
        this.mobilesCoords.clear();
        Enumeration e2 = this.ZC.getConstruction().elements();
        while (e2.hasMoreElements()) {
            PointObject pt;
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (!(c2 instanceof PointObject) || !(pt = (PointObject)c2).moveable() || !pt.insidewindow()) continue;
            this.mobiles.add(pt);
            double[] tab = new double[]{pt.getX(), pt.getY()};
            this.mobilesCoords.add(tab);
        }
    }

    public void reset() {
        for (int k = 25; k > 0; --k) {
            long t0 = System.currentTimeMillis();
            for (int i = 0; i < this.mobiles.size(); ++i) {
                double x0 = this.mobiles.get(i).getX();
                double y0 = this.mobiles.get(i).getY();
                double[] tab = this.mobilesCoords.get(i);
                double x1 = x0 + (tab[0] - x0) / (double)k;
                double y1 = y0 + (tab[1] - y0) / (double)k;
                this.mobiles.get(i).move(x1, y1);
            }
            this.ZC.validate();
            this.ZC.repaint();
            long t1 = System.currentTimeMillis();
            try {
                long time = 1L - t1 + t0;
                if (time <= 0L) continue;
                Thread.sleep(time);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void move1step() {
        for (int i = 0; i < this.mobiles.size(); ++i) {
            PointObject pt = this.mobiles.get(i);
            pt.shake();
        }
        this.ZC.validate();
        this.ZC.repaint();
    }

    public void start() {
        if (shakeThread != null) {
            return;
        }
        this.inprogress = true;
        shakeThread = new Thread(){

            @Override
            public void run() {
                while (monkey.this.inprogress) {
                    long t0 = System.currentTimeMillis();
                    monkey.this.move1step();
                    long t1 = System.currentTimeMillis();
                    try {
                        long time = monkey.this.waitTime - t1 + t0;
                        if (time <= 0L) continue;
                        Thread.sleep(time);
                    }
                    catch (Exception exception) {}
                }
                monkey.this.reset();
                shakeThread = null;
            }
        };
        shakeThread.setPriority(1);
        shakeThread.start();
    }

    public void stop() {
        this.inprogress = false;
    }
}

