/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.jobs;

import carmetal.construction.Construction;
import carmetal.eric.Progress_Bar;
import carmetal.eric.jobs.JobMessage;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.util.ArrayList;
import java.util.Enumeration;

public class JobValidation {
    private final int MAX = 1000;
    private ZirkelCanvas ZC;
    private Construction C;
    private ArrayList<PointObject> mobiles = new ArrayList();
    private ArrayList<double[]> mobilesCoords = new ArrayList();
    private ArrayList<ConstructionObject> targets;
    private ArrayList<ConstructionObject> clones;

    public JobValidation(ZirkelCanvas zc) {
        this.ZC = zc;
        this.C = this.ZC.getConstruction();
        this.initMobiles();
        this.targets = this.ZC.job_getTargets();
    }

    public void initMobiles() {
        this.mobiles.clear();
        this.mobilesCoords.clear();
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            PointObject pt;
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (!(c2 instanceof PointObject) || !(pt = (PointObject)c2).moveable() || !pt.insidewindow()) continue;
            this.mobiles.add(pt);
            double[] tab = new double[]{pt.getX(), pt.getY()};
            this.mobilesCoords.add(tab);
        }
    }

    public boolean initClones() {
        this.clones = new ArrayList();
        block0: for (int i = 0; i < this.targets.size(); ++i) {
            ConstructionObject o = this.targets.get(i);
            Enumeration e2 = this.C.elements();
            while (e2.hasMoreElements()) {
                ConstructionObject c2 = (ConstructionObject)e2.nextElement();
                if (o == c2 || c2.isHidden() || !o.equals(c2)) continue;
                this.clones.add(c2);
                continue block0;
            }
        }
        return this.targets.size() == this.clones.size();
    }

    public void reset() {
        for (int i = 0; i < this.mobiles.size(); ++i) {
            double[] tab = this.mobilesCoords.get(i);
            this.mobiles.get(i).move(tab[0], tab[1]);
        }
        this.ZC.validate();
    }

    public boolean checkHorizontalAligment() {
        double inc = 2.0 * this.C.getW() / (double)(this.mobiles.size() + 2);
        double left = this.C.getX() - this.C.getW() + inc;
        for (int i = 0; i < this.mobiles.size(); ++i) {
            PointObject pt = this.mobiles.get(i);
            pt.move(left, 0.0);
            pt.validate();
            left += inc;
        }
        this.ZC.validate();
        return this.isTargetsEqualClones();
    }

    public boolean check1step() {
        for (int i = 0; i < this.mobiles.size(); ++i) {
            PointObject pt = this.mobiles.get(i);
            pt.alea();
        }
        this.ZC.validate();
        return this.isTargetsEqualClones();
    }

    public boolean isTargetsEqualClones() {
        for (int i = 0; i < this.targets.size(); ++i) {
            if (!this.targets.get(i).valid() && !this.clones.get(i).valid() || this.targets.get(i).equals(this.clones.get(i))) continue;
            return false;
        }
        return true;
    }

    public void dynamicConstructionFailed() {
        this.reset();
        String message = "<b>" + this.ZC.job_getMessageFailed();
        message = message + "</b><br>(" + Global.Loc("restrict.failed.initial") + ")";
        JobMessage.showMessage(message);
    }

    public void dynamicConstructionFailed(int failed) {
        this.reset();
        double d2 = 100.0 * (double)failed / 1001.0;
        String message = "<b>" + this.ZC.job_getMessageFailed();
        message = message + "</b><br>(" + Global.Loc("restrict.failed.percent") + String.valueOf(Math.round(d2)) + "%)";
        JobMessage.showMessage(message);
    }

    public void staticConstructionFailed() {
        this.reset();
        String message = "<b>" + this.ZC.job_getMessageFailed() + "</b>";
        JobMessage.showMessage(message);
    }

    public void constructionOk() {
        this.reset();
        JobMessage.showMessage(this.ZC.job_getMessageOk());
    }

    public void constructionOkExceptAlignment() {
        this.reset();
        String message = "<b>" + this.ZC.job_getMessageOk();
        message = message + "</b><br>(" + Global.Loc("job.gui.alignment") + ")";
        JobMessage.showMessage(message);
    }

    public void justSee() {
        this.ZC.paint(this.ZC.getGraphics());
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkAllsteps() {
        if (this.mobiles.size() > 0) {
            int failed = 0;
            if (!this.initClones()) {
                this.dynamicConstructionFailed();
                return;
            }
            boolean progress = false;
            Progress_Bar.create(Global.Loc("job.gui.progressmessage"), 0, 999);
            for (int i = 0; i < 1000; ++i) {
                if (!this.check1step()) {
                    ++failed;
                }
                Progress_Bar.nextValue();
            }
            Progress_Bar.close();
            if (failed > 0) {
                this.dynamicConstructionFailed(failed);
                return;
            }
            if (!this.checkHorizontalAligment()) {
                this.constructionOkExceptAlignment();
                return;
            }
            this.constructionOk();
        } else {
            if (!this.initClones() || !this.check1step()) {
                this.staticConstructionFailed();
                return;
            }
            this.constructionOk();
        }
    }
}

