/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.animations;

import carmetal.eric.animations.AnimationPanel;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.zirkel.ZirkelCanvas;

public class Animation {
    private ZirkelCanvas ZC;
    private ConstructionObject O = null;
    private String ObjectName;
    private AnimationPanel PANEL;
    private boolean Negative = false;
    private Thread TH = null;
    private boolean thread_alive = true;
    private double min;
    private double max;
    private double positiveincrement;
    private double parts = 100.0;

    public Animation(ZirkelCanvas zc, AnimationPanel panel, ConstructionObject o) {
        this.ZC = zc;
        this.O = o;
        this.PANEL = panel;
        this.ObjectName = this.O.getName();
    }

    public Animation(ZirkelCanvas zc, AnimationPanel panel, String objectname) {
        this.ZC = zc;
        this.ObjectName = objectname;
        this.PANEL = panel;
    }

    public boolean getNegative() {
        return this.Negative;
    }

    public void setNegative(boolean neg) {
        this.Negative = neg;
    }

    public String getObjectName() {
        return this.ObjectName;
    }

    public ConstructionObject getObject() {
        if (this.O == null) {
            this.O = this.ZC.getConstruction().find(this.ObjectName);
        }
        return this.O;
    }

    public void killThread() {
        this.thread_alive = false;
    }

    public void run() {
        if (this.TH != null) {
            return;
        }
        this.O = this.getObject();
        if (this.O == null) {
            return;
        }
        if (this.O instanceof PointObject) {
            this.runPoint();
        } else if (this.O instanceof ExpressionObject) {
            this.runExpression();
        }
    }

    public void runPoint() {
        this.TH = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean back = false;
                double x = 0.0;
                ZirkelCanvas canvas = Animation.this.ZC;
                PointObject P = (PointObject)Animation.this.O;
                double x0 = P.getX();
                double y0 = P.getY();
                if (P.getBound() instanceof SegmentObject) {
                    SegmentObject s = (SegmentObject)P.getBound();
                    x = Math.sqrt((x0 - s.getP1().getX()) * (x0 - s.getP1().getX()) + (y0 - s.getP1().getY()) * (y0 - s.getP1().getY()));
                } else if (P.getBound() instanceof PrimitiveCircleObject) {
                    PrimitiveCircleObject c2 = (PrimitiveCircleObject)P.getBound();
                    x = Math.acos((x0 - c2.getX()) / c2.getR()) * Math.signum(y0 - c2.getY());
                }
                if (P.getBound() == null) {
                    return;
                }
                if (!(P.getBound() instanceof SegmentObject) && !(P.getBound() instanceof PrimitiveCircleObject)) {
                    return;
                }
                long time = System.currentTimeMillis();
                while (!Animation.this.PANEL.isStopped() && Animation.this.thread_alive) {
                    ZirkelCanvas zirkelCanvas;
                    try {
                        long t = System.currentTimeMillis();
                        double d2 = Animation.this.PANEL.getDelay();
                        int h = (int)(t - time);
                        if (h < 0) {
                            h = 0;
                        }
                        if ((double)h > d2) {
                            h = (int)d2;
                        }
                        Thread.sleep((int)(d2 - (double)h));
                        time = System.currentTimeMillis();
                    }
                    catch (Exception t) {
                        // empty catch block
                    }
                    if (P.getBound() instanceof SegmentObject) {
                        SegmentObject s = (SegmentObject)P.getBound();
                        zirkelCanvas = canvas;
                        synchronized (zirkelCanvas) {
                            if (back) {
                                Animation.this.O.move(s.getP1().getX() + (s.getLength() - x) * s.getDX(), s.getP1().getY() + (s.getLength() - x) * s.getDY());
                            } else {
                                Animation.this.O.move(s.getP1().getX() + x * s.getDX(), s.getP1().getY() + x * s.getDY());
                            }
                            Animation.this.ZC.dovalidate();
                            Animation.this.ZC.repaint();
                            x += Animation.this.ZC.dx(2);
                            if (x > s.getLength()) {
                                back = !back;
                                x = 0.0;
                            }
                            continue;
                        }
                    }
                    if (!(P.getBound() instanceof PrimitiveCircleObject)) continue;
                    PrimitiveCircleObject c3 = (PrimitiveCircleObject)P.getBound();
                    zirkelCanvas = canvas;
                    synchronized (zirkelCanvas) {
                        Animation.this.O.move(c3.getP1().getX() + Math.cos(x) * c3.getR(), c3.getP1().getY() + Math.sin(x) * c3.getR());
                        Animation.this.ZC.dovalidate();
                        Animation.this.ZC.repaint();
                        x = Animation.this.Negative ? (x -= Animation.this.ZC.dx(2) / c3.getR()) : (x += Animation.this.ZC.dx(2) / c3.getR());
                    }
                }
                Animation.this.TH = null;
            }
        };
        this.TH.setPriority(1);
        this.TH.start();
    }

    public void initSlidersParameters(ExpressionObject E) {
        this.min = E.getMinValue();
        this.max = E.getMaxValue();
        this.positiveincrement = (this.max - this.min) / this.parts;
    }

    public void runExpression() {
        this.TH = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                double x;
                ZirkelCanvas canvas = Animation.this.ZC;
                ExpressionObject E = (ExpressionObject)Animation.this.O;
                try {
                    x = E.getValue();
                }
                catch (Exception ex) {
                    x = 0.0;
                }
                double increment = 1.0;
                long time = System.currentTimeMillis();
                while (!Animation.this.PANEL.isStopped() && Animation.this.thread_alive) {
                    try {
                        long t = System.currentTimeMillis();
                        double d2 = Animation.this.PANEL.getDelay();
                        int h = (int)(t - time);
                        if (h < 0) {
                            h = 0;
                        }
                        if ((double)h > d2) {
                            h = (int)d2;
                        }
                        Thread.sleep((int)(d2 - (double)h));
                        time = System.currentTimeMillis();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        ZirkelCanvas zirkelCanvas = canvas;
                        synchronized (zirkelCanvas) {
                            if (E.isSlider()) {
                                Animation.this.initSlidersParameters(E);
                                if (Animation.this.Negative) {
                                    x = x > Animation.this.max ? Animation.this.min : (x += Animation.this.positiveincrement);
                                } else if (x > Animation.this.max) {
                                    x = Animation.this.max;
                                    increment = -Animation.this.positiveincrement;
                                } else if (x < Animation.this.min) {
                                    x = Animation.this.min;
                                    increment = Animation.this.positiveincrement;
                                } else {
                                    x += Math.signum(increment) * Animation.this.positiveincrement;
                                }
                            } else {
                                x += Animation.this.Negative ? -increment : increment;
                            }
                            E.setExpression("" + x, E.getConstruction());
                            Animation.this.ZC.dovalidate();
                            Animation.this.ZC.repaint();
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                Animation.this.TH = null;
            }
        };
        this.TH.setPriority(1);
        this.TH.start();
    }
}

