/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.JSprogram;

import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.myJMenuItem;
import carmetal.eric.JSprogram.JSRun;
import carmetal.eric.JSprogram.ScriptItem;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class ScriptPanel
extends JPanel
implements MouseListener {
    private ZirkelCanvas ZC;
    private Vector<ScriptItem> items = new Vector();
    private static Image icon = themes.getImage("scripts.png");
    private int W = 32;
    private int H = 32;
    private int X = 10;
    private int Y = 10;

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(icon, 0, 0, this.W, this.H, this);
    }

    public ScriptPanel(ZirkelCanvas zc) {
        this.ZC = zc;
        this.setBounds(this.X, this.Y, this.W, this.H);
        this.addMouseListener(this);
    }

    public void showPopup() {
        JPopupMenu popup = new JPopupMenu();
        myJMenuItem item = new myJMenuItem(Global.Loc("JSmenu.cancel")){

            @Override
            public void action() {
                JSRun.restore();
            }
        };
        item.setEnabled(JSRun.isBackup());
        popup.add(item);
        item = new myJMenuItem(Global.Loc("JSmenu.add")){

            @Override
            public void action() {
                JSRun.newScriptInConstruction();
            }
        };
        popup.add(item);
        popup.add(new JSeparator());
        for (int i = 0; i < this.items.size(); ++i) {
            popup.add(this.items.get(i));
        }
        popup.add(new JSeparator());
        JMenu modifypopup = new JMenu(Global.Loc("JSmenu.modify"));
        for (int i = 0; i < this.items.size(); ++i) {
            final int itemnum = i;
            item = new myJMenuItem(this.items.get(i).getScriptName()){

                @Override
                public void action() {
                    JSRun.openEmbeddedScript(((ScriptItem)ScriptPanel.this.items.get(itemnum)).getScriptName(), ((ScriptItem)ScriptPanel.this.items.get(itemnum)).getScriptSource());
                }
            };
            modifypopup.add(item);
            modifypopup.setFont(themes.TabMenusFont);
        }
        popup.add(modifypopup);
        JMenu deletepopup = new JMenu(Global.Loc("JSmenu.delete"));
        for (int i = 0; i < this.items.size(); ++i) {
            final int itemnum = i;
            item = new myJMenuItem(this.items.get(i).getScriptName()){

                @Override
                public void action() {
                    ScriptPanel.this.removeScript((ScriptItem)ScriptPanel.this.items.get(itemnum));
                }
            };
            deletepopup.add(item);
            deletepopup.setFont(themes.TabMenusFont);
        }
        popup.add(deletepopup);
        popup.show(this, this.W - 10, this.H);
    }

    public Vector<ScriptItem> getScripts() {
        return this.items;
    }

    public void removeScript(ScriptItem si) {
        this.ZC.getConstruction().haveChanged();
        this.items.remove(si);
        if (this.items.size() == 0) {
            this.ZC.remove(this);
            this.ZC.repaint();
        }
    }

    public void addScript(XmlTree tree) {
        this.items.add(new ScriptItem(tree));
        if (this.items.size() == 1) {
            this.ZC.add(this);
        }
    }

    private ScriptItem findScript(String nme) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!nme.equals(this.items.get(i).getScriptName())) continue;
            return this.items.get(i);
        }
        return null;
    }

    public void removeScript(String nme) {
        ScriptItem si = this.findScript(nme);
        if (si != null) {
            this.removeScript(si);
        }
    }

    public void saveScript(String nme, String source) {
        ScriptItem si = this.findScript(nme);
        if (si != null) {
            si.setScriptSource(source);
        } else {
            this.items.add(new ScriptItem(nme, source));
        }
        if (this.items.size() == 1) {
            this.ZC.add(this);
            this.ZC.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.showPopup();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }
}

