/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.JSprogram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SizeSequence;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumberView
extends JComponent {
    private static final Color BORDER_COLOR = Color.GRAY;
    private static final Color DEFAULT_BACKGROUND = new Color(214, 221, 229);
    private static final Color DEFAULT_FOREGROUND = Color.black;
    private static final int WIDTH_TEMPLATE = 99999;
    private static final int MARGIN = 2;
    private FontMetrics viewFontMetrics;
    private int maxNumberWidth;
    private int componentWidth;
    private int textTopInset;
    private int textFontAscent;
    private int textFontHeight;
    private JTextComponent text;
    private SizeSequence sizes;
    private int startLine = 0;
    private boolean structureChanged = true;

    public LineNumberView(JTextComponent text) {
        if (text == null) {
            throw new IllegalArgumentException("Text component cannot be null");
        }
        this.text = text;
        this.updateCachedMetrics();
        UpdateHandler handler = new UpdateHandler();
        text.getDocument().addDocumentListener(handler);
        text.addPropertyChangeListener(handler);
        text.addComponentListener(handler);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(DEFAULT_BACKGROUND);
    }

    private void viewChanged(int startLine, boolean structureChanged) {
        this.startLine = startLine;
        this.structureChanged = structureChanged;
        this.revalidate();
        this.repaint();
    }

    private void updateSizes() {
        if (this.startLine < 0) {
            return;
        }
        if (this.structureChanged) {
            int count = this.getAdjustedLineCount();
            this.sizes = new SizeSequence(count);
            for (int i = 0; i < count; ++i) {
                this.sizes.setSize(i, this.getLineHeight(i));
            }
            this.structureChanged = false;
        } else {
            this.sizes.setSize(this.startLine, this.getLineHeight(this.startLine));
        }
        this.startLine = -1;
    }

    private int getAdjustedLineCount() {
        int n;
        Element map = this.text.getDocument().getDefaultRootElement();
        Element lastLine = map.getElement((n = map.getElementCount()) - 1);
        if (lastLine.getEndOffset() - lastLine.getStartOffset() > 1) {
            return n;
        }
        return n - 1;
    }

    private int getLineHeight(int index) {
        int lastPos = this.sizes.getPosition(index) + this.textTopInset;
        int height = this.textFontHeight;
        try {
            Element map = this.text.getDocument().getDefaultRootElement();
            int lastChar = map.getElement(index).getEndOffset() - 1;
            Rectangle r = this.text.modelToView(lastChar);
            height = r.y - lastPos + r.height;
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return height;
    }

    private void updateCachedMetrics() {
        Font textFont = this.text.getFont();
        FontMetrics fm = this.getFontMetrics(textFont);
        this.textFontHeight = fm.getHeight();
        this.textFontAscent = fm.getAscent();
        this.textTopInset = this.text.getInsets().top;
        Font viewFont = this.getFont();
        boolean changed = false;
        if (viewFont == null) {
            viewFont = UIManager.getFont("Label.font");
            changed = true;
        }
        if (viewFont.getSize() > textFont.getSize()) {
            viewFont = viewFont.deriveFont(textFont.getSize2D());
            changed = true;
        }
        this.viewFontMetrics = this.getFontMetrics(viewFont);
        this.maxNumberWidth = this.viewFontMetrics.stringWidth(String.valueOf(99999)) - 10;
        this.componentWidth = 4 + this.maxNumberWidth;
        if (changed) {
            super.setFont(viewFont);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.componentWidth, this.text.getHeight());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateCachedMetrics();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.updateSizes();
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(this.getForeground());
        int base = clip.y - this.textTopInset;
        int first = this.sizes.getIndex(base);
        int last = this.sizes.getIndex(base + clip.height);
        String text = "";
        for (int i = first; i <= last; ++i) {
            text = String.valueOf(i + 1);
            int x = 2 + this.maxNumberWidth - this.viewFontMetrics.stringWidth(text);
            int y = this.sizes.getPosition(i) + this.textFontAscent + this.textTopInset;
            g.drawString(text, x, y);
        }
    }

    class UpdateHandler
    extends ComponentAdapter
    implements PropertyChangeListener,
    DocumentListener {
        UpdateHandler() {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            LineNumberView.this.viewChanged(0, true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            if ("document".equals(propertyName)) {
                if (oldValue != null && oldValue instanceof Document) {
                    ((Document)oldValue).removeDocumentListener(this);
                }
                if (newValue != null && newValue instanceof Document) {
                    ((Document)newValue).addDocumentListener(this);
                }
            }
            LineNumberView.this.updateCachedMetrics();
            LineNumberView.this.viewChanged(0, true);
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.update(evt);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.update(evt);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        private void update(DocumentEvent evt) {
            Element map = LineNumberView.this.text.getDocument().getDefaultRootElement();
            int line = map.getElementIndex(evt.getOffset());
            DocumentEvent.ElementChange ec = evt.getChange(map);
            LineNumberView.this.viewChanged(line, ec != null);
        }
    }
}

