/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.JSprogram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LineNumber
extends JComponent {
    private static final Color DEFAULT_BACKGROUND = new Color(214, 221, 229);
    private static final Color DEFAULT_FOREGROUND = Color.black;
    private static final Font DEFAULT_FONT = new Font("monospaced", 0, 12);
    private static final int HEIGHT = 2146483647;
    private static final int MARGIN = 5;
    private FontMetrics fontMetrics;
    private int lineHeight;
    private int currentDigits;
    private JComponent component;
    private int componentFontHeight;
    private int componentFontAscent;

    public LineNumber(JComponent component) {
        if (component == null) {
            this.setFont(DEFAULT_FONT);
            this.component = this;
        } else {
            this.setFont(component.getFont());
            this.component = component;
        }
        this.setBackground(DEFAULT_BACKGROUND);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setPreferredWidth(99);
    }

    public void setPreferredWidth(int lines) {
        int digits = String.valueOf(lines).length();
        if (digits != this.currentDigits && digits > 1) {
            this.currentDigits = digits;
            int width = this.fontMetrics.charWidth('0') * digits;
            Dimension d2 = this.getPreferredSize();
            d2.setSize(10 + width, 2146483647);
            this.setPreferredSize(d2);
            this.setSize(d2);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.componentFontHeight = this.fontMetrics.getHeight();
        this.componentFontAscent = this.fontMetrics.getAscent();
    }

    public int getLineHeight() {
        if (this.lineHeight == 0) {
            return this.componentFontHeight;
        }
        return this.lineHeight;
    }

    public void setLineHeight(int lineHeight) {
        if (lineHeight > 0) {
            this.lineHeight = lineHeight;
        }
    }

    public int getStartOffset() {
        return this.component.getInsets().top + this.componentFontAscent;
    }

    @Override
    public void paintComponent(Graphics g) {
        int lineHeight = this.getLineHeight();
        int startOffset = this.getStartOffset();
        Rectangle drawHere = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setColor(this.getForeground());
        int startLineNumber = drawHere.y / lineHeight + 1;
        int endLineNumber = startLineNumber + drawHere.height / lineHeight;
        int start = drawHere.y / lineHeight * lineHeight + startOffset;
        for (int i = startLineNumber; i <= endLineNumber; ++i) {
            String lineNumber = String.valueOf(i);
            int stringWidth = this.fontMetrics.stringWidth(lineNumber);
            int rowWidth = this.getSize().width;
            g.drawString(lineNumber, rowWidth - stringWidth - 5, start);
            start += lineHeight;
        }
        int rows = this.component.getSize().height / this.componentFontHeight;
        this.setPreferredWidth(rows);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("LineNumberDemo");
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        frame.setContentPane(panel);
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel.setLayout(new BorderLayout());
        JTextArea textPane = new JTextArea();
        textPane.setFont(new Font("monospaced", 0, 12));
        textPane.setText("abc");
        JScrollPane scrollPane = new JScrollPane(textPane);
        panel.add(scrollPane);
        scrollPane.setPreferredSize(new Dimension(300, 250));
        LineNumber lineNumber = new LineNumber(textPane);
        scrollPane.setRowHeaderView(lineNumber);
        frame.pack();
        frame.setVisible(true);
    }
}

