/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.JSprogram;

import carmetal.construction.Construction;
import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.JGeneralMenuBar;
import carmetal.eric.JSprogram.Const;
import carmetal.eric.JSprogram.JSConsole;
import carmetal.eric.JSprogram.JSOuputConsole;
import carmetal.eric.JSprogram.ScriptItem;
import carmetal.eric.JZirkelCanvas;
import carmetal.objects.AreaObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.PointObject;
import carmetal.objects.SegmentObject;
import carmetal.org.mozilla.javascript.Context;
import carmetal.org.mozilla.javascript.RhinoException;
import carmetal.org.mozilla.javascript.Scriptable;
import carmetal.org.mozilla.javascript.ScriptableObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.FileName;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class JSRun {
    static Context cx = null;
    static ScriptableObject scope = null;
    static Construction C = null;
    static ZirkelCanvas ZC = null;
    static String CTOOL = "";
    static String CBACKUP = "";
    static String FILENAME = "";
    static ArrayList<String> BACKUPS = new ArrayList();
    static String[] allnames = new String[]{"cm", "Input", "Prompt", "Print", "Println", "Shownames", "Hidenames", "Hide", "Show", "Point", "Intersection", "Intersection2", "MidPoint", "Symmetry", "Line", "Segment", "Circle", "Parallel", "Perpendicular", "FixedCircle", "Move", "X", "Y", "GetExpressionValue", "Ray", "Angle", "Polygon", "Quadric", "CartesianFunction", "ParametricFunction", "SetColor", "SetThickness", "SetFixed", "Vector", "SetRGBColor", "SetShowName", "SetShowValue", "SetFilled", "SetPartial", "Expression", "SetAlias", "SetMagneticObjects", "AddMagneticObject", "SetMagneticRay", "SetPointType", "InteractiveInput", "FixedSegment", "SetHide", "Pause", "Delete", "SetExpressionValue", "Reflection", "Translation", "PerpendicularBisector", "AngleBisector", "Circle3pts", "Arc3pts", "FixedAngle", "Circle3", "ExecuteMacro", "Alert", "Conditional", "Layer"};
    static JSOuputConsole console = null;
    public static boolean busy = false;
    public static Thread JST = null;
    static JSConsole JSC = null;

    public static String[] getKeywords() {
        return allnames;
    }

    public static void deselect() {
        if (ZC != null) {
            ZC.clearSelected();
            PaletteManager.ClicOn(CTOOL);
        }
    }

    public static void init() {
        ZC = JZirkelCanvas.getCurrentZC();
    }

    public static void InitBeforeRun() {
        cx = Context.enter();
        scope = cx.initStandardObjects();
        scope.defineFunctionProperties(allnames, JSRun.class, 2);
        Const bb = new Const();
        Object wrappedOut2 = Context.javaToJS(bb, scope);
        ScriptableObject.putProperty((Scriptable)scope, "Const", wrappedOut2);
        CTOOL = PaletteManager.geomSelectedIcon();
        ZC = JZirkelCanvas.getCurrentZC();
        C = ZC.getConstruction();
        try {
            console = new JSOuputConsole();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clear() {
        JSRun.deselect();
        cx = null;
        scope = null;
        C = null;
        ZC = null;
        CTOOL = "";
        console = null;
        JST = null;
        BACKUPS.clear();
        busy = false;
        Global.setJSquit(false);
        Global.setJSO(null);
    }

    public static void cancelThread() {
        if (JST != null) {
            JST.interrupt();
        }
        JST = null;
    }

    public static void backup() {
        try {
            BACKUPS.add(FileTools.getCurrentFileSource());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBackup() {
        return BACKUPS.size() > 0;
    }

    public static void restore() {
        JSRun.cancelThread();
        if (BACKUPS.size() > 0) {
            C.clear();
            try {
                FileTools.setCurrentFileSource(BACKUPS.get(BACKUPS.size() - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            BACKUPS.remove(BACKUPS.size() - 1);
            if (JSC != null) {
                JSC.setBackBtnEnabled(BACKUPS.size() > 0);
            }
        }
    }

    public static void openEditor() {
        if (JSC == null) {
            JSC = new JSConsole();
        } else {
            JSC.toFront();
        }
    }

    public static void closeEditor() {
        if (JSC != null) {
            if (JSC.cancelSaveChanges()) {
                return;
            }
            JSRun.clear();
            JSC.dispose();
        }
    }

    public static void newScriptInConstruction() {
        JSRun.openEditor();
        JSC.selectScriptInfileChk(true);
        JSRun.saveScriptInConstruction();
    }

    public static void saveScript(String script, boolean forcedlog) {
        BufferedWriter output = null;
        File file = null;
        String myFileName = null;
        myFileName = JSC.isFileOpened() && !forcedlog ? JSC.getFileName() : FileTools.getSaveFile();
        if (myFileName == null) {
            return;
        }
        myFileName = myFileName + (myFileName.toLowerCase().endsWith(".js") ? "" : ".js");
        file = new File(myFileName);
        try {
            output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            output.write(script);
            ((Writer)output).close();
            JSC.setTextAreaChanged(false);
            JGeneralMenuBar.s_InitJSMenu();
            JSC.setWindowTitle(myFileName);
            JSC.setFileName(myFileName);
        }
        catch (Exception ex) {
            Logger.getLogger(JSRun.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void runScript(final String script) {
        JST = new Thread(){

            @Override
            public void run() {
                JSRun.InitBeforeRun();
                JSRun.backup();
                if (JSC != null) {
                    JSC.setBackBtnEnabled(true);
                }
                Global.setJSquit(false);
                busy = true;
                try {
                    cx.evaluateString(scope, script, "<cmd>", 0, null);
                }
                catch (RhinoException e2) {
                    if (JSC != null) {
                        JSC.Error(e2.getMessage());
                    } else {
                        JSRun.openEditor();
                        JSC.setScriptArea(script);
                        JSC.setWindowTitle(FILENAME);
                        JSC.setTextAreaChanged(false);
                        JSC.Error(e2.getMessage());
                    }
                    JSRun.restore();
                }
                finally {
                    if (cx != null) {
                        cx.exit();
                    }
                }
                if (JSC != null) {
                    JSC.setAlwaysOnTop(true);
                }
                JSRun.deselect();
                C.dovalidate();
                ZC.paint(ZC.getGraphics());
                busy = false;
                if (JSC != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JSC.setAlwaysOnTop(false);
                        }
                    });
                }
            }
        };
        JST.setPriority(1);
        JST.start();
    }

    public static String getScriptsFolder() {
        String name = "";
        JFileChooser jfc = new JFileChooser(Global.getOpenSaveDirectory());
        jfc.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f2) {
                if (f2.isDirectory()) {
                    return true;
                }
                return f2.getAbsolutePath().toLowerCase().endsWith(".js");
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
        jfc.setDialogType(0);
        jfc.setFileSelectionMode(1);
        jfc.setApproveButtonText(Global.Loc("JSeditor.opendfavfolder"));
        int rep = jfc.showOpenDialog(null);
        if (rep == 0) {
            name = jfc.getSelectedFile().getAbsolutePath();
            Global.setOpenSaveDirectory(name);
            Global.setParameter("scriptfolder", name);
        } else {
            name = "";
        }
        return name;
    }

    public static void removeScriptFromConstruction() {
        if (!JSC.getScriptName().equals("")) {
            ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
            if (zc != null) {
                zc.removeScript(JSC.getScriptName());
            }
            JSC.setScriptName("");
            if (JSC.getFileName().equals("")) {
                JSC.setWindowTitle(Global.Loc("JSeditor.title"));
            }
        }
    }

    public static void saveScriptInConstruction() {
        ZirkelCanvas zc;
        if (JSC.getScriptName().equals("")) {
            String s;
            if (JSC.getFileName().equals("")) {
                s = (String)JOptionPane.showInputDialog(JSC, Global.Loc("JSeditor.saveinfig.question"), Global.Loc("JSeditor.saveinfig.title"), -1, null, null, "");
                if (s != null && s.length() > 0) {
                    s = JSRun.uniqueScriptName(s);
                    JSC.setWindowTitle(Global.Loc("JSeditor.infig") + s);
                    JSC.setScriptName(s);
                }
            } else {
                s = FileName.filename(JSC.getFileName());
                s = s.replaceAll("\\Q.js\\E$", "");
                s = s.replaceAll("\\Q.JS\\E$", "");
                JSC.setScriptName(s);
            }
        }
        if ((zc = JZirkelCanvas.getCurrentZC()) != null) {
            zc.saveScript(JSC.getScriptName(), JSC.getScript());
        }
    }

    public static boolean unique(String s, Vector<ScriptItem> V) {
        boolean unique = true;
        for (int i = 0; i < V.size(); ++i) {
            if (!s.equals(V.get(i).getScriptName())) continue;
            unique = false;
        }
        return unique;
    }

    public static String uniqueScriptName(String base) {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc == null) {
            return base;
        }
        Vector<ScriptItem> V = zc.getScripts();
        if (!JSRun.unique(base, V)) {
            int num = 0;
            while (!JSRun.unique(base = base.replaceAll("[\\s0-9]+$", "") + " " + ++num, V)) {
            }
        }
        return base;
    }

    public static void openEmbeddedScript(String name, String source) {
        JSRun.openEditor();
        JSC.setScriptArea(source);
        JSC.setWindowTitle(Global.Loc("JSeditor.infig") + name);
        JSC.setScriptName(name);
        JSC.selectScriptInfileChk(true);
        JSC.setTextAreaChanged(false);
    }

    public static void openScriptFile(String Filename, boolean forceeditor) {
        JSRun.closeEditor();
        String myscript = "";
        myscript = Filename.equals("") ? FileTools.getOpenFile() : Filename;
        String str = "";
        String mystr = "";
        try {
            FileInputStream input = new FileInputStream(myscript);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)input, "UTF-8"));
            while ((str = in.readLine()) != null) {
                str = str.trim();
                mystr = mystr + str + "\n";
            }
        }
        catch (Exception ex) {
            FILENAME = "";
            return;
        }
        FILENAME = myscript;
        if (!forceeditor && Global.getParameter("jsdumb", false)) {
            JSRun.init();
            JSRun.runScript(mystr);
        } else {
            JSRun.openEditor();
            JSC.setScriptArea(mystr);
            JSC.setWindowTitle(FILENAME);
            JSC.setFileName(FILENAME);
            JSC.setTextAreaChanged(false);
            JSC.selectScriptInfileChk(false);
        }
    }

    private static void refreshZC() {
        if (C != null) {
            C.dovalidate();
            ZC.paint(ZC.getGraphics());
        }
    }

    private static String parseVariables(String s) {
        StringBuffer sb2;
        String origin = "";
        String endtxt = s.replaceAll("([0-9]+)e([0-9]+)", "$1E$2");
        do {
            origin = endtxt;
            StringBuffer sb1 = new StringBuffer();
            Pattern pxy = Pattern.compile("(x|y)_(\\w*)", 2);
            Matcher m = pxy.matcher(origin);
            while (m.find()) {
                Object x = scope.get(m.group(2), (Scriptable)scope);
                if (x == Scriptable.NOT_FOUND) continue;
                m.appendReplacement(sb1, m.group(1) + "(" + Context.toString(x) + ")");
            }
            m.appendTail(sb1);
            m.reset();
            sb2 = new StringBuffer();
            Pattern pexp = Pattern.compile("_(\\w*)", 2);
            m = pexp.matcher(sb1.toString());
            while (m.find()) {
                Object x = scope.get(m.group(1), (Scriptable)scope);
                if (x == Scriptable.NOT_FOUND) continue;
                m.appendReplacement(sb2, Context.toString(x));
            }
            m.appendTail(sb2);
            m.reset();
        } while (!origin.equals(endtxt = sb2.toString()));
        return endtxt;
    }

    public static String Loc(String s) {
        return Global.Loc("JSerror." + s);
    }

    public static String LastObjectName() {
        if (C.last() != null) {
            return C.last().getName();
        }
        return "";
    }

    public static void NormalizeLast() {
        ConstructionObject o = C.last();
        if (o != null) {
            o.setColorType(0);
            o.setShowName(false);
            o.setShowValue(false);
            o.setFilled(false);
            o.setPartial(false);
        }
    }

    public static void Pause(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public static void Print(String a2) {
        if (!console.isVisible()) {
            console.setVisible(true);
        }
        console.print(JSRun.parseVariables(a2));
    }

    public static void Println(String a2) {
        if (!console.isVisible()) {
            console.setVisible(true);
        }
        console.println(JSRun.parseVariables(a2));
    }

    public static Object Input(String msg) {
        Object s = JOptionPane.showInputDialog(JZirkelCanvas.getCurrentZC(), msg, "Input dialog", 3, null, null, "");
        return s;
    }

    public static Object InteractiveInput(String msg, String type) throws Exception {
        Global.setJSO(null);
        Global.setJSquit(false);
        ZC.setJSTool(msg, type);
        while (Global.getJSO() == null) {
            if (!Global.getJSquit()) continue;
            throw new Exception(JSRun.Loc("interactiveinput"));
        }
        return Global.getJSO().getName();
    }

    public static void Prompt(String msg) {
        JOptionPane.showMessageDialog(JZirkelCanvas.getCurrentZC(), JSRun.parseVariables(msg), "Prompt dialog", 2);
    }

    public static void Alert(String msg) {
        JOptionPane.showMessageDialog(JZirkelCanvas.getCurrentZC(), JSRun.parseVariables(msg), "Prompt dialog", 2);
    }

    public static void c(String a2) {
        ZC.JSsend(a2);
    }

    public static String cm(String a2) {
        ZC.JSsend(a2);
        return JSRun.LastObjectName();
    }

    public static void Move(String name, String i, String j) throws Exception {
        ConstructionObject o = C.find(name);
        if (o == null) {
            throw new Exception(JSRun.Loc("notfound"));
        }
        if (!(o instanceof PointObject)) {
            throw new Exception(JSRun.Loc("notgoodtype"));
        }
        try {
            double x = (double)Math.round(Double.valueOf(JSRun.parseVariables(i)) * 1.0E13) / 1.0E13;
            double y = (double)Math.round(Double.valueOf(JSRun.parseVariables(j)) * 1.0E13) / 1.0E13;
            o.move(x, y);
        }
        catch (Exception e2) {
            Expression expX = new Expression(JSRun.parseVariables(i), o.getConstruction(), o);
            Expression expY = new Expression(JSRun.parseVariables(j), o.getConstruction(), o);
            o.move(expX.getValue(), expY.getValue());
        }
        C.dovalidate();
        ZC.paint(ZC.getGraphics());
    }

    public static void Delete(String name) throws Exception {
        ConstructionObject o = C.find(name);
        if (o == null) {
            throw new Exception(JSRun.Loc("notfound"));
        }
        ZC.delete(o);
    }

    public static double GetExpressionValue(String name) throws Exception {
        ConstructionObject o = C.find(name);
        if (o == null) {
            throw new Exception(JSRun.Loc("notfound"));
        }
        if (!(o instanceof ExpressionObject)) {
            throw new Exception(JSRun.Loc("notgoodtype"));
        }
        ExpressionObject oc = (ExpressionObject)o;
        double res = Double.NaN;
        try {
            res = oc.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static void SetExpressionValue(String name, String value) throws Exception {
        ConstructionObject o = C.find(name);
        if (o == null) {
            throw new Exception(JSRun.Loc("notfound"));
        }
        if (!(o instanceof ExpressionObject)) {
            throw new Exception(JSRun.Loc("notgoodtype"));
        }
        ExpressionObject oc = (ExpressionObject)o;
        o.setFixed(JSRun.parseVariables(value));
        JSRun.refreshZC();
    }

    public static double X(String name) throws Exception {
        ConstructionObject o = C.find(name);
        if (o != null) {
            return o.getX();
        }
        throw new Exception(JSRun.Loc("notfound"));
    }

    public static double Y(String name) throws Exception {
        ConstructionObject o = C.find(name);
        if (o != null) {
            return o.getY();
        }
        throw new Exception(JSRun.Loc("notfound"));
    }

    public static void SetColor(String name, String col) {
        String[] names = name.split(",");
        for (int i = 0; i < names.length; ++i) {
            JSRun.c("color(" + col + "," + names[i] + ")");
        }
    }

    public static void SetPointType(String name, String type) {
        String[] names = name.split(",");
        for (int i = 0; i < names.length; ++i) {
            JSRun.c("type(" + type + "," + names[i] + ")");
        }
    }

    public static void SetRGBColor(String name, int r, int g, int b2) {
        Color mycolor = new Color(r, g, b2);
        String[] names = name.split(",");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = C.find(names[i]);
            if (o == null) continue;
            o.setColor(0, mycolor);
        }
    }

    public static void SetThickness(String name, String thc) {
        String[] names = name.split(",");
        for (int i = 0; i < names.length; ++i) {
            JSRun.c("thickness(" + thc + "," + names[i] + ")");
        }
    }

    public static void SetAlias(String name, String alias) {
        String[] names = name.split(",");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = C.find(names[i]);
            if (o == null) continue;
            o.setAlias(alias);
        }
    }

    public static void SetMagneticRay(String name, String ray) {
        ConstructionObject o = C.find(name);
        if (o == null || !(o instanceof PointObject)) {
            return;
        }
        PointObject pt = (PointObject)o;
        pt.setMagnetRayExp(ray);
        C.dovalidate();
        ZC.paint(ZC.getGraphics());
    }

    public static void SetMagneticObjects(String name, String objectlist) {
        ConstructionObject o = C.find(name);
        if (o == null || !(o instanceof PointObject)) {
            return;
        }
        PointObject pt = (PointObject)o;
        pt.setMagnetObjects(JSRun.parseVariables(objectlist));
    }

    public static void AddMagneticObject(String name, String object) {
        ConstructionObject o = C.find(name);
        if (o == null || !(o instanceof PointObject)) {
            return;
        }
        PointObject pt = (PointObject)o;
        pt.addMagnetObject(object);
    }

    public static void SetFixed(String name, boolean bool) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = C.find(names[i]);
            if (o == null) continue;
            o.setFixed(bool);
        }
    }

    public static void SetShowName(String name, boolean bool) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = C.find(names[i]);
            if (o == null) continue;
            o.setShowName(bool);
        }
    }

    public static void SetShowValue(String name, boolean bool) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = C.find(names[i]);
            if (o == null) continue;
            o.setShowValue(bool);
        }
    }

    public static void SetFilled(String name, boolean bool) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = C.find(names[i]);
            if (o == null) continue;
            o.setFilled(bool);
        }
    }

    public static void SetPartial(String name, boolean bool) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = C.find(names[i]);
            if (o == null) continue;
            o.setPartial(bool);
            C.updateCircleDep();
        }
    }

    public static void Shownames() {
        JSRun.cm("shownames");
    }

    public static void Hidenames() {
        JSRun.cm("hidenames");
    }

    public static void Hide(String name) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            JSRun.c("hide(true," + names[i] + ")");
        }
        ZC.paint(ZC.getGraphics());
    }

    public static void SetHide(String name, boolean b2) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            JSRun.c("hide(" + b2 + "," + names[i] + ")");
        }
        ZC.paint(ZC.getGraphics());
    }

    public static void Show(String name) {
        String[] names = JSRun.parseVariables(name).split(",");
        for (int i = 0; i < names.length; ++i) {
            JSRun.c("hide(false," + names[i] + ")");
        }
        ZC.paint(ZC.getGraphics());
    }

    public static void Layer(String name, String exp) throws Exception {
        JSRun.Conditional(name, "z", exp);
    }

    public static void Conditional(String name, String TAG, String expTXT) throws Exception {
        try {
            String[] names = JSRun.parseVariables(name).split(",");
            for (int i = 0; i < names.length; ++i) {
                ConstructionObject O = C.find(names[i]);
                if (O == null) continue;
                O.clearConditional(TAG);
                Expression e2 = new Expression(JSRun.parseVariables(expTXT), C, O);
                if (!e2.isValid()) {
                    throw new Exception(JSRun.Loc("condition"));
                }
                O.addConditional(TAG, e2);
            }
            ZC.recompute();
            ZC.validate();
            ZC.repaint();
        }
        catch (Exception ex) {
            throw new Exception(JSRun.Loc("condition"));
        }
    }

    public static String Point(String name, String x, String y) throws Exception {
        if (name.equals("undefined")) {
            double xx = C.getX() + 2.0 * Math.random() * C.getW() - C.getW();
            double yy = C.getY() - Math.random() * C.getH() + C.getH() / 2.0;
            x = "" + xx;
            y = "" + yy;
            name = "";
        } else if (y.equals("undefined")) {
            y = x;
            x = name;
            name = "";
        }
        PointObject pt = null;
        try {
            pt = new PointObject(C, (double)Math.round(Double.valueOf(x) * 1.0E13) / 1.0E13, (double)Math.round(Double.valueOf(y) * 1.0E13) / 1.0E13);
        }
        catch (Exception e2) {
            try {
                pt = new PointObject(C, 0.0, 0.0);
                pt.setFixed(JSRun.parseVariables(x), JSRun.parseVariables(y));
                pt.validCoordinates();
            }
            catch (Exception ex) {
                throw new Exception(JSRun.Loc("pointcoords"));
            }
        }
        pt.setDefaults();
        if (!name.equals("")) {
            pt.setName(name);
        }
        pt.setColorType(0);
        pt.setShowName(false);
        pt.setShowValue(false);
        pt.validate();
        C.add(pt);
        return pt.getName();
    }

    public static String MidPoint(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("M(" + a2 + "," + b2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=M(" + a2 + "," + b2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Reflection(String name, String d2, String p) throws Exception {
        if (p.equals("undefined")) {
            p = d2;
            d2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("@builtin@/syma(" + d2 + "," + p + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=@builtin@/syma(" + d2 + "," + p + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Translation(String name, String a2, String b2, String p) throws Exception {
        if (p.equals("undefined")) {
            p = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("@builtin@/trans(" + a2 + "," + b2 + "," + p + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=@builtin@/trans(" + a2 + "," + b2 + "," + p + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Symmetry(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("P(2*x(" + a2 + ")-x(" + b2 + "),2*y(" + a2 + ")-y(" + b2 + "))");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=P(2*x(" + a2 + ")-x(" + b2 + "),2*y(" + a2 + ")-y(" + b2 + "))");
        }
        return JSRun.LastObjectName();
    }

    public static String PerpendicularBisector(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("@builtin@/med(" + a2 + "," + b2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=@builtin@/med(" + a2 + "," + b2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String AngleBisector(String name, String a2, String b2, String c2) throws Exception {
        if (c2.equals("undefined")) {
            c2 = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("@builtin@/biss(" + a2 + "," + b2 + "," + c2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=@builtin@/biss(" + a2 + "," + b2 + "," + c2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Circle3pts(String name, String a2, String b2, String c2) throws Exception {
        if (c2.equals("undefined")) {
            c2 = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("@builtin@/circ(" + a2 + "," + b2 + "," + c2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=@builtin@/circ(" + a2 + "," + b2 + "," + c2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Circle3(String name, String a2, String b2, String c2) throws Exception {
        if (c2.equals("undefined")) {
            c2 = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("c(" + a2 + "," + b2 + "," + c2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=c(" + a2 + "," + b2 + "," + c2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Arc3pts(String name, String a2, String b2, String c2) throws Exception {
        if (c2.equals("undefined")) {
            c2 = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("@builtin@/arc(" + a2 + "," + b2 + "," + c2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=@builtin@/arc(" + a2 + "," + b2 + "," + c2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Intersection(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("I(" + a2 + "," + b2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=I(" + a2 + "," + b2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Intersection2(String name1, String name2, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name2;
            name2 = name1;
            name1 = "";
            if (b2.equals("undefined")) {
                b2 = a2;
                a2 = name2;
                name2 = "";
            }
        }
        if (name1.equals("")) {
            JSRun.c("I1,I2=I(" + a2 + "," + b2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name1 + "," + name2 + "=I(" + a2 + "," + b2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Line(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("l(" + a2 + "," + b2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=l(" + a2 + "," + b2 + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String Ray(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("r(" + a2 + "," + b2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=r(" + a2 + "," + b2 + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String Angle(String name, String a2, String b2, String c2) {
        if (c2.equals("undefined")) {
            c2 = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("a(" + a2 + "," + b2 + "," + c2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=a(" + a2 + "," + b2 + "," + c2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String FixedAngle(String name, String a2, String b2, String c2) {
        if (c2.equals("undefined")) {
            c2 = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("a(" + a2 + "," + b2 + "," + c2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=a(" + a2 + "," + b2 + "," + c2 + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String ExecuteMacro(String lastObjName, String macroname, String params) {
        if (params.equals("undefined")) {
            params = macroname;
            macroname = lastObjName;
            lastObjName = "";
        }
        if (lastObjName.equals("")) {
            JSRun.c(macroname + "(" + JSRun.parseVariables(params) + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(lastObjName + "=" + macroname + "(" + JSRun.parseVariables(params) + ")");
        }
        return JSRun.LastObjectName();
    }

    public static String Polygon(String name, String params) {
        if (params.equals("undefined")) {
            params = name;
            name = "";
        }
        String[] c2 = JSRun.parseVariables(params).split(",");
        Vector<PointObject> V = new Vector<PointObject>();
        for (int i = 0; i < c2.length; ++i) {
            ConstructionObject o = C.find(c2[i]);
            if (o == null) continue;
            V.add((PointObject)o);
        }
        AreaObject poly = new AreaObject(C, V);
        poly.setDefaults();
        if (!name.equals("")) {
            poly.setName(name);
        }
        poly.validate();
        C.add(poly);
        return JSRun.LastObjectName();
    }

    public static String Quadric(String name, String a2, String b2, String c2, String d2, String e2) {
        if (e2.equals("undefined")) {
            e2 = d2;
            d2 = c2;
            c2 = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("quadric(" + a2 + "," + b2 + "," + c2 + "," + d2 + "," + e2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=quadric(" + a2 + "," + b2 + "," + c2 + "," + d2 + "," + e2 + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String CartesianFunction(String name, String a2, String b2, String fx) {
        if (fx.equals("undefined")) {
            fx = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        FunctionObject f2 = new FunctionObject(C);
        f2.setDefaults();
        if (!name.equals("")) {
            f2.setName(name);
        }
        f2.setExpressions("x", "", fx);
        if (!a2.equals("") && !b2.equals("")) {
            f2.setRange(a2, b2, "0");
        }
        C.add(f2);
        C.dovalidate();
        ZC.paint(ZC.getGraphics());
        JSRun.NormalizeLast();
        return f2.getName();
    }

    public static String ParametricFunction(String name, String a2, String b2, String xt, String yt) {
        if (yt.equals("undefined")) {
            yt = xt;
            xt = b2;
            b2 = a2;
            a2 = name;
            name = "";
        }
        FunctionObject f2 = new FunctionObject(C);
        f2.setDefaults();
        if (!name.equals("")) {
            f2.setName(name);
        }
        f2.setExpressions("t", xt, yt);
        if (!a2.equals("") && !b2.equals("")) {
            f2.setRange(a2, b2, "0");
        }
        C.add(f2);
        C.dovalidate();
        ZC.paint(ZC.getGraphics());
        JSRun.NormalizeLast();
        return f2.getName();
    }

    public static String FixedSegment(String name, String a2, String r) {
        if (r.equals("undefined")) {
            r = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("s(" + a2 + "," + r + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=s(" + a2 + "," + r + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String Segment(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        SegmentObject so = null;
        try {
            so = new SegmentObject(C, (PointObject)C.find(a2), (PointObject)C.find(b2));
        }
        catch (Exception e2) {
            return "";
        }
        so.setDefaults();
        if (!name.equals("")) {
            so.setName(name);
        }
        so.setArrow(false);
        so.setColorType(0);
        so.setShowName(false);
        so.setShowValue(false);
        so.validate();
        C.add(so);
        return so.getName();
    }

    public static String Vector(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        SegmentObject so = null;
        try {
            so = new SegmentObject(C, (PointObject)C.find(a2), (PointObject)C.find(b2));
        }
        catch (Exception e2) {
            return "";
        }
        so.setDefaults();
        if (!name.equals("")) {
            so.setName(name);
        }
        so.setArrow(true);
        so.setColorType(0);
        so.setShowName(false);
        so.setShowValue(false);
        C.add(so);
        return so.getName();
    }

    public static String Circle(String name, String a2, String b2) {
        if (b2.equals("undefined")) {
            b2 = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("c(" + a2 + "," + b2 + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=c(" + a2 + "," + b2 + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String FixedCircle(String name, String a2, String r) {
        if (r.equals("undefined")) {
            r = a2;
            a2 = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("c(" + a2 + "," + r + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=c(" + a2 + "," + r + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String Parallel(String name, String lne, String pt) {
        if (pt.equals("undefined")) {
            pt = lne;
            lne = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("par(" + lne + "," + pt + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=par(" + lne + "," + pt + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String Perpendicular(String name, String lne, String pt) {
        if (pt.equals("undefined")) {
            pt = lne;
            lne = name;
            name = "";
        }
        if (name.equals("")) {
            JSRun.c("perp(" + lne + "," + pt + ")");
            C.last().setShowName(false);
        } else {
            JSRun.c(name + "=perp(" + lne + "," + pt + ")");
        }
        JSRun.NormalizeLast();
        return JSRun.LastObjectName();
    }

    public static String Expression(String name, String exp, String x, String y) {
        if (y.equals("undefined")) {
            y = x;
            x = exp;
            exp = name;
            name = "";
        }
        exp = JSRun.parseVariables(exp);
        ExpressionObject p = new ExpressionObject(C, 0.0, 0.0);
        p.setDefaults();
        if (!name.equals("")) {
            p.setName(name);
        }
        try {
            p.setExpression(exp, C);
        }
        catch (Exception e2) {
            return "";
        }
        try {
            double xx = (double)Math.round(Double.valueOf(x) * 1.0E13) / 1.0E13;
            double yy = (double)Math.round(Double.valueOf(y) * 1.0E13) / 1.0E13;
            p.move(xx, yy);
        }
        catch (Exception e3) {
            x = JSRun.parseVariables(x);
            y = JSRun.parseVariables(y);
            p.setFixed(x, y);
        }
        C.add(p);
        JSRun.NormalizeLast();
        p.setShowValue(true);
        C.dovalidate();
        ZC.paint(ZC.getGraphics());
        return p.getName();
    }
}

