/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.JSprogram;

import carmetal.eric.JBrowserLauncher;
import carmetal.eric.JSprogram.JSBlankIcon;
import carmetal.eric.JSprogram.JSButton;
import carmetal.eric.JSprogram.JSIcon;
import carmetal.eric.JSprogram.JSRun;
import carmetal.eric.JSprogram.LineNumberView;
import carmetal.eric.JSprogram.myJTitleBar;
import carmetal.eric.JSprogram.myJVerticalSeparatorPanel;
import carmetal.eric.JSprogram.myStatusBarPanel;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.OS;
import carmetal.rene.gui.Global;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class JSConsole
extends JFrame {
    StyledDocument doc;
    final int ctrlkey = OS.isMac() ? 256 : 128;
    private boolean NoTypeNoClic = true;
    UndoManager undo;
    private Point origin;
    private Point winloc;
    private Point current;
    private int xx;
    private int yy;
    private int w;
    private int h;
    private int JSsel = 0;
    private String filename = "";
    private String scriptname = "";
    private char endline = "\n".charAt(0);
    private ArrayList<Integer> braces;
    private JList JSlist;
    private JPanel LeftBorder;
    private JPanel RightBorder;
    private JPanel action_buttons;
    private JButton backbtn;
    private JPanel c_carmetal;
    private JPanel c_js;
    private JButton closeBTN;
    private JPanel commands;
    private JPanel controls;
    private JLabel errormessagelabel;
    private JPanel errorpanel;
    private JLabel errortitlelabel;
    private JCheckBox infilechk;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel js_btns;
    private JPanel macpanel;
    private JButton openbtn;
    private JButton openbtn2;
    private JButton openbtn3;
    private JButton openbtn4;
    private JButton openbtn5;
    private JButton savebtn;
    private JButton savebtn1;
    private JTextPane script_area;
    private JLabel title_lbl;
    private JPanel winpanel;

    public JSConsole() {
        this.initComponents();
        this.doc = this.script_area.getStyledDocument();
        this.initCaRMetalBtns();
        this.initScriptArea();
        this.initUndoRedo();
        this.initJSlist();
        this.setWindowTitle(JSConsole.Loc("JSeditor.title"));
        if (OS.isMac()) {
            JSConsole.fixsize(this.macpanel, 1, 1);
            this.winpanel.removeAll();
            this.winpanel.add(this.title_lbl);
            this.winpanel.revalidate();
        } else {
            JSConsole.fixsize(this.winpanel, 1, 1);
        }
        this.setLocationRelativeTo(JZirkelCanvas.getCurrentZC());
        this.errorpanel.removeAll();
        this.errorpanel.revalidate();
        this.setTabs(this.script_area, 3);
        this.setSize(750, 500);
        ToolTipManager.sharedInstance().setInitialDelay(50);
        JSRun.init();
        this.setVisible(true);
    }

    public void setBackBtnEnabled(boolean bool) {
        this.backbtn.setEnabled(bool);
    }

    public void selectScriptInfileChk(boolean b2) {
        this.infilechk.setSelected(b2);
    }

    public void setScriptName(String s) {
        this.scriptname = s;
    }

    public String getScriptName() {
        return this.scriptname;
    }

    public void setFileName(String s) {
        this.filename = s;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setWindowTitle(String s) {
        this.title_lbl.setText(s);
    }

    public String getWindowTitle() {
        return this.title_lbl.getText();
    }

    public boolean isFileOpened() {
        return !this.filename.equals("");
    }

    private void initJSlist() {
    }

    static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public void NoTypeNoClic() {
        this.NoTypeNoClic = true;
    }

    public void addOrChange(String st) {
        if (this.NoTypeNoClic) {
            this.undo.undo();
        } else {
            this.NoTypeNoClic();
        }
        this.addToScript(st);
    }

    public void addToScript(String st) {
        this.script_area.requestFocus();
        this.script_area.replaceSelection(st);
        this.script_area.requestFocus();
    }

    public void clearSelection() {
        this.script_area.replaceSelection("");
        this.script_area.requestFocus();
    }

    public JSIcon addCMicon(String obj, String syntax) {
        JSIcon jsi = new JSIcon(this, obj, syntax);
        this.c_carmetal.add(jsi);
        return jsi;
    }

    public JSButton addJSIcon(String obj, final String example) {
        JSButton jb = new JSButton(obj, 24, true);
        jb.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                JSConsole.this.addToScript(example);
            }
        });
        this.js_btns.add(jb);
        return jb;
    }

    public void addBlankIcon(int nb, int size) {
        for (int i = 0; i < nb; ++i) {
            this.c_carmetal.add(new JSBlankIcon(size));
        }
    }

    public void addSeparator(int nb) {
        JSeparator jSeparator1 = new JSeparator();
        jSeparator1.setPreferredSize(new Dimension(170, nb));
        jSeparator1.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.c_carmetal.add(jSeparator1);
    }

    public void syntaxColoring() {
        int end;
        int start;
        int i;
        Matcher m;
        String[] keynames = new String[]{"for", "while", "if", "else", "do", "new", "function", "true", "false", "var", "return"};
        String[] mathkeynames = new String[]{"Math.PI", "Math.sin", "Math.cos", "Math.tan", "Math.asin", "Math.acos", "Math.atan", "Math.abs", "Math.ceil", "Math.round", "Math.min", "Math.max", "Math.floor", "Math.PI", "Math.E", "Math.pow", "Math.exp", "Math.log", "Math.sqrt", "Math.LN10", "Math.random", "Math.LN2", "Math.LOG2E"};
        String scp = "\n" + this.script_area.getText() + "\n";
        String[] allnames = JSRun.getKeywords();
        ArrayList<Integer> carmetal_matches = new ArrayList<Integer>();
        for (int i2 = 1; i2 < allnames.length; ++i2) {
            Matcher m2 = Pattern.compile("\\W{1}(\\Q" + allnames[i2] + "\\E)\\W{1}", 8).matcher(scp);
            while (m2.find()) {
                carmetal_matches.add(m2.start(1) - 1);
                carmetal_matches.add(m2.end(1) - 1);
            }
        }
        ArrayList<Integer> js_matches = new ArrayList<Integer>();
        for (int i3 = 0; i3 < keynames.length; ++i3) {
            Matcher m3 = Pattern.compile("\\W{1}(\\Q" + keynames[i3] + "\\E)\\W{1}", 8).matcher(scp);
            while (m3.find()) {
                js_matches.add(m3.start(1) - 1);
                js_matches.add(m3.end(1) - 1);
            }
        }
        ArrayList<Integer> js_maths_matches = new ArrayList<Integer>();
        for (int i4 = 0; i4 < mathkeynames.length; ++i4) {
            m = Pattern.compile("\\W{1}(\\Q" + mathkeynames[i4] + "\\E)\\W{1}", 8).matcher(scp);
            while (m.find()) {
                js_maths_matches.add(m.start(1) - 1);
                js_maths_matches.add(m.end(1) - 1);
            }
        }
        ArrayList<Integer> js_comments = new ArrayList<Integer>();
        m = Pattern.compile("(\\Q//\\E[^\n]*)", 8).matcher(scp);
        while (m.find()) {
            js_comments.add(m.start(1) - 1);
            js_comments.add(m.end(1) - 1);
        }
        ArrayList<Integer> text_matches = new ArrayList<Integer>();
        m = Pattern.compile("\"([^\"]*)\"", 8).matcher(scp);
        while (m.find()) {
            text_matches.add(m.start(1) - 1);
            text_matches.add(m.end(1) - 1);
        }
        this.doc.setCharacterAttributes(0, this.script_area.getText().length(), this.script_area.getStyle("Normal"), true);
        for (i = 0; i < carmetal_matches.size(); i += 2) {
            start = (Integer)carmetal_matches.get(i);
            end = (Integer)carmetal_matches.get(i + 1);
            this.doc.setCharacterAttributes(start, end - start, this.script_area.getStyle("CMkeyword"), true);
        }
        for (i = 0; i < js_matches.size(); i += 2) {
            start = (Integer)js_matches.get(i);
            end = (Integer)js_matches.get(i + 1);
            this.doc.setCharacterAttributes(start, end - start, this.script_area.getStyle("Blue"), true);
        }
        for (i = 0; i < js_maths_matches.size(); i += 2) {
            start = (Integer)js_maths_matches.get(i);
            end = (Integer)js_maths_matches.get(i + 1);
            this.doc.setCharacterAttributes(start, end - start, this.script_area.getStyle("Math_keyword"), true);
        }
        for (i = 0; i < text_matches.size(); i += 2) {
            start = (Integer)text_matches.get(i);
            end = (Integer)text_matches.get(i + 1);
            this.doc.setCharacterAttributes(start, end - start, this.script_area.getStyle("Green"), true);
        }
        for (i = 0; i < js_comments.size(); i += 2) {
            start = (Integer)js_comments.get(i);
            end = (Integer)js_comments.get(i + 1);
            this.doc.setCharacterAttributes(start, end - start, this.script_area.getStyle("Comment"), true);
        }
    }

    public void clearStatusBar() {
        this.errorpanel.removeAll();
        this.errorpanel.revalidate();
        this.errorpanel.repaint();
    }

    public void setTextAreaChanged(boolean bool) {
        this.savebtn.setEnabled(bool);
    }

    public boolean isTextAreaChanged() {
        Boolean bool = !this.script_area.getText().equals("") && this.savebtn.isEnabled();
        return bool;
    }

    public boolean cancelSaveChanges() {
        if (this.getFileName().equals("") && !this.getScriptName().equals("")) {
            return false;
        }
        if (this.isTextAreaChanged()) {
            this.setAlwaysOnTop(true);
            int n = JOptionPane.showConfirmDialog(this, JSConsole.Loc("JSEditor.savequestion"), "", 1);
            this.setAlwaysOnTop(false);
            if (n == 2) {
                return true;
            }
            if (n == 0) {
                JSRun.saveScript(this.script_area.getText(), false);
            }
        }
        return false;
    }

    public void initScriptArea() {
        this.script_area.setText("\n");
        this.script_area.setText("");
        Style style = this.script_area.addStyle("Normal", null);
        StyleConstants.setForeground(style, new Color(70, 70, 70));
        style = this.script_area.addStyle("CMkeyword", null);
        StyleConstants.setForeground(style, new Color(143, 69, 0));
        StyleConstants.setBold(style, true);
        style = this.script_area.addStyle("Math_keyword", null);
        StyleConstants.setForeground(style, new Color(194, 151, 0));
        StyleConstants.setBold(style, true);
        style = this.script_area.addStyle("Green", null);
        StyleConstants.setForeground(style, new Color(0, 153, 116));
        StyleConstants.setBold(style, true);
        style = this.script_area.addStyle("Blue", null);
        StyleConstants.setForeground(style, new Color(0, 95, 163));
        StyleConstants.setBold(style, true);
        style = this.script_area.addStyle("Comment", null);
        StyleConstants.setForeground(style, new Color(150, 150, 150));
        StyleConstants.setItalic(style, true);
        style = this.script_area.addStyle("Red", null);
        StyleConstants.setForeground(style, Color.red);
        style = this.script_area.addStyle("Red Underline", style);
        StyleConstants.setUnderline(style, true);
        style = this.script_area.addStyle("24pts", null);
        StyleConstants.setFontSize(style, 24);
        style = this.script_area.addStyle("12pts", null);
        StyleConstants.setFontSize(style, 12);
        style = this.script_area.addStyle("Italic", null);
        StyleConstants.setItalic(style, true);
        style = this.script_area.addStyle("Bold Italic", null);
        StyleConstants.setBold(style, true);
        StyleConstants.setItalic(style, true);
        this.script_area.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e2) {
                JSConsole.this.setTextAreaChanged(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSConsole.this.syntaxColoring();
                    }
                });
                if (JSConsole.this.infilechk.isSelected()) {
                    JSRun.saveScriptInConstruction();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                JSConsole.this.setTextAreaChanged(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSConsole.this.syntaxColoring();
                    }
                });
                if (JSConsole.this.infilechk.isSelected()) {
                    JSRun.saveScriptInConstruction();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
        this.script_area.setFont(new Font("monospaced", 0, 13));
        this.script_area.setMargin(new Insets(0, 5, 0, 0));
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.script_area.getInputMap().put(enter, "enterCommand");
        this.script_area.getActionMap().put("enterCommand", new AbstractAction("enterCommand"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.FindDelimiters();
                int t = JSConsole.this.tabIndent(JSConsole.this.script_area.getCaretPosition());
                JSConsole.this.script_area.replaceSelection("\n" + JSConsole.this.tabs(t));
            }
        });
        KeyStroke comment = KeyStroke.getKeyStroke(67, this.ctrlkey + 64);
        this.script_area.getInputMap().put(comment, "commentCommand");
        this.script_area.getActionMap().put("commentCommand", new AbstractAction("commentCommand"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.commentSelection();
            }
        });
        this.jScrollPane1.setRowHeaderView(new LineNumberView(this.script_area));
    }

    public String getScript() {
        return this.script_area.getText();
    }

    public void setScriptArea(String s) {
        this.script_area.setText(s);
        this.Format();
    }

    private boolean firstLineCar(int pos) {
        if (pos == 0) {
            return true;
        }
        return this.script_area.getText().charAt(pos - 1) == this.endline;
    }

    public int linestartAt(int pos) {
        while (!this.firstLineCar(pos)) {
            --pos;
        }
        return pos;
    }

    private boolean lastLineCar(int pos) {
        if (pos == this.script_area.getText().length()) {
            return true;
        }
        return this.script_area.getText().charAt(pos) == this.endline;
    }

    public int lineendAt(int pos) {
        while (!this.lastLineCar(pos)) {
            ++pos;
        }
        return pos;
    }

    public void commentSelection() {
        int caret = this.script_area.getCaretPosition();
        int start = this.script_area.getSelectionStart();
        int end = this.script_area.getSelectionEnd();
        this.script_area.setSelectionStart(this.linestartAt(start));
        this.script_area.setSelectionEnd(this.lineendAt(end));
        String mystr = this.script_area.getSelectedText();
        int caretoffs = 2;
        if (mystr == null) {
            mystr = "";
        }
        mystr = "\n" + mystr;
        if (Pattern.compile("\n([ \t]*)\\Q//\\E", 8).matcher(mystr).find()) {
            mystr = Pattern.compile("\n([ \t]*)\\Q//\\E", 8).matcher(mystr).replaceAll("\n$1");
            caretoffs = -2;
        } else {
            mystr = mystr.replaceAll("\n", "\n//");
        }
        mystr = mystr.substring(1);
        this.script_area.replaceSelection(mystr);
        this.script_area.setCaretPosition(caret + caretoffs);
    }

    public void initCaRMetalBtns() {
        this.addCMicon("point", "<var,null>=Point(<null,name>,<nb,var,exp>,<nb,var,exp>);");
        this.addCMicon("intersection", "<var,null>=Intersection(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("midpoint", "<var,null>=MidPoint(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("bi_syma", "<var,null>=Reflection(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("bi_symc", "<var,null>=Symmetry(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("bi_trans", "<var,null>=Translation(<null,name>,<name,var>,<name,var>,<name,var>);");
        this.addCMicon("line", "<var,null>=Line(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("ray", "<var,null>=Ray(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("parallel", "<var,null>=Parallel(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("plumb", "<var,null>=Perpendicular(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("bi_med", "<var,null>=PerpendicularBisector(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("bi_biss", "<var,null>=AngleBisector(<null,name>,<name,var>,<name,var>,<name,var>);");
        this.addCMicon("segment", "<var,null>=Segment(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("fixedsegment", "<var,null>=FixedSegment(<null,name>,<name,var>,<nb,var>);");
        this.addCMicon("vector", "<var,null>=Vector(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("area", "<var,null>=Polygon(<null,name>,<objs>);");
        this.addCMicon("angle", "<var,null>=Angle(<null,name>,<name,var>,<name,var>,<name,var>);");
        this.addCMicon("fixedangle", "<var,null>=FixedAngle(<null,name>,<name,var>,<name,var>,<nb,var,exp>);");
        this.addCMicon("circle", "<var,null>=Circle(<null,name>,<name,var>,<name,var>);");
        this.addCMicon("fixedcircle", "<var,null>=FixedCircle(<null,name>,<name,var>,<nb,exp>);");
        this.addCMicon("circle3", "<var,null>=Circle3(<null,name>,<name,var>,<name,var>,<name,var>);");
        this.addCMicon("bi_circ", "<var,null>=Circle3pts(<null,name>,<name,var>,<name,var>,<name,var>);");
        this.addCMicon("bi_arc", "<var,null>=Arc3pts(<null,name>,<name,var>,<name,var>,<name,var>);");
        this.addCMicon("quadric", "<var,null>=Quadric(<null,name>,<name,var>,<name,var>,<name,var>,<name,var>,<name,var>);");
        this.addCMicon("expression", "<var,null>=Expression(<null,name>,\"Votre expression\",<nb>,<nb>);");
        this.addCMicon("function", "<var,null>=CartesianFunction(<null,name>,-5,5,\"x^2-2*x+1\");");
        this.addCMicon("parametricfunction", "<var,null>=ParametricFunction(<null,name>,-3.14,3.14,\"3*rcos(t)^3\",\"3*rsin(t)^3\");");
        this.addSeparator(1);
        this.addCMicon("interactiveinput", "<var>=InteractiveInput(\"Message\",<\"Point,Segment,Line,Circle\">);");
        this.addCMicon("aimant", "SetMagneticObjects(<name,var>,<objs,var>);");
        this.addCMicon("hide", "SetHide(<objs,var>,<\"true,false\">);");
        this.addCMicon("type2", "SetPointType(<objs,var>,<\"square,circle,diamond,point,cross,dcross\">);");
        this.addCMicon("color4", "SetColor(<objs,var>,<\"green,blue,brown,cyan,red,black\">);");
        this.addCMicon("thickness1", "SetThickness(<objs,var>,<\"thick,normal,thin\">);");
        this.addCMicon("partial", "SetPartial(<objs,var>,<\"true,false\">);");
        this.addCMicon("showvalue", "SetShowValue(<objs,var>,<\"true,false\">);");
        this.addCMicon("showname", "SetShowName(<objs,var>,<\"true,false\">);");
        this.addCMicon("filled", "SetFilled(<objs,var>,<\"true,false\">);");
        this.addJSIcon("js_cos", "Math.cos(x)");
        this.addJSIcon("js_sin", "Math.sin(x)");
        this.addJSIcon("js_tan", "Math.tan(x)");
        this.addJSIcon("js_acos", "Math.acos(x)");
        this.addJSIcon("js_asin", "Math.asin(x)");
        this.addJSIcon("js_atan", "Math.atan(x)");
        this.addJSIcon("js_abs", "Math.abs(x)");
        this.addJSIcon("js_ceil", "Math.ceil(x)");
        this.addJSIcon("js_floor", "Math.floor(x)");
        this.addJSIcon("js_round", "Math.round(x)");
        this.addJSIcon("js_min", "Math.min(x,y)");
        this.addJSIcon("js_max", "Math.max(x,y)");
        this.addJSIcon("js_pi", "Math.PI");
        this.addJSIcon("js_e", "Math.E");
        this.addJSIcon("js_xn", "Math.pow(x,n)");
        this.addJSIcon("js_ex", "Math.exp(x)");
        this.addJSIcon("js_ln", "Math.log(x)");
        this.addJSIcon("js_sqrt", "Math.sqrt(x)");
    }

    public void initUndoRedo() {
        this.undo = new UndoManager(){

            @Override
            public synchronized boolean addEdit(UndoableEdit anEdit) {
                AbstractDocument.DefaultDocumentEvent de;
                if (anEdit instanceof AbstractDocument.DefaultDocumentEvent && (de = (AbstractDocument.DefaultDocumentEvent)anEdit).getType() == DocumentEvent.EventType.CHANGE) {
                    return false;
                }
                return super.addEdit(anEdit);
            }
        };
        this.script_area.getStyledDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e2) {
                JSConsole.this.undo.addEdit(e2.getEdit());
            }
        });
        this.script_area.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JSConsole.this.undo.canUndo()) {
                        JSConsole.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.script_area.getInputMap().put(KeyStroke.getKeyStroke(90, this.ctrlkey), "Undo");
        this.script_area.getInputMap().put(KeyStroke.getKeyStroke(89, this.ctrlkey), "Redo");
        this.script_area.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JSConsole.this.undo.canRedo()) {
                        JSConsole.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
    }

    private void selectLine(int linenumber) {
        Element root = this.script_area.getDocument().getDefaultRootElement();
        Element myline = root.getElement(linenumber - 1);
        int start = myline.getStartOffset();
        int end = myline.getEndOffset();
        this.script_area.select(start, end);
    }

    public static String Loc(String s) {
        return Global.Loc(s);
    }

    public void Error(String errormessage) {
        StringBuffer sb = new StringBuffer();
        int errorline = 1;
        Pattern p = Pattern.compile("\\([^#]*#([0-9]+)\\)", 2);
        Matcher m = p.matcher(errormessage);
        if (m.find()) {
            errorline = Integer.parseInt(m.group(1)) + 1;
            m.appendReplacement(sb, "");
        } else {
            sb = sb.append(errormessage);
        }
        this.errorpanel.removeAll();
        this.errortitlelabel.setText(" " + JSConsole.Loc("JSerror.title") + " (" + JSConsole.Loc("JSerror.line") + " " + errorline + ") :");
        this.errormessagelabel.setText(sb.toString());
        this.errorpanel.add(this.errortitlelabel);
        this.errorpanel.add(this.errormessagelabel);
        this.errorpanel.revalidate();
        this.errorpanel.repaint();
        this.selectLine(errorline);
    }

    public void setTabs(JTextPane textPane, int charactersPerTab) {
        FontMetrics fm = textPane.getFontMetrics(textPane.getFont());
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        Style style = textPane.getLogicalStyle();
        StyleConstants.setTabSet(style, tabSet);
        textPane.setLogicalStyle(style);
    }

    private int tabIndent(int carnum) {
        int priority = 0;
        for (int i = 0; i < this.braces.size() && carnum > this.braces.get(i); i += 2) {
            priority = this.braces.get(i + 1);
        }
        return priority;
    }

    private void shiftposition(int lg, int sh) {
        for (int i = 0; i < this.braces.size(); i += 2) {
            if (this.braces.get(i) <= lg) continue;
            this.braces.set(i, this.braces.get(i) + sh);
        }
    }

    private String tabs(int t) {
        String st = "";
        for (int i = 0; i < t; ++i) {
            st = st + "\t";
        }
        return st;
    }

    private void indentText() {
        String alltxt = this.script_area.getText();
        String newtxt = "";
        int length = 0;
        boolean linenum = true;
        BufferedReader reader = new BufferedReader(new StringReader(alltxt));
        try {
            String myline;
            while ((myline = reader.readLine()) != null) {
                int tabnb = this.tabIndent(length);
                if (myline.matches("^[ \t]*}.*$")) {
                    --tabnb;
                }
                String newline = myline.replaceAll("^([ \t]*)([^ \t])", this.tabs(tabnb) + "$2");
                int shift = newline.length() - myline.length();
                newtxt = newtxt + newline + "\n";
                length += newline.length() + 1;
                this.shiftposition(myline.length(), shift);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.script_area.setText(newtxt);
    }

    private void FindDelimiters() {
        char openedbrace = "{".charAt(0);
        char closedbrace = "}".charAt(0);
        char quotemark = "\"".charAt(0);
        char backslash = "\\".charAt(0);
        this.braces = new ArrayList();
        String alltxt = this.script_area.getText();
        boolean inquote = false;
        char oldcur = '\u0000';
        char cur = '\u0000';
        int bracesnum = 0;
        int oldbracesnum = 0;
        for (int i = 0; i < alltxt.length(); ++i) {
            oldcur = cur;
            cur = alltxt.charAt(i);
            if (cur == quotemark && oldcur != backslash) {
                boolean bl = inquote = !inquote;
            }
            if (inquote) continue;
            if (alltxt.charAt(i) == openedbrace) {
                this.braces.add(i);
                this.braces.add(++bracesnum);
                oldbracesnum = bracesnum;
                continue;
            }
            if (alltxt.charAt(i) != closedbrace) continue;
            this.braces.add(i);
            this.braces.add(--bracesnum);
            oldbracesnum = bracesnum;
        }
    }

    private String replace(String s, String reg, String repl) {
        String st = "";
        while (!s.equals(st)) {
            st = s;
            s = Pattern.compile(reg, 40).matcher(s).replaceAll(repl);
        }
        return st;
    }

    private void Format() {
        int i = this.script_area.getCaretPosition();
        String alltxt = this.script_area.getText();
        alltxt = this.replace(alltxt, "\\Q}\\E[ \t]*\\Q}\\E[ \t]*\n", "\n}\n}\n");
        alltxt = this.replace(alltxt, ";[ \t]*\\Q}\\E[ \t]*\n", ";\n}\n");
        alltxt = alltxt.replaceAll("\\Q}\\E[ \t]*\\Qelse\\E[ \t]*\\Q{\\E", "} else {");
        alltxt = alltxt.replaceAll("\n[ \t]*\\Q{\\E[ \t]*\n", "{\n");
        this.script_area.setText(alltxt);
        this.FindDelimiters();
        this.indentText();
        try {
            this.script_area.setCaretPosition(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jPanel3 = new myJTitleBar();
        this.macpanel = new JPanel();
        this.title_lbl = new JLabel();
        this.closeBTN = new JButton();
        this.winpanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.LeftBorder = new myJVerticalSeparatorPanel();
        this.jPanel15 = new JPanel();
        this.jPanel2 = new JPanel();
        this.action_buttons = new JPanel();
        this.jPanel6 = new JPanel();
        this.openbtn = new JButton();
        this.jPanel7 = new JPanel();
        this.savebtn = new JButton();
        this.jPanel8 = new JPanel();
        this.savebtn1 = new JButton();
        this.jPanel17 = new JPanel();
        this.jPanel9 = new JPanel();
        this.infilechk = new JCheckBox();
        this.jPanel18 = new JPanel();
        this.openbtn5 = new JButton();
        this.jPanel16 = new JPanel();
        this.openbtn2 = new JButton();
        this.jPanel10 = new JPanel();
        this.backbtn = new JButton();
        this.jPanel11 = new JPanel();
        this.openbtn3 = new JButton();
        this.jPanel12 = new JPanel();
        this.openbtn4 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.script_area = new JTextPane();
        this.jPanel14 = new JPanel();
        this.commands = new JPanel();
        this.jLabel1 = new JLabel();
        this.c_carmetal = new JPanel();
        this.c_js = new JPanel();
        this.jLabel2 = new JLabel();
        this.js_btns = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.JSlist = new JList();
        this.RightBorder = new myJVerticalSeparatorPanel();
        this.controls = new myStatusBarPanel();
        this.jPanel13 = new JPanel();
        this.errorpanel = new JPanel();
        this.errortitlelabel = new JLabel();
        this.errormessagelabel = new JLabel();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(245, 245, 245));
        this.setUndecorated(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JSConsole.this.formWindowClosing(evt);
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                JSConsole.this.formWindowClosed(evt);
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                JSConsole.this.formWindowActivated(evt);
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                JSConsole.this.formWindowDeactivated(evt);
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.jPanel3.setMinimumSize(new Dimension(0, 25));
        this.jPanel3.setPreferredSize(new Dimension(199, 25));
        this.jPanel3.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JSConsole.this.jPanel3MouseDragged(evt);
            }
        });
        this.jPanel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSConsole.this.jPanel3MousePressed(evt);
            }
        });
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 0));
        this.macpanel.setAlignmentX(0.0f);
        this.macpanel.setEnabled(false);
        this.macpanel.setFocusable(false);
        this.macpanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.macpanel.setMinimumSize(new Dimension(0, 25));
        this.macpanel.setOpaque(false);
        this.macpanel.setPreferredSize(new Dimension(523, 25));
        this.macpanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JSConsole.this.macpanelMouseDragged(evt);
            }
        });
        this.macpanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSConsole.this.macpanelMousePressed(evt);
            }
        });
        this.macpanel.setLayout(new BoxLayout(this.macpanel, 0));
        this.title_lbl.setHorizontalAlignment(0);
        this.title_lbl.setText("jLabel3");
        this.title_lbl.setHorizontalTextPosition(0);
        this.title_lbl.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.title_lbl.setMinimumSize(new Dimension(0, 25));
        this.title_lbl.setPreferredSize(new Dimension(45, 25));
        this.macpanel.add(this.title_lbl);
        this.jPanel3.add(this.macpanel);
        this.closeBTN.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/themes/gray/zclosebutton.png")));
        this.closeBTN.setBorder(null);
        this.closeBTN.setBorderPainted(false);
        this.closeBTN.setContentAreaFilled(false);
        this.closeBTN.setFocusPainted(false);
        this.closeBTN.setFocusable(false);
        this.closeBTN.setMaximumSize(new Dimension(25, 30));
        this.closeBTN.setMinimumSize(new Dimension(25, 30));
        this.closeBTN.setPreferredSize(new Dimension(25, 30));
        this.closeBTN.setRolloverIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/themes/gray/zclosebuttonover.png")));
        this.closeBTN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.closeBTNMouseClicked(evt);
            }
        });
        this.jPanel3.add(this.closeBTN);
        this.winpanel.setAlignmentX(0.0f);
        this.winpanel.setEnabled(false);
        this.winpanel.setFocusable(false);
        this.winpanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.winpanel.setMinimumSize(new Dimension(0, 25));
        this.winpanel.setOpaque(false);
        this.winpanel.setPreferredSize(new Dimension(523, 25));
        this.winpanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JSConsole.this.winpanelMouseDragged(evt);
            }
        });
        this.winpanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSConsole.this.winpanelMousePressed(evt);
            }
        });
        this.winpanel.setLayout(new BoxLayout(this.winpanel, 0));
        this.jPanel3.add(this.winpanel);
        this.getContentPane().add(this.jPanel3);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 0));
        this.LeftBorder.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.LeftBorder.setMinimumSize(new Dimension(5, 0));
        this.LeftBorder.setOpaque(false);
        this.LeftBorder.setPreferredSize(new Dimension(5, 457));
        this.LeftBorder.setLayout(null);
        this.jPanel1.add(this.LeftBorder);
        this.jPanel15.setAlignmentX(0.0f);
        this.jPanel15.setMaximumSize(new Dimension(3, 1));
        this.jPanel15.setMinimumSize(new Dimension(3, 1));
        this.jPanel15.setOpaque(false);
        this.jPanel15.setPreferredSize(new Dimension(3, 1));
        this.jPanel15.setLayout(new BoxLayout(this.jPanel15, 2));
        this.jPanel1.add(this.jPanel15);
        this.jPanel2.setFocusable(false);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.action_buttons.setAlignmentX(0.0f);
        this.action_buttons.setAlignmentY(0.0f);
        this.action_buttons.setMaximumSize(new Dimension(32727, 36));
        this.action_buttons.setMinimumSize(new Dimension(370, 36));
        this.action_buttons.setPreferredSize(new Dimension(370, 36));
        this.action_buttons.setLayout(new BoxLayout(this.action_buttons, 0));
        this.jPanel6.setFocusable(false);
        this.jPanel6.setMaximumSize(new Dimension(10, 1));
        this.jPanel6.setMinimumSize(new Dimension(10, 1));
        this.jPanel6.setOpaque(false);
        this.jPanel6.setPreferredSize(new Dimension(10, 1));
        this.action_buttons.add(this.jPanel6);
        this.openbtn.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/open2.png")));
        this.openbtn.setToolTipText(JSConsole.Loc("JSeditor.open"));
        this.openbtn.setBorder(null);
        this.openbtn.setContentAreaFilled(false);
        this.openbtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.openbtnMouseClicked(evt);
            }
        });
        this.openbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.openbtnActionPerformed(evt);
            }
        });
        this.openbtn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.openbtnKeyPressed(evt);
            }
        });
        this.action_buttons.add(this.openbtn);
        this.jPanel7.setFocusable(false);
        this.jPanel7.setMaximumSize(new Dimension(10, 1));
        this.jPanel7.setMinimumSize(new Dimension(10, 1));
        this.jPanel7.setOpaque(false);
        this.jPanel7.setPreferredSize(new Dimension(10, 1));
        this.action_buttons.add(this.jPanel7);
        this.savebtn.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/save.png")));
        this.savebtn.setToolTipText(JSConsole.Loc("JSeditor.save"));
        this.savebtn.setBorder(null);
        this.savebtn.setContentAreaFilled(false);
        this.savebtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.savebtnMouseClicked(evt);
            }
        });
        this.savebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.savebtnActionPerformed(evt);
            }
        });
        this.savebtn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.savebtnKeyPressed(evt);
            }
        });
        this.action_buttons.add(this.savebtn);
        this.jPanel8.setFocusable(false);
        this.jPanel8.setMaximumSize(new Dimension(10, 1));
        this.jPanel8.setMinimumSize(new Dimension(10, 1));
        this.jPanel8.setOpaque(false);
        this.jPanel8.setPreferredSize(new Dimension(10, 1));
        this.action_buttons.add(this.jPanel8);
        this.savebtn1.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/saveas.png")));
        this.savebtn1.setToolTipText(JSConsole.Loc("JSeditor.saveas"));
        this.savebtn1.setBorder(null);
        this.savebtn1.setContentAreaFilled(false);
        this.savebtn1.setCursor(new Cursor(2));
        this.savebtn1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.savebtn1MouseClicked(evt);
            }
        });
        this.savebtn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.savebtn1ActionPerformed(evt);
            }
        });
        this.savebtn1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.savebtn1KeyPressed(evt);
            }
        });
        this.action_buttons.add(this.savebtn1);
        this.jPanel17.setFocusable(false);
        this.jPanel17.setMaximumSize(new Dimension(10, 1));
        this.jPanel17.setMinimumSize(new Dimension(10, 1));
        this.jPanel17.setOpaque(false);
        this.jPanel17.setPreferredSize(new Dimension(10, 1));
        this.action_buttons.add(this.jPanel17);
        this.jPanel9.setFocusable(false);
        this.jPanel9.setMaximumSize(new Dimension(35, 1));
        this.jPanel9.setMinimumSize(new Dimension(35, 1));
        this.jPanel9.setOpaque(false);
        this.jPanel9.setPreferredSize(new Dimension(35, 1));
        this.action_buttons.add(this.jPanel9);
        this.infilechk.setToolTipText(JSConsole.Loc("JSeditor.saveinfig"));
        this.infilechk.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/fileoff.png")));
        this.infilechk.setSelectedIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/fileon.png")));
        this.infilechk.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSConsole.this.infilechkItemStateChanged(evt);
            }
        });
        this.action_buttons.add(this.infilechk);
        this.jPanel18.setFocusable(false);
        this.jPanel18.setMaximumSize(new Dimension(35, 1));
        this.jPanel18.setMinimumSize(new Dimension(35, 1));
        this.jPanel18.setOpaque(false);
        this.jPanel18.setPreferredSize(new Dimension(35, 1));
        this.action_buttons.add(this.jPanel18);
        this.openbtn5.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/comment.png")));
        this.openbtn5.setToolTipText(JSConsole.Loc("JSEditor.comment"));
        this.openbtn5.setBorder(null);
        this.openbtn5.setContentAreaFilled(false);
        this.openbtn5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.openbtn5ActionPerformed(evt);
            }
        });
        this.openbtn5.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.openbtn5KeyPressed(evt);
            }
        });
        this.openbtn5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.openbtn5MouseClicked(evt);
            }
        });
        this.action_buttons.add(this.openbtn5);
        this.jPanel16.setFocusable(false);
        this.jPanel16.setMaximumSize(new Dimension(10, 1));
        this.jPanel16.setMinimumSize(new Dimension(10, 1));
        this.jPanel16.setOpaque(false);
        this.jPanel16.setPreferredSize(new Dimension(10, 1));
        this.action_buttons.add(this.jPanel16);
        this.openbtn2.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/format.png")));
        this.openbtn2.setToolTipText(JSConsole.Loc("JSeditor.format"));
        this.openbtn2.setBorder(null);
        this.openbtn2.setContentAreaFilled(false);
        this.openbtn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.openbtn2ActionPerformed(evt);
            }
        });
        this.openbtn2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.openbtn2KeyPressed(evt);
            }
        });
        this.openbtn2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.openbtn2MouseClicked(evt);
            }
        });
        this.action_buttons.add(this.openbtn2);
        this.jPanel10.setFocusable(false);
        this.jPanel10.setMaximumSize(new Dimension(10, 1));
        this.jPanel10.setMinimumSize(new Dimension(10, 1));
        this.jPanel10.setOpaque(false);
        this.jPanel10.setPreferredSize(new Dimension(10, 1));
        this.action_buttons.add(this.jPanel10);
        this.backbtn.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/restore.png")));
        this.backbtn.setToolTipText(JSConsole.Loc("JSeditor.restore"));
        this.backbtn.setBorder(null);
        this.backbtn.setContentAreaFilled(false);
        this.backbtn.setEnabled(false);
        this.backbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.backbtnActionPerformed(evt);
            }
        });
        this.backbtn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.backbtnKeyPressed(evt);
            }
        });
        this.backbtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.backbtnMouseClicked(evt);
            }
        });
        this.action_buttons.add(this.backbtn);
        this.jPanel11.setFocusable(false);
        this.jPanel11.setMaximumSize(new Dimension(10, 1));
        this.jPanel11.setMinimumSize(new Dimension(10, 1));
        this.jPanel11.setOpaque(false);
        this.jPanel11.setPreferredSize(new Dimension(10, 1));
        this.action_buttons.add(this.jPanel11);
        this.openbtn3.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/run.png")));
        this.openbtn3.setToolTipText(JSConsole.Loc("JSeditor.run"));
        this.openbtn3.setBorder(null);
        this.openbtn3.setContentAreaFilled(false);
        this.openbtn3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.openbtn3ActionPerformed(evt);
            }
        });
        this.openbtn3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.openbtn3KeyPressed(evt);
            }
        });
        this.openbtn3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.openbtn3MouseClicked(evt);
            }
        });
        this.action_buttons.add(this.openbtn3);
        this.jPanel12.setFocusable(false);
        this.jPanel12.setMaximumSize(new Dimension(35, 1));
        this.jPanel12.setMinimumSize(new Dimension(35, 1));
        this.jPanel12.setOpaque(false);
        this.jPanel12.setPreferredSize(new Dimension(35, 1));
        this.action_buttons.add(this.jPanel12);
        this.openbtn4.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/help.png")));
        this.openbtn4.setToolTipText(JSConsole.Loc("JSeditor.help"));
        this.openbtn4.setBorder(null);
        this.openbtn4.setContentAreaFilled(false);
        this.openbtn4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSConsole.this.openbtn4ActionPerformed(evt);
            }
        });
        this.openbtn4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.openbtn4KeyPressed(evt);
            }
        });
        this.openbtn4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.openbtn4MouseClicked(evt);
            }
        });
        this.action_buttons.add(this.openbtn4);
        this.jPanel2.add(this.action_buttons);
        this.jPanel4.setAlignmentX(0.0f);
        this.jPanel4.setAlignmentY(0.0f);
        this.jPanel4.setCursor(new Cursor(0));
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 0));
        this.jScrollPane1.setCursor(new Cursor(0));
        this.jScrollPane1.setOpaque(false);
        this.script_area.setFont(new Font("Monospaced", 0, 12));
        this.script_area.setCursor(new Cursor(2));
        this.script_area.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JSConsole.this.script_areaKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                JSConsole.this.script_areaKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                JSConsole.this.script_areaKeyReleased(evt);
            }
        });
        this.script_area.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.script_areaMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.script_area);
        this.jPanel4.add(this.jScrollPane1);
        this.jPanel2.add(this.jPanel4);
        this.jPanel14.setAlignmentX(0.0f);
        this.jPanel14.setMaximumSize(new Dimension(1, 2));
        this.jPanel14.setMinimumSize(new Dimension(1, 2));
        this.jPanel14.setOpaque(false);
        this.jPanel14.setPreferredSize(new Dimension(1, 2));
        this.jPanel14.setLayout(new BoxLayout(this.jPanel14, 2));
        this.jPanel2.add(this.jPanel14);
        this.jPanel1.add(this.jPanel2);
        this.commands.setBackground(new Color(204, 204, 255));
        this.commands.setFocusable(false);
        this.commands.setMaximumSize(new Dimension(182, 98397));
        this.commands.setMinimumSize(new Dimension(182, 0));
        this.commands.setOpaque(false);
        this.commands.setPreferredSize(new Dimension(182, 457));
        this.commands.setLayout(new BoxLayout(this.commands, 1));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("CaRMetal");
        this.jLabel1.setAlignmentX(0.5f);
        this.jLabel1.setEnabled(false);
        this.jLabel1.setFocusable(false);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setIconTextGap(0);
        this.jLabel1.setMaximumSize(new Dimension(182, 25));
        this.jLabel1.setMinimumSize(new Dimension(182, 25));
        this.jLabel1.setPreferredSize(new Dimension(182, 25));
        this.jLabel1.setRequestFocusEnabled(false);
        this.jLabel1.setVerifyInputWhenFocusTarget(false);
        this.commands.add(this.jLabel1);
        this.c_carmetal.setMaximumSize(new Dimension(182, 32000));
        this.c_carmetal.setMinimumSize(new Dimension(182, 100));
        this.c_carmetal.setOpaque(false);
        this.c_carmetal.setPreferredSize(new Dimension(182, 200));
        this.c_carmetal.setLayout(new FlowLayout(1, 3, 3));
        this.commands.add(this.c_carmetal);
        this.c_js.setMaximumSize(new Dimension(182, 217));
        this.c_js.setMinimumSize(new Dimension(182, 217));
        this.c_js.setOpaque(false);
        this.c_js.setPreferredSize(new Dimension(182, 217));
        this.c_js.setLayout(new BoxLayout(this.c_js, 1));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Javascript");
        this.jLabel2.setAlignmentX(0.5f);
        this.jLabel2.setEnabled(false);
        this.jLabel2.setHorizontalTextPosition(0);
        this.jLabel2.setIconTextGap(0);
        this.jLabel2.setMaximumSize(new Dimension(182, 25));
        this.jLabel2.setMinimumSize(new Dimension(182, 25));
        this.jLabel2.setPreferredSize(new Dimension(182, 25));
        this.jLabel2.setRequestFocusEnabled(false);
        this.jLabel2.setVerifyInputWhenFocusTarget(false);
        this.c_js.add(this.jLabel2);
        this.js_btns.setMaximumSize(new Dimension(182, 90));
        this.js_btns.setMinimumSize(new Dimension(182, 90));
        this.js_btns.setOpaque(false);
        this.js_btns.setPreferredSize(new Dimension(182, 90));
        this.js_btns.setLayout(new FlowLayout(1, 3, 3));
        this.c_js.add(this.js_btns);
        this.jScrollPane2.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jScrollPane2.setAutoscrolls(true);
        this.jScrollPane2.setFont(new Font("Lucida Grande", 0, 12));
        this.jScrollPane2.setMaximumSize(new Dimension(160, 100));
        this.jScrollPane2.setMinimumSize(new Dimension(160, 100));
        this.jScrollPane2.setPreferredSize(new Dimension(160, 100));
        this.JSlist.setBackground(new Color(214, 221, 229));
        this.JSlist.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Input()", "Print()", "Println()", "Alert()", "Pause()", "if() {...} else {...}", "for() {...}", "while() {...}", "do {...} while()", "function {...}"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.JSlist.setSelectionMode(0);
        this.JSlist.setAutoscrolls(false);
        this.JSlist.setFixedCellHeight(20);
        this.JSlist.setFocusable(false);
        this.JSlist.setMaximumSize(new Dimension(160, Short.MAX_VALUE));
        this.JSlist.setMinimumSize(new Dimension(160, 20));
        this.JSlist.setPreferredSize(new Dimension(160, 200));
        this.JSlist.setVisibleRowCount(-1);
        this.JSlist.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JSConsole.this.JSlistValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.JSlist);
        this.c_js.add(this.jScrollPane2);
        this.commands.add(this.c_js);
        this.jPanel1.add(this.commands);
        this.RightBorder.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.RightBorder.setMinimumSize(new Dimension(5, 0));
        this.RightBorder.setPreferredSize(new Dimension(5, 457));
        this.RightBorder.setLayout(null);
        this.jPanel1.add(this.RightBorder);
        this.getContentPane().add(this.jPanel1);
        this.controls.setMaximumSize(new Dimension(32000, 22));
        this.controls.setMinimumSize(new Dimension(35, 22));
        this.controls.setPreferredSize(new Dimension(35, 22));
        this.controls.setLayout(new BoxLayout(this.controls, 0));
        this.jPanel13.setAlignmentX(0.0f);
        this.jPanel13.setAlignmentY(0.0f);
        this.jPanel13.setMaximumSize(new Dimension(10, 1));
        this.jPanel13.setMinimumSize(new Dimension(10, 1));
        this.jPanel13.setOpaque(false);
        this.jPanel13.setPreferredSize(new Dimension(10, 1));
        this.controls.add(this.jPanel13);
        this.errorpanel.setAlignmentX(0.0f);
        this.errorpanel.setAlignmentY(0.0f);
        this.errorpanel.setMaximumSize(new Dimension(32737, 32737));
        this.errorpanel.setMinimumSize(new Dimension(0, 30));
        this.errorpanel.setOpaque(false);
        this.errorpanel.setPreferredSize(new Dimension(0, 30));
        this.errorpanel.setLayout(new BoxLayout(this.errorpanel, 0));
        this.errortitlelabel.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/jswindow/error.png")));
        this.errortitlelabel.setText("Error");
        this.errortitlelabel.setAlignmentY(0.0f);
        this.errortitlelabel.setIconTextGap(10);
        this.errortitlelabel.setMaximumSize(new Dimension(250, 30));
        this.errortitlelabel.setMinimumSize(new Dimension(250, 30));
        this.errortitlelabel.setPreferredSize(new Dimension(250, 30));
        this.errorpanel.add(this.errortitlelabel);
        this.errormessagelabel.setForeground(new Color(102, 102, 102));
        this.errormessagelabel.setText("Error message");
        this.errormessagelabel.setAlignmentY(0.0f);
        this.errormessagelabel.setMaximumSize(new Dimension(10000, 30));
        this.errormessagelabel.setMinimumSize(new Dimension(300, 30));
        this.errormessagelabel.setPreferredSize(new Dimension(300, 30));
        this.errorpanel.add(this.errormessagelabel);
        this.controls.add(this.errorpanel);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/themes/gray/zoombox.png")));
        this.jButton2.setAlignmentY(0.0f);
        this.jButton2.setBorderPainted(false);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setMaximumSize(new Dimension(25, 30));
        this.jButton2.setMinimumSize(new Dimension(25, 30));
        this.jButton2.setPreferredSize(new Dimension(25, 30));
        this.jButton2.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JSConsole.this.jButton2MouseDragged(evt);
            }
        });
        this.jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSConsole.this.jButton2MousePressed(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSConsole.this.jButton2MouseClicked(evt);
            }
        });
        this.controls.add(this.jButton2);
        this.getContentPane().add(this.controls);
        this.pack();
    }

    private void script_areaKeyReleased(KeyEvent evt) {
    }

    private void script_areaKeyPressed(KeyEvent evt) {
        this.NoTypeNoClic = false;
    }

    private void script_areaKeyTyped(KeyEvent evt) {
        this.clearStatusBar();
    }

    private void script_areaMouseClicked(MouseEvent evt) {
        this.NoTypeNoClic = false;
        this.clearStatusBar();
    }

    private void closeBTNMouseClicked(MouseEvent evt) {
        if (this.cancelSaveChanges()) {
            return;
        }
        JSRun.clear();
        this.dispose();
    }

    private void macpanelMousePressed(MouseEvent evt) {
        this.origin = MouseInfo.getPointerInfo().getLocation();
        this.winloc = this.getLocation();
    }

    private void jPanel3MousePressed(MouseEvent evt) {
        this.origin = MouseInfo.getPointerInfo().getLocation();
        this.winloc = this.getLocation();
    }

    private void jPanel3MouseDragged(MouseEvent evt) {
        this.current = MouseInfo.getPointerInfo().getLocation();
        this.xx = this.winloc.x + this.current.x - this.origin.x;
        this.yy = this.winloc.y + this.current.y - this.origin.y;
        this.setLocation(this.xx, this.yy);
        Toolkit.getDefaultToolkit().sync();
    }

    private void macpanelMouseDragged(MouseEvent evt) {
        this.current = MouseInfo.getPointerInfo().getLocation();
        this.xx = this.winloc.x + this.current.x - this.origin.x;
        this.yy = this.winloc.y + this.current.y - this.origin.y;
        this.setLocation(this.xx, this.yy);
        Toolkit.getDefaultToolkit().sync();
    }

    private void winpanelMouseDragged(MouseEvent evt) {
        this.current = MouseInfo.getPointerInfo().getLocation();
        this.xx = this.winloc.x + this.current.x - this.origin.x;
        this.yy = this.winloc.y + this.current.y - this.origin.y;
        this.setLocation(this.xx, this.yy);
        Toolkit.getDefaultToolkit().sync();
    }

    private void winpanelMousePressed(MouseEvent evt) {
        this.origin = MouseInfo.getPointerInfo().getLocation();
        this.winloc = this.getLocation();
    }

    private void jButton2MouseClicked(MouseEvent evt) {
    }

    private void jButton2MousePressed(MouseEvent evt) {
        this.origin = MouseInfo.getPointerInfo().getLocation();
        this.winloc = this.getLocation();
        this.w = this.getWidth();
        this.h = this.getHeight();
    }

    private void jButton2MouseDragged(MouseEvent evt) {
        this.current = MouseInfo.getPointerInfo().getLocation();
        this.setSize(this.current.x - this.origin.x + this.w, this.current.y - this.origin.y + this.h);
        Toolkit.getDefaultToolkit().sync();
    }

    private void JSlistValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            int sel = this.JSlist.getSelectedIndex();
            this.JSlist.removeSelectionInterval(sel, sel);
            if (sel == 0) {
                this.script_area.replaceSelection("a=Input(\"" + JSConsole.Loc("JScmd.inputmessage") + "\");");
            } else if (sel == 1) {
                this.script_area.replaceSelection("Print(\"" + JSConsole.Loc("JScmd.promptmessage") + "\");");
            } else if (sel == 2) {
                this.script_area.replaceSelection("Println(\"" + JSConsole.Loc("JScmd.promptmessage") + "\");");
            } else if (sel == 3) {
                this.script_area.replaceSelection("Alert(\"" + JSConsole.Loc("JScmd.promptmessage") + "\");");
            } else if (sel == 4) {
                this.script_area.replaceSelection("Pause(1000);");
            } else if (sel == 5) {
                this.script_area.replaceSelection("if (i<20){\n\n} else {\n\n}");
            } else if (sel == 6) {
                this.script_area.replaceSelection("for (i=0; i<20; i=i+1){\n\n}");
            } else if (sel == 7) {
                this.script_area.replaceSelection("while (i<20){\ni=i+1\n}\n");
            } else if (sel == 8) {
                this.script_area.replaceSelection("do{\ni=i+1\n\n}while (i<20)\n");
            } else if (sel == 9) {
                this.script_area.replaceSelection("function myfunction(i){\n\n}");
            }
            this.Format();
            this.script_area.requestFocus();
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        JSRun.JSC = null;
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void formWindowDeactivated(WindowEvent evt) {
    }

    private void openbtnKeyPressed(KeyEvent evt) {
    }

    private void openbtnMouseClicked(MouseEvent evt) {
        this.clearStatusBar();
        if (this.cancelSaveChanges()) {
            return;
        }
        JSRun.openScriptFile("", true);
    }

    private void openbtnActionPerformed(ActionEvent evt) {
    }

    private void savebtnActionPerformed(ActionEvent evt) {
    }

    private void savebtnKeyPressed(KeyEvent evt) {
    }

    private void savebtnMouseClicked(MouseEvent evt) {
        this.clearStatusBar();
        JSRun.saveScript(this.script_area.getText(), false);
    }

    private void backbtnActionPerformed(ActionEvent evt) {
    }

    private void backbtnKeyPressed(KeyEvent evt) {
    }

    private void backbtnMouseClicked(MouseEvent evt) {
        this.clearStatusBar();
        JSRun.restore();
    }

    private void openbtn2ActionPerformed(ActionEvent evt) {
    }

    private void openbtn2KeyPressed(KeyEvent evt) {
    }

    private void openbtn2MouseClicked(MouseEvent evt) {
        this.clearStatusBar();
        this.Format();
        this.syntaxColoring();
    }

    private void openbtn3ActionPerformed(ActionEvent evt) {
    }

    private void openbtn3KeyPressed(KeyEvent evt) {
    }

    private void openbtn3MouseClicked(MouseEvent evt) {
        this.clearStatusBar();
        JSRun.runScript(this.script_area.getText());
    }

    private void openbtn4ActionPerformed(ActionEvent evt) {
    }

    private void openbtn4KeyPressed(KeyEvent evt) {
    }

    private void openbtn4MouseClicked(MouseEvent evt) {
        JBrowserLauncher.openURL("http://db-maths.nuxit.net/CaRMetal/carJSdoc/index.html");
        this.toFront();
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void openbtn5ActionPerformed(ActionEvent evt) {
    }

    private void openbtn5KeyPressed(KeyEvent evt) {
    }

    private void openbtn5MouseClicked(MouseEvent evt) {
        this.commentSelection();
    }

    private void savebtn1MouseClicked(MouseEvent evt) {
    }

    private void savebtn1ActionPerformed(ActionEvent evt) {
        this.clearStatusBar();
        JSRun.saveScript(this.script_area.getText(), true);
    }

    private void savebtn1KeyPressed(KeyEvent evt) {
    }

    private void infilechkItemStateChanged(ItemEvent evt) {
        if (this.infilechk.isSelected()) {
            JSRun.saveScriptInConstruction();
        } else {
            JSRun.removeScriptFromConstruction();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JSConsole().setVisible(true);
            }
        });
    }
}

