/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.construction.Construction;
import carmetal.eric.JPaletteButton;
import carmetal.eric.JZirkelCanvas;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;

public class JPointName {
    private static String GenericLetter = "P";
    private static String majLettersSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String minLettersSet = "abcdefghijklmnopqrstuvwxyz";
    private static String greekmajLettersSet = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    private static String greekminLettersSet = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    private static ArrayList LettersSet = new ArrayList();
    private String LetterSuffix = "";
    private Construction ZCcn = null;
    private JButton PaletteBtn = null;
    private JZirkelCanvas JZF = null;
    public static int minLettersSetCode = 1;
    private int LetterSetCode = 0;
    private int StartLetter = 0;

    public JPointName(JZirkelCanvas jzf) {
        this.JZF = jzf;
        this.ZCcn = this.JZF.getZF().ZC.getConstruction();
        this.PaletteBtn = new JPaletteButton(this.JZF);
    }

    public JPointName() {
        LettersSet.add(majLettersSet);
        LettersSet.add(minLettersSet);
        LettersSet.add(greekmajLettersSet);
        LettersSet.add(greekminLettersSet);
    }

    public String getCurrentLetterSet() {
        return (String)LettersSet.get(this.LetterSetCode);
    }

    public int getCurrentLetterSetCode() {
        return this.LetterSetCode;
    }

    static void fixsize(Component cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public JButton getPaletteButton() {
        return this.PaletteBtn;
    }

    public void addPaletteJLabel(JPanel jp) {
        JPointName.fixsize(this.PaletteBtn, 28, jp.getSize().height);
        jp.add(this.PaletteBtn);
    }

    public void setEnabledJLabel(boolean bool) {
        this.PaletteBtn.setEnabled(bool);
    }

    public void addSuffixChar() {
        this.LetterSuffix = this.LetterSuffix.equals("''") ? "" : this.LetterSuffix + "'";
    }

    void setSuffixChar(String suff) {
        this.LetterSuffix = suff;
    }

    public static String getGenericName(Construction myC) {
        int i = 1;
        ConstructionObject o = myC.find(GenericLetter + i);
        while (o != null) {
            o = myC.find(GenericLetter + ++i);
        }
        return GenericLetter + i;
    }

    public String getBetterName(Construction myC, boolean setPaletteTxt) {
        String Letters = this.getCurrentLetterSet();
        String s = Letters.substring(this.StartLetter, this.StartLetter + 1);
        if (this.ZCcn == null) {
            s = JPointName.getGenericName(myC);
        } else if (Global.getParameter("options.point.shownames", false)) {
            int i;
            int k = i = Letters.indexOf(s);
            s = s + this.LetterSuffix;
            ConstructionObject o = this.ZCcn.find(s);
            while (i < Letters.length() - 1 && o != null) {
                s = Letters.substring(++i, i + 1) + this.LetterSuffix;
                o = this.ZCcn.find(s);
            }
            i = -1;
            while (i < k && o != null) {
                s = Letters.substring(++i, i + 1) + this.LetterSuffix;
                o = this.ZCcn.find(s);
            }
            if (o != null) {
                s = JPointName.getGenericName(this.ZCcn);
            }
        } else {
            s = JPointName.getGenericName(this.ZCcn);
        }
        if (this.PaletteBtn != null && setPaletteTxt) {
            this.PaletteBtn.setText(s);
        }
        return s;
    }

    public static int findSet(String s) {
        for (int i = 0; i < LettersSet.size(); ++i) {
            String mySet = (String)LettersSet.get(i);
            if (mySet.indexOf(s) == -1) continue;
            return i;
        }
        return -1;
    }

    public boolean isLetterAllowed(String s) {
        return this.getCurrentLetterSet().indexOf(s) != -1;
    }

    public boolean isLetterAccepted(String s) {
        if (this.ZCcn != null) {
            return this.ZCcn.find(s) == null;
        }
        return false;
    }

    public String setStartLetter(String s) {
        if (this.isLetterAllowed(s)) {
            this.StartLetter = this.getCurrentLetterSet().indexOf(s);
        }
        return this.getBetterName(null, true);
    }

    public String setLetterSet(int i) {
        this.LetterSetCode = i;
        this.StartLetter = 0;
        return this.getBetterName(null, true);
    }
}

