/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.TextObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import java.awt.event.MouseEvent;

public class TextConstructor
extends ObjectConstructor {
    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        TextObject p = new TextObject(zc.getConstruction(), x, y);
        zc.addObject(p);
        p.edit(zc, true, true);
        p.setDefaults();
        zc.repaint();
    }

    @Override
    public boolean waitForPoint() {
        return false;
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.text"));
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Text")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("x") || !tag.hasParam("y")) {
            throw new ConstructionException("Point coordinates missing!");
        }
        TextObject p = new TextObject(c2, 0.0, 0.0);
        try {
            double x = new Expression(tag.getValue("x"), c2, p).getValue();
            double y = new Expression(tag.getValue("y"), c2, p).getValue();
            p.move(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setName(tag, p);
        this.set(tree, p);
        c2.add(p);
        this.setConditionals(tree, c2, p);
        p.setLines(p.getText());
        if (tag.hasParam("fixed")) {
            p.setFixed(tag.getValue("x"), tag.getValue("y"));
        }
        return true;
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        this.showStatus(zc);
    }
}

