/*
 * Decompiled with CFR 0.152.
 */
package carmetal.construction;

import carmetal.construction.ChangedListener;
import carmetal.construction.ConstructionException;
import carmetal.construction.Interpreter;
import carmetal.constructors.AngleConstructor;
import carmetal.constructors.AreaConstructor;
import carmetal.constructors.BoundedPointConstructor;
import carmetal.constructors.Circle3Constructor;
import carmetal.constructors.CircleConstructor;
import carmetal.constructors.EquationXYConstructor;
import carmetal.constructors.ExpressionConstructor;
import carmetal.constructors.FunctionConstructor;
import carmetal.constructors.ImageConstructor;
import carmetal.constructors.IntersectionConstructor;
import carmetal.constructors.LineConstructor;
import carmetal.constructors.MidpointConstructor;
import carmetal.constructors.ObjectConstructor;
import carmetal.constructors.ParallelConstructor;
import carmetal.constructors.PlumbConstructor;
import carmetal.constructors.PointConstructor;
import carmetal.constructors.QuadricConstructor;
import carmetal.constructors.RayConstructor;
import carmetal.constructors.SegmentConstructor;
import carmetal.constructors.TextConstructor;
import carmetal.eric.JColors;
import carmetal.eric.Progress_Bar;
import carmetal.objects.AxisObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.EquationXYObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.IntersectionObject;
import carmetal.objects.JLocusTrackObject;
import carmetal.objects.PointObject;
import carmetal.objects.TrackObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.MyVector;
import carmetal.rene.util.sort.SortObject;
import carmetal.rene.util.sort.Sorter;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.expression.Translator;
import carmetal.rene.zirkel.listener.AddEventListener;
import carmetal.rene.zirkel.tools.ObjectTracker;
import java.awt.Color;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class Construction {
    public Vector magnet = new Vector();
    public Vector V;
    public Vector Parameters;
    public Vector Targets;
    public String Comment = "";
    public String JobComment = "";
    public Vector PromptFor = new Vector();
    public Vector Prompts;
    private double X = 0.0;
    private double Y = 0.0;
    private double W = 8.0;
    private double H = 8.0;
    public boolean Partial = Global.getParameter("options.partial", false);
    public boolean Restricted = Global.getParameter("options.restricted", true);
    public boolean PartialLines = Global.getParameter("options.plines", false);
    public boolean Vectors = Global.getParameter("options.arrow", false);
    public boolean ShowNames = Global.getParameter("options.shownames", false);
    public boolean ShowValues = Global.getParameter("options.showvalues", false);
    public boolean LongNames = Global.getParameter("options.longnames", false);
    public boolean LargeFont = Global.getParameter("options.largefont", false);
    public boolean BoldFont = Global.getParameter("options.boldfont", false);
    public boolean Hidden = false;
    public boolean Obtuse = Global.getParameter("options.obtuse", false);
    public boolean Solid = Global.getParameter("options.solid", false);
    public boolean Animate = false;
    public boolean Paint = false;
    public boolean ShowAll = false;
    public boolean SuperHide = false;
    public int DefaultColor = Global.getParameter("options.color", 0);
    public int DefaultType = Global.getParameter("options.type", 0);
    public int DefaultColorType = Global.getParameter("options.colortype", 0);
    public boolean Changed = false;
    int Count = 0;
    public Construction TranslateInto;
    public boolean BlockSimulation = false;
    public boolean DontAlternateIntersections = false;
    ObjectConstructor[] ObjectConstructors = new ObjectConstructor[]{new PointConstructor(), new LineConstructor(), new SegmentConstructor(), new RayConstructor(), new CircleConstructor(), new IntersectionConstructor(), new ParallelConstructor(), new PlumbConstructor(), new Circle3Constructor(), new MidpointConstructor(), new AngleConstructor(), new BoundedPointConstructor(), new ExpressionConstructor(), new AreaConstructor(), new TextConstructor(), new QuadricConstructor(), new ImageConstructor(), new ObjectTracker(), new FunctionConstructor(), new EquationXYConstructor()};
    public boolean DontPaint = false;
    public AxisObject xAxis = null;
    public AxisObject yAxis = null;
    private AddEventListener AEL = null;
    Vector Undo = new Vector();
    public String TrackP = null;
    public String TrackPM = null;
    public String TrackO = null;
    public String AnimateP = null;
    public Vector TrackPO;
    public Vector AnimateV = null;
    public int Omit = 0;
    public boolean AnimateNegative = false;
    public boolean AnimateOriginal = false;
    public String AnimateDelay = null;
    public String Icons = "";
    public boolean AnimateBreakpoints = false;
    public long AnimateTime = 1000L;
    public boolean AnimateLoop = false;
    public boolean ResizeBackground = false;
    public String BackgroundFile = null;
    boolean NeedsOrdering = false;
    Interpreter Int = new Interpreter(this);
    boolean IntersectionBecameInvalid;
    boolean ShouldSwitch = false;
    boolean NoteSwitch = false;
    private ChangedListener CL = null;
    public MyVector TranslatorList = new MyVector();
    Vector VOld = null;
    public boolean Loading = false;
    Vector Errors = new Vector();
    double Pixel = 100.0;

    public Construction() {
        this.clear();
        this.Changed = false;
    }

    public void deleteAxisObjects() {
        if (this.xAxis != null && this.yAxis != null && !this.haveChildren(this.xAxis) && !this.haveChildren(this.yAxis)) {
            this.clearConstructables();
            this.xAxis.setFlag(true);
            this.determineChildren();
            this.delete(false);
            this.clearConstructables();
            this.yAxis.setFlag(true);
            this.determineChildren();
            this.delete(false);
            this.xAxis = null;
            this.yAxis = null;
        }
    }

    public void createAxisObjects() {
        if (this.xAxis == null && this.yAxis == null) {
            this.xAxis = new AxisObject(this, true);
            this.yAxis = new AxisObject(this, false);
            this.add(this.yAxis);
            this.add(this.xAxis);
            this.reorderAxisObjects();
            this.updateCircleDep();
        }
    }

    public void addAddEventListener(AddEventListener ael) {
        this.AEL = ael;
    }

    public void removeAddEventListener(AddEventListener ael) {
        this.AEL = null;
    }

    public void add(ConstructionObject o) {
        if (!o.isGotNCount()) {
            o.setNCount(this.Count++);
        } else {
            o.setGotNCount(false);
        }
        this.V.addElement(o);
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        o.setConstruction(this);
        if (this.AEL != null) {
            this.AEL.added(this, o);
        }
        this.haveChanged();
    }

    public void addNoCheck(ConstructionObject o) {
        if (!o.isGotNCount()) {
            o.setNCount(this.Count++);
        } else {
            o.setGotNCount(false);
        }
        this.V.addElement(o);
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        o.setConstruction(this);
        this.haveChanged();
    }

    public void added(ConstructionObject o) {
        if (this.AEL != null) {
            this.AEL.added(this, o);
        }
    }

    public synchronized void clear() {
        this.V = new Vector();
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        this.Comment = "";
        this.JobComment = "";
        this.clearParameters();
        this.clearTargets();
        this.Prompts = new Vector();
        this.X = 0.0;
        this.Y = 0.0;
        this.W = 8.0;
        this.Changed = false;
        this.Count = 0;
    }

    public void back() {
        ConstructionObject o = this.last();
        if (o == null) {
            return;
        }
        o.setInConstruction(false);
        this.Undo.addElement(o);
        if (this.V.size() > 0) {
            this.V.removeElementAt(this.V.size() - 1);
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
        this.haveChanged();
    }

    public void delete(boolean clearUndo) {
        if (clearUndo && !this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        for (int i = this.V.size() - 1; i >= 0; --i) {
            ConstructionObject o = (ConstructionObject)this.V.elementAt(i);
            if (!o.isFlag() || o.isJobTarget()) continue;
            o.setInConstruction(false);
            this.Undo.addElement(o);
            this.V.removeElementAt(i);
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
        this.haveChanged();
    }

    public void delete() {
        this.delete(true);
    }

    public void undo() {
        if (this.Undo.isEmpty()) {
            return;
        }
        Object[] o = new ConstructionObject[this.Undo.size()];
        this.Undo.copyInto(o);
        for (int i = o.length - 1; i >= 0; --i) {
            this.V.addElement(o[i]);
            ((ConstructionObject)o[i]).setConstruction(this);
        }
        this.Undo.removeAllElements();
        this.haveChanged();
    }

    public Enumeration elements() {
        return this.V.elements();
    }

    public Enumeration getSortedElements() {
        Object[] o = new ConstructionObject[this.V.size()];
        this.V.copyInto(o);
        for (int i = 0; i < o.length; ++i) {
            ((ConstructionObject)o[i]).Value = ((ConstructionObject)o[i]).getNCount();
        }
        Sorter.sort((SortObject[])o);
        Vector<Object> v = new Vector<Object>();
        for (Object element : o) {
            v.addElement(element);
        }
        return v.elements();
    }

    public ConstructionObject last() {
        if (this.V.size() > 0) {
            return (ConstructionObject)this.V.elementAt(this.V.size() - 1);
        }
        return null;
    }

    public ConstructionObject lastByNumber() {
        ConstructionObject o = null;
        int maxCount = -1;
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject co = (ConstructionObject)e2.nextElement();
            if (co.getNCount() <= maxCount) continue;
            maxCount = co.getNCount();
            o = co;
        }
        return o;
    }

    public ConstructionObject lastButOne() {
        if (this.V.size() > 1) {
            return (ConstructionObject)this.V.elementAt(this.V.size() - 2);
        }
        return null;
    }

    public void clearAfter(ConstructionObject after) {
        ConstructionObject o;
        while ((o = this.last()) != null && o != after) {
            o.setInConstruction(false);
            this.V.removeElementAt(this.V.size() - 1);
            this.haveChanged();
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
    }

    public String getComment() {
        return this.Comment;
    }

    public void setComment(String s) {
        if (s.length() <= 2) {
            s = "";
        }
        this.Comment = s;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getW() {
        return this.W;
    }

    public double getH() {
        return this.H;
    }

    public void setH(double h) {
        this.H = h;
    }

    public void setXYW(double x, double y, double w) {
        this.X = x;
        this.Y = y;
        this.W = w;
    }

    public void save(XmlWriter xml) {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).save(xml);
        }
        this.Changed = false;
    }

    public synchronized void load(XmlTree tree, ZirkelCanvas zc) throws ConstructionException, InterruptedException {
        new Vector();
        Enumeration root = tree.getContent();
        this.TrackP = null;
        this.TrackPO = new Vector();
        this.AnimateP = null;
        this.AnimateNegative = false;
        this.AnimateOriginal = false;
        this.AnimateBreakpoints = false;
        this.AnimateLoop = false;
        this.AnimateTime = 1000L;
        this.Icons = "";
        this.BackgroundFile = null;
        this.ResizeBackground = false;
        zc.clearDrawings();
        while (root.hasMoreElements()) {
            tree = (XmlTree)root.nextElement();
            XmlTag tag = tree.getTag();
            if (tag.name().equals("Comment")) {
                try {
                    this.setComment(tree.parseComment());
                    continue;
                }
                catch (Exception e2) {
                    throw new ConstructionException("Illegal Comment");
                }
            }
            if (tag.name().equals("Assignment")) {
                try {
                    this.setJobComment(tree.parseComment());
                    continue;
                }
                catch (Exception e3) {
                    throw new ConstructionException("Illegal Assignment");
                }
            }
            if (tag.name().equals("Track")) {
                if (!tag.hasParam("track")) {
                    throw new ConstructionException(Global.name("exception.track"));
                }
                this.TrackP = tag.getValue("track");
                this.TrackPO = new Vector();
                int i = 0;
                while (tag.hasParam("track" + i)) {
                    this.TrackPO.addElement(tag.getValue("track" + i));
                    ++i;
                }
                this.TrackPM = tag.hasParam("move") ? tag.getValue("move") : null;
                this.TrackO = tag.hasParam("on") ? tag.getValue("on") : null;
                this.Animate = false;
                this.Paint = true;
                if (tag.hasParam("animate")) {
                    if (tag.getValue("animate").equals("nopaint")) {
                        this.Paint = false;
                    }
                    this.Animate = true;
                }
                this.Omit = 0;
                if (!tag.hasParam("omit")) continue;
                try {
                    this.Omit = Integer.parseInt(tag.getValue("omit"));
                }
                catch (Exception exception) {}
                continue;
            }
            if (tag.name().equals("Animate")) {
                if (!tag.hasParam("animate")) {
                    throw new ConstructionException(Global.name("exception.animate"));
                }
                zc.addAnimation(tag.getValue("animate"));
                if (tag.hasParam("negative")) {
                    zc.setAnimationNegative(tag.getValue("animate"), tag.getValue("negative").equals("true"));
                }
                if (tag.hasParam("delay")) {
                    zc.setAnimationDelay(Double.valueOf(tag.getValue("delay")));
                }
                if (!tag.hasParam("stopped") || !tag.getValue("stopped").equals("true")) continue;
                zc.getAnimations().stopAnimation();
                continue;
            }
            if (tag.name().equals("RestrictedSession")) {
                if (!tag.hasParam("HiddenIcons")) continue;
                zc.setHiddenItems(tag.getValue("HiddenIcons"));
                continue;
            }
            if (tag.name().equals("Exercise")) {
                if (tag.hasParam("message_ok")) {
                    zc.job_setMessageOk(tag.getValue("message_ok"));
                }
                if (tag.hasParam("message_failed")) {
                    zc.job_setMessageFailed(tag.getValue("message_failed"));
                }
                if (tag.hasParam("hidefinals")) {
                    zc.job_setHideFinals("true".equals(tag.getValue("hidefinals")));
                }
                if (tag.hasParam("targets")) {
                    zc.job_setTargetNames(tag.getValue("targets"));
                }
                if (!tag.hasParam("backup")) continue;
                zc.job_setBackup(tag.getValue("backup"));
                continue;
            }
            if (tag.name().equals("AnimateBreakpoints")) {
                this.AnimateBreakpoints = true;
                try {
                    if (tag.hasParam("time")) {
                        this.AnimateTime = new Long(tag.getValue("time"));
                    }
                    if (!tag.hasParam("loop")) continue;
                    this.AnimateLoop = true;
                    continue;
                }
                catch (Exception e4) {
                    throw new ConstructionException("exception.animate");
                }
            }
            if (tag.name().equals("Window")) {
                try {
                    if (tag.hasParam("x")) {
                        this.X = new Double(tag.getValue("x"));
                    }
                    if (tag.hasParam("y")) {
                        this.Y = new Double(tag.getValue("y"));
                    }
                    if (tag.hasParam("w")) {
                        this.W = new Double(tag.getValue("w"));
                    }
                    zc.setAxis_show(tag.hasTrueParam("showgrid"));
                    continue;
                }
                catch (Exception e5) {
                    throw new ConstructionException("Illegal Window Parameters");
                }
            }
            if (tag.name().equals("Grid")) {
                try {
                    int n;
                    zc.setAxis_show(true);
                    if (tag.hasParam("color") && (n = new Integer(tag.getValue("color")).intValue()) >= 0 && n < ZirkelFrame.Colors.length) {
                        zc.setAxis_color(n);
                    }
                    if (tag.hasParam("thickness") && (n = new Integer(tag.getValue("thickness")).intValue()) >= 0 && n < 4) {
                        zc.setAxis_thickness(n);
                    }
                    zc.setAxis_labels(!tag.hasTrueParam("nolabels"));
                    zc.setAxis_with_grid(!tag.hasTrueParam("axesonly"));
                    Global.setParameter("grid.large", tag.hasTrueParam("large"));
                    Global.setParameter("grid.bold", tag.hasTrueParam("bold"));
                    continue;
                }
                catch (Exception e6) {
                    throw new ConstructionException("Illegal Grid Parameters");
                }
            }
            if (tag.name().equals("Background")) {
                try {
                    if (tag.hasTrueParam("resize")) {
                        this.ResizeBackground = true;
                    }
                    Global.setParameter("background.usesize", tag.hasTrueParam("usesize"));
                    Global.setParameter("background.tile", tag.hasTrueParam("tile"));
                    Global.setParameter("background.center", tag.hasTrueParam("center"));
                    this.BackgroundFile = tag.getValue("file");
                    if (this.BackgroundFile != null) continue;
                    throw new ConstructionException("Illegal Background Parameters");
                }
                catch (Exception e7) {
                    throw new ConstructionException("Illegal Background Parameters");
                }
            }
            if (tag.name().equals("Draw")) {
                zc.loadDrawings(tree);
                continue;
            }
            if (tag.name().equals("Objects")) {
                this.readConstruction(tree, true);
                this.updateCount();
                this.computeNeedsOrdering();
                this.doOrder();
                break;
            }
            if (tag.name().equals("Restrict")) {
                if (!tag.hasParam("icons")) {
                    throw new ConstructionException("Illegal Window Parameters");
                }
                this.Icons = tag.getValue("icons");
                continue;
            }
            zc.XmlTagReader(tag);
            zc.JCM.collectXmlTag(tag);
        }
        this.setCurrentMagnetObjects();
        zc.job_setTargets();
        zc.setBackground(Global.getParameter("colorbackground", new Color(230, 230, 230)));
        zc.updateDigits();
        zc.resetGraphics();
        zc.repaint();
    }

    public void translateOffsets(ZirkelCanvas zc) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).translateOffset(zc);
        }
    }

    public synchronized void readConstruction(XmlTree tree, boolean showProgressBar) throws ConstructionException {
        int max = Collections.list(tree.getContent()).size();
        if (showProgressBar && max > 100) {
            Progress_Bar.create(Global.Loc("progressbar.loadmessage"), 0, max);
        }
        Enumeration e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            int i;
            Progress_Bar.nextValue();
            tree = (XmlTree)e2.nextElement();
            int n = this.ObjectConstructors.length;
            for (i = 0; i < n; ++i) {
                try {
                    if (!this.ObjectConstructors[i].construct(tree, this)) continue;
                    break;
                }
                catch (ConstructionException ex) {
                    if (tree.getTag().hasParam("name")) {
                        String name = tree.getTag().getValue("name");
                        throw new ConstructionException(ex.getDescription() + " (in " + name + ")");
                    }
                    throw ex;
                }
            }
            if (i < n) continue;
            throw new ConstructionException(tree.getTag().name() + " unknown!");
        }
        Progress_Bar.close();
        e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).laterBind(this);
        }
        this.dovalidate();
        this.updateCircleDep();
        this.Changed = false;
    }

    public ConstructionObject find(String name) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (!c2.getName().equals(name)) continue;
            return c2;
        }
        return null;
    }

    public ConstructionObject find(String name, ConstructionObject until) {
        ConstructionObject c2;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements() && (c2 = (ConstructionObject)e2.nextElement()) != until) {
            if (!c2.getName().equals(name)) continue;
            return c2;
        }
        return null;
    }

    public ConstructionObject findInclusive(String name, ConstructionObject until) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (c2.getName().equals(name)) {
                return c2;
            }
            if (c2 != until) continue;
            break;
        }
        return null;
    }

    public boolean before(ConstructionObject first, ConstructionObject second) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (c2 == first) {
                return true;
            }
            if (c2 != second) continue;
            break;
        }
        return false;
    }

    public boolean dependsDirectlyOn(ConstructionObject o, ConstructionObject on) {
        Enumeration e2 = o.depending();
        while (e2.hasMoreElements()) {
            if (on != e2.nextElement()) continue;
            return true;
        }
        return false;
    }

    public void clearRekFlags() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setRekFlag(false);
        }
    }

    public boolean dependsOn(ConstructionObject o, ConstructionObject on) {
        this.clearRekFlags();
        boolean res = this.dependsOnRek(o, on);
        return res;
    }

    public boolean dependsOnRek(ConstructionObject o, ConstructionObject on) {
        ConstructionObject[] o1;
        o.setRekFlag(true);
        if (o == on) {
            return true;
        }
        for (ConstructionObject element : o1 = o.getDepArray()) {
            if (element == o || element.isRekFlag() || !this.dependsOnRek(element, on)) continue;
            return true;
        }
        return false;
    }

    public void reorderConstruction() {
        int i;
        Object[] o = new ConstructionObject[this.V.size()];
        this.boundMagnetObjects();
        this.V.copyInto(o);
        int n = o.length;
        if (n == 0) {
            return;
        }
        for (i = 0; i < n; ++i) {
            ((ConstructionObject)o[i]).Scratch = 0;
            ((ConstructionObject)o[i]).Flag = false;
        }
        for (i = 0; i < n; ++i) {
            this.countTail((ConstructionObject)o[i]);
        }
        if (n < 500) {
            for (i = 1; i < n; ++i) {
                int j;
                int k = ((ConstructionObject)o[i]).Scratch;
                for (j = i; j > 0 && ((ConstructionObject)o[j - 1]).Scratch > k; --j) {
                }
                if (j >= i) continue;
                Object oh = o[i];
                for (int h = i; h > j; --h) {
                    o[h] = o[h - 1];
                }
                o[j] = oh;
            }
        } else {
            for (i = 0; i < o.length; ++i) {
                ((ConstructionObject)o[i]).Value = ((ConstructionObject)o[i]).Scratch;
            }
            Sorter.sort((SortObject[])o);
        }
        this.V = new Vector();
        for (i = 0; i < n; ++i) {
            this.V.addElement(o[i]);
        }
        this.reorderAxisObjects();
        this.unboundMagnetObjects();
    }

    public int countTail(ConstructionObject o) {
        if (o.Flag) {
            return o.Scratch;
        }
        o.Flag = true;
        int max = 0;
        ConstructionObject[] oc = o.getDepArray();
        if (oc.length == 0) {
            o.Scratch = 0;
        } else {
            for (ConstructionObject element : oc) {
                int k;
                if (element == o || (k = this.countTail(element)) <= max) continue;
                max = k;
            }
            o.Scratch = max + 1;
        }
        return o.Scratch;
    }

    public void needsOrdering() {
        this.NeedsOrdering = true;
    }

    public void doOrder() {
        if (!this.NeedsOrdering) {
            return;
        }
        this.reorderConstruction();
        this.NeedsOrdering = false;
    }

    public void computeNeedsOrdering() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).Flag = false;
        }
        e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Enumeration ec = ((ConstructionObject)e2.nextElement()).depending();
            while (ec.hasMoreElements()) {
                if (((ConstructionObject)ec.nextElement()).Flag) continue;
                this.NeedsOrdering = true;
                return;
            }
        }
        this.NeedsOrdering = false;
    }

    public int indexOf(ConstructionObject o) {
        return this.V.indexOf(o);
    }

    public ConstructionObject lastDep(ConstructionObject o) {
        int res = -1;
        ConstructionObject ores = null;
        Enumeration e2 = o.depending();
        while (e2.hasMoreElements()) {
            ConstructionObject u = (ConstructionObject)e2.nextElement();
            int i = this.indexOf(u);
            if (i <= res) continue;
            res = i;
            ores = u;
        }
        return ores;
    }

    public void setCurrentMagnetObjects() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof PointObject)) continue;
            PointObject pt = (PointObject)o;
            pt.setCurrentMagnetObject();
        }
    }

    public void boundMagnetObjects() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            PointObject pt;
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof PointObject) || (pt = (PointObject)o).getCurrentMagnetObject() == null) continue;
            pt.VirtualBound = pt.getBound();
            pt.setBound(pt.getCurrentMagnetObject());
        }
    }

    public void unboundMagnetObjects() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            PointObject pt;
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof PointObject) || (pt = (PointObject)o).getCurrentMagnetObject() == null) continue;
            pt.setBound(pt.VirtualBound);
        }
    }

    public void reorderAxisObjects() {
        if (this.xAxis != null && this.yAxis != null) {
            Enumeration e2 = this.V.elements();
            int shft = 2;
            while (e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                if (o instanceof AxisObject) {
                    o.setNCount(--shft);
                    continue;
                }
                o.setNCount(o.getNCount() + shft);
            }
        }
    }

    public boolean reorder(ConstructionObject o1, ConstructionObject o2) {
        int n = -1;
        if (o2 != null) {
            n = o2.getNCount();
        }
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.getNCount() <= n) continue;
            o.setNCount(o.getNCount() + 1);
        }
        o1.setNCount(n + 1);
        this.haveChanged();
        return true;
    }

    public void updateTexts(ConstructionObject o, String oldname) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject u = (ConstructionObject)e2.nextElement();
            if (!this.dependsDirectlyOn(u, o)) continue;
            u.updateText();
        }
    }

    public String getJobComment() {
        return this.JobComment;
    }

    public void setJobComment(String s) {
        this.JobComment = s;
    }

    public void updateCircleDep() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).clearCircleDep();
        }
        e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).updateCircleDep();
        }
    }

    public Vector getParameters() {
        return this.Parameters;
    }

    public int countParameters() {
        if (this.Parameters == null) {
            return 0;
        }
        return this.Parameters.size();
    }

    public Vector getTargets() {
        return this.Targets;
    }

    public int countTargets() {
        if (this.Targets == null) {
            return 0;
        }
        return this.Targets.size();
    }

    public void addParameter(ConstructionObject o) {
        this.Parameters.addElement(o);
    }

    public void removeParameter(ConstructionObject o) {
        this.Parameters.removeElement(o);
    }

    public void addTarget(ConstructionObject o) {
        this.Targets.addElement(o);
    }

    public void removeTarget(ConstructionObject o) {
        this.Targets.removeElement(o);
    }

    public void clearParameters() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.clearParameter();
            o.setSpecialParameter(false);
        }
        this.Parameters = new Vector();
    }

    public void clearTargets() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setTarget(false);
        }
        this.Targets = new Vector();
    }

    public void testParameter(ConstructionObject o) throws ConstructionException {
        throw new ConstructionException(Global.name("exception.null"));
    }

    public void interpret(ZirkelCanvas zc, String s, String comment) throws ConstructionException {
        this.Int.interpret(zc, s, comment);
    }

    public void interpret(ZirkelCanvas zc, String s) throws ConstructionException {
        this.Int.interpret(zc, s, "");
    }

    public void dovalidate() {
        boolean stop;
        this.doOrder();
        do {
            Enumeration e2 = this.elements();
            stop = true;
            this.IntersectionBecameInvalid = false;
            while (e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                boolean valid = o.valid();
                o.validate();
                if (o instanceof IntersectionObject && valid && !o.valid()) {
                    this.IntersectionBecameInvalid = true;
                }
                if (!(o.changedBy() > 1.0E-6)) continue;
                stop = false;
            }
        } while (!stop);
    }

    public boolean intersectionBecameInvalid() {
        return this.IntersectionBecameInvalid;
    }

    public void dovalidateDebug() {
        boolean stop;
        this.doOrder();
        System.out.println("--- Time validate() ---");
        do {
            Enumeration e2 = this.elements();
            stop = true;
            while (e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                long time = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    o.validate();
                }
                time = System.currentTimeMillis() - time;
                if (time > 0L) {
                    System.out.println(o.getName() + " - " + (double)time / 100.0 + " msec");
                }
                if (!(o.changedBy() > 1.0E-6)) continue;
                stop = false;
            }
        } while (!stop);
    }

    public void validate(ConstructionObject o, ConstructionObject avoid) {
        ConstructionObject oc;
        if (o.RekValidating) {
            return;
        }
        o.RekValidating = true;
        if (o.VRek == null) {
            o.VRek = new MyVector();
        } else {
            o.VRek.removeAllElements();
        }
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).setRekFlag(false);
        }
        this.recursiveValidate(o, avoid);
        e2 = this.elements();
        while (e2.hasMoreElements()) {
            oc = (ConstructionObject)e2.nextElement();
            if (!oc.isRekFlag()) continue;
            o.VRek.addElement(oc);
        }
        e2 = o.VRek.elements();
        while (e2.hasMoreElements()) {
            oc = (ConstructionObject)e2.nextElement();
            oc.validate();
        }
        o.RekValidating = false;
    }

    public void recursiveValidate(ConstructionObject o, ConstructionObject avoid) {
        ConstructionObject[] d2;
        if (o.isRekFlag() || o == avoid) {
            return;
        }
        o.setRekFlag(true);
        for (ConstructionObject element : d2 = o.getDepArray()) {
            this.recursiveValidate(element, avoid);
        }
    }

    private boolean isNewColor(Vector v, Color col) {
        Enumeration e2 = v.elements();
        while (e2.hasMoreElements()) {
            JColors jc = (JColors)e2.nextElement();
            if (!jc.C.equals(col)) continue;
            return false;
        }
        return true;
    }

    public Vector getSpecialColors() {
        Vector<JColors> vec = new Vector<JColors>();
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            Color c2 = o.getSpecialColor();
            if (c2 == null || !this.isNewColor(vec, c2)) continue;
            vec.add(new JColors(c2, o.getName()));
        }
        return vec;
    }

    public void computeHeavyObjects(ZirkelCanvas zc) {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o instanceof JLocusTrackObject) {
                JLocusTrackObject jl = (JLocusTrackObject)o;
                if (!jl.needsToRecompute()) continue;
                jl.compute();
                continue;
            }
            if (o instanceof TrackObject) {
                ((TrackObject)o).compute(zc);
                continue;
            }
            if (o instanceof FunctionObject) {
                FunctionObject f2 = (FunctionObject)o;
                if (!f2.needsToRecompute()) continue;
                f2.compute();
                continue;
            }
            if (!(o instanceof EquationXYObject)) continue;
            ((EquationXYObject)o).compute();
        }
        Global.doClearList();
    }

    public void clearTranslations() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setTranslation(null);
        }
    }

    public void determineConstructables() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            boolean constructable;
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) {
                o.setFlag(true);
                continue;
            }
            Enumeration ee = o.depending();
            boolean bl = constructable = o instanceof ExpressionObject || o instanceof FunctionObject;
            while (ee.hasMoreElements()) {
                ConstructionObject oo = (ConstructionObject)ee.nextElement();
                if (o == oo) continue;
                if (oo.isFlag()) {
                    constructable = true;
                    continue;
                }
                constructable = false;
                break;
            }
            o.setFlag(constructable);
        }
    }

    public boolean determineConstructables(ConstructionObject o) {
        if (o.isFlag()) {
            return true;
        }
        ConstructionObject[] dep = o.getDepArray();
        boolean constructable = o instanceof ExpressionObject || o instanceof FunctionObject;
        for (int i = 0; i < dep.length; ++i) {
            if (dep[i] == null) {
                return false;
            }
            if (dep[i] == o) continue;
            if (!this.determineConstructables(dep[i])) {
                return false;
            }
            constructable = true;
        }
        o.setFlag(constructable);
        return true;
    }

    public void clearConstructables() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setFlag(false);
        }
    }

    public boolean haveChildren(ConstructionObject on) {
        this.clearConstructables();
        on.setFlag(true);
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isFlag()) continue;
            Enumeration ee = o.depending();
            while (ee.hasMoreElements()) {
                ConstructionObject oo = (ConstructionObject)ee.nextElement();
                if (!oo.isFlag()) continue;
                return true;
            }
        }
        return false;
    }

    public void determineChildren() {
        Enumeration e2 = this.elements();
        block0: while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isFlag()) continue;
            Enumeration ee = o.depending();
            while (ee.hasMoreElements()) {
                ConstructionObject oo = (ConstructionObject)ee.nextElement();
                if (!oo.isFlag()) continue;
                o.setFlag(true);
                continue block0;
            }
        }
    }

    public void setParameterAsConstructables() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isParameter() && !o.isMainParameter()) continue;
            o.setFlag(true);
        }
    }

    public String[] getPromptFor() {
        Object[] s = new String[this.PromptFor.size()];
        this.PromptFor.copyInto(s);
        return s;
    }

    public boolean shouldSwitch() {
        return this.ShouldSwitch;
    }

    public boolean noteSwitch() {
        return this.NoteSwitch;
    }

    public void shouldSwitch(boolean flag, boolean note) {
        this.ShouldSwitch = flag;
        this.NoteSwitch = note;
    }

    public void shouldSwitch(boolean flag) {
        this.ShouldSwitch = flag;
        this.NoteSwitch = true;
    }

    public void switchBack() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof IntersectionObject)) continue;
            ((IntersectionObject)o).switchBack();
        }
    }

    public void clearSwitches() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof IntersectionObject)) continue;
            ((IntersectionObject)o).switchBack();
        }
    }

    public boolean haveSwitched() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof IntersectionObject) || !((IntersectionObject)o).isSwitched()) continue;
            return true;
        }
        return false;
    }

    public boolean changed() {
        return this.Changed;
    }

    public void addChangedListener(ChangedListener cl) {
        this.CL = cl;
    }

    public void haveChanged() {
        this.changed(true);
        if (this.CL != null) {
            this.CL.notifyChanged();
        }
    }

    public void changed(boolean flag) {
        this.Changed = flag;
    }

    public void addTranslator(Translator t) {
        this.TranslatorList.addElement(t);
    }

    public void runTranslators(Construction from) {
        Enumeration e2 = this.TranslatorList.elements();
        while (e2.hasMoreElements()) {
            Translator t = (Translator)e2.nextElement();
            t.laterTranslate(from);
        }
    }

    public void clearTranslators() {
        this.TranslatorList.removeAllElements();
    }

    public void updateCount() {
        int max = 0;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            int n = ((ConstructionObject)e2.nextElement()).getNCount();
            if (n <= max) continue;
            max = n;
        }
        this.Count = max + 1;
    }

    public void setOriginalOrder(boolean flag) {
        if (this.V == null) {
            return;
        }
        if (flag) {
            Object[] o = new ConstructionObject[this.V.size()];
            this.V.copyInto(o);
            for (int i = 0; i < o.length; ++i) {
                ((ConstructionObject)o[i]).Value = ((ConstructionObject)o[i]).getNCount();
            }
            Sorter.sort((SortObject[])o);
            Vector<Object> W = new Vector<Object>();
            for (Object element : o) {
                W.addElement(element);
            }
            this.VOld = this.V;
            this.V = W;
        } else if (this.VOld != null) {
            this.V = this.VOld;
            this.VOld = null;
        }
    }

    public Construction getTranslation() {
        return this.TranslateInto;
    }

    public void setTranslation(Construction C) {
        this.TranslateInto = C;
    }

    public boolean loading() {
        return this.Loading;
    }

    public void addError(String s) {
        this.Errors.addElement(s);
    }

    public Enumeration getErrors() {
        return this.Errors.elements();
    }

    public void clearErrors() {
        this.Errors.removeAllElements();
    }

    public void dontAlternate(boolean flag) {
        this.DontAlternateIntersections = flag;
    }

    public boolean canAlternate() {
        return !this.DontAlternateIntersections;
    }

    public void setPixel(double pixel) {
        this.Pixel = pixel;
    }

    public double getPixel() {
        return this.Pixel;
    }
}

