/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class ShellScriptTokenMarker
extends TokenMarker {
    public static final byte LVARIABLE = 100;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        int cmdState = 0;
        int lastOffset = offset = line.offset;
        int length = line.count + offset;
        if (token == 3 && lineIndex != 0 && this.lineInfo[lineIndex - 1].obj != null) {
            String str = (String)this.lineInfo[lineIndex - 1].obj;
            if (str != null) {
                System.out.println(str.length() + ":" + line.count);
            }
            if (str != null && str.length() == line.count && SyntaxUtilities.regionMatches(false, line, offset, str)) {
                this.addToken(line.count, (byte)3);
                return 0;
            }
            this.addToken(line.count, (byte)3);
            this.lineInfo[lineIndex].obj = str;
            return 3;
        }
        boolean backslash = false;
        block15: for (int i = offset; i < length; ++i) {
            char c = line.array[i];
            if (token == 7) {
                backslash = false;
                if (!Character.isLetterOrDigit(c) && c != '_') {
                    token = 0;
                    if (i != offset && line.array[i - 1] == '$') {
                        this.addToken(i + 1 - lastOffset, (byte)7);
                        lastOffset = i + 1;
                        continue;
                    }
                    this.addToken(i - lastOffset, (byte)7);
                    lastOffset = i;
                }
            } else if (token == 100 && c == '}') {
                backslash = false;
                token = 0;
                this.addToken(i + 1 - lastOffset, (byte)7);
                lastOffset = i + 1;
            }
            switch (c) {
                case '\\': {
                    backslash = !backslash;
                    continue block15;
                }
                case '\t': 
                case ' ': 
                case '(': 
                case ')': {
                    backslash = false;
                    if (token != 0 || cmdState != true) continue block15;
                    this.addToken(i - lastOffset, (byte)6);
                    lastOffset = i;
                    cmdState = 2;
                    continue block15;
                }
                case '=': {
                    backslash = false;
                    if (token != 0 || cmdState != true) continue block15;
                    this.addToken(i - lastOffset, (byte)0);
                    lastOffset = i;
                    cmdState = 2;
                    continue block15;
                }
                case '&': 
                case ';': 
                case '|': {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    cmdState = 0;
                    continue block15;
                }
                case '#': {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (token != 0) continue block15;
                    this.addToken(i - lastOffset, (byte)0);
                    this.addToken(length - i, (byte)1);
                    lastOffset = length;
                    break block15;
                }
                case '$': {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (token != 0) continue block15;
                    if (length - i >= 2) {
                        switch (line.array[i + 1]) {
                            case '(': {
                                continue block15;
                            }
                            case '{': {
                                token = (byte)100;
                                break;
                            }
                            default: {
                                token = (byte)7;
                                break;
                            }
                        }
                    } else {
                        token = (byte)7;
                    }
                    this.addToken(i - lastOffset, (byte)0);
                    cmdState = 2;
                    lastOffset = i;
                    continue block15;
                }
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (token == 0) {
                        token = (byte)3;
                        this.addToken(i - lastOffset, (byte)0);
                        cmdState = 2;
                        lastOffset = i;
                        continue block15;
                    }
                    if (token != 3) continue block15;
                    token = 0;
                    this.addToken(i + 1 - lastOffset, (byte)3);
                    cmdState = 2;
                    lastOffset = i + 1;
                    continue block15;
                }
                case '\'': {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (token == 0) {
                        token = (byte)4;
                        this.addToken(i - lastOffset, (byte)0);
                        cmdState = 2;
                        lastOffset = i;
                        continue block15;
                    }
                    if (token != 4) continue block15;
                    token = 0;
                    this.addToken(i + 1 - lastOffset, (byte)3);
                    cmdState = 2;
                    lastOffset = i + 1;
                    continue block15;
                }
                case '<': {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (token != 0 || length - i <= 1 || line.array[i + 1] != '<') continue block15;
                    this.addToken(i - lastOffset, (byte)0);
                    token = (byte)3;
                    lastOffset = i;
                    this.lineInfo[lineIndex].obj = new String(line.array, i + 2, length - (i + 2));
                    continue block15;
                }
                default: {
                    backslash = false;
                    if (!Character.isLetter(c) || cmdState != 0) continue block15;
                    this.addToken(i - lastOffset, token);
                    lastOffset = i;
                    cmdState = (byte)(cmdState + 1);
                }
            }
        }
        if (lastOffset != length) {
            if (token == 0 && cmdState == 1) {
                token = (byte)6;
            }
            this.addToken(length - lastOffset, token);
        }
        return token == 4 || token == 3 ? token : (byte)0;
    }
}

