/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class CTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private boolean cpp;
    private KeywordMap keywords;

    public CTokenMarker() {
        this(true, CTokenMarker.getKeywords());
    }

    public CTokenMarker(boolean cpp, KeywordMap keywords) {
        this.cpp = cpp;
        this.keywords = keywords;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int len;
        byte id;
        int offset;
        int lastOffset = offset = line.offset;
        int lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block13: for (int i = offset; i < length; ++i) {
            char c = line.array[i];
            switch (c) {
                case '\\': {
                    backslash = !backslash;
                    continue block13;
                }
                case '*': {
                    if ((token == 1 || token == 2) && length - i > 1) {
                        backslash = false;
                        if (length - i <= 1 || line.array[i + 1] != '/') continue block13;
                        this.addToken(++i + 1 - lastOffset, token);
                        token = 0;
                        lastKeyword = lastOffset = i + 1;
                        continue block13;
                    }
                }
                case ':': {
                    backslash = false;
                    if (token != 0 || lastKeyword != offset) continue block13;
                    this.addToken(i + 1 - lastOffset, (byte)5);
                    lastKeyword = lastOffset = i + 1;
                    continue block13;
                }
                case '#': {
                    backslash = false;
                    if (!(this.cpp & token == 0)) continue block13;
                    token = (byte)7;
                    this.addToken(i - lastOffset, (byte)0);
                    this.addToken(length - i, (byte)7);
                    lastOffset = length;
                    break block13;
                }
                case '/': {
                    backslash = false;
                    if (token != 0 || length - i <= 1) continue block13;
                    switch (line.array[i + 1]) {
                        case '*': {
                            this.addToken(i - lastOffset, token);
                            lastKeyword = lastOffset = i;
                            if (length - i > 2 && line.array[i + 2] == '*') {
                                token = (byte)2;
                                break;
                            }
                            token = 1;
                            break;
                        }
                        case '/': {
                            this.addToken(i - lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            lastKeyword = lastOffset = length;
                            break block13;
                        }
                    }
                    continue block13;
                }
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        continue block13;
                    }
                    if (token == 0) {
                        token = (byte)3;
                        this.addToken(i - lastOffset, (byte)0);
                        lastKeyword = lastOffset = i;
                        continue block13;
                    }
                    if (token != 3) continue block13;
                    token = 0;
                    this.addToken(i + 1 - lastOffset, (byte)3);
                    lastKeyword = lastOffset = i + 1;
                    continue block13;
                }
                case '\'': {
                    if (backslash) {
                        backslash = false;
                        continue block13;
                    }
                    if (token == 0) {
                        token = (byte)4;
                        this.addToken(i - lastOffset, (byte)0);
                        lastKeyword = lastOffset = i;
                        continue block13;
                    }
                    if (token != 4) continue block13;
                    token = 0;
                    this.addToken(i + 1 - lastOffset, (byte)3);
                    lastKeyword = lastOffset = i + 1;
                    continue block13;
                }
                default: {
                    backslash = false;
                    if (token != 0 || c == '_' || Character.isLetter(c)) continue block13;
                    int len2 = i - lastKeyword;
                    byte id2 = this.keywords.lookup(line, lastKeyword, len2);
                    if (id2 != 0) {
                        if (lastKeyword != lastOffset) {
                            this.addToken(lastKeyword - lastOffset, (byte)0);
                        }
                        this.addToken(len2, id2);
                        lastOffset = i;
                    }
                    lastKeyword = i + 1;
                }
            }
        }
        if (token == 0 && (id = this.keywords.lookup(line, lastKeyword, len = length - lastKeyword)) != 0) {
            if (lastKeyword != lastOffset) {
                this.addToken(lastKeyword - lastOffset, (byte)0);
            }
            this.addToken(len, id);
            lastOffset = length;
        }
        if (lastOffset != length) {
            if (token == 3 || token == 4) {
                this.addToken(length - lastOffset, (byte)10);
                token = 0;
            } else {
                this.addToken(length - lastOffset, token);
            }
        }
        if (token == 7 && !backslash) {
            token = 0;
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("char", (byte)8);
            cKeywords.add("double", (byte)8);
            cKeywords.add("enum", (byte)8);
            cKeywords.add("float", (byte)8);
            cKeywords.add("int", (byte)8);
            cKeywords.add("long", (byte)8);
            cKeywords.add("short", (byte)8);
            cKeywords.add("signed", (byte)8);
            cKeywords.add("struct", (byte)8);
            cKeywords.add("typedef", (byte)8);
            cKeywords.add("union", (byte)8);
            cKeywords.add("unsigned", (byte)8);
            cKeywords.add("void", (byte)8);
            cKeywords.add("auto", (byte)6);
            cKeywords.add("const", (byte)6);
            cKeywords.add("extern", (byte)6);
            cKeywords.add("register", (byte)6);
            cKeywords.add("static", (byte)6);
            cKeywords.add("volatile", (byte)6);
            cKeywords.add("break", (byte)6);
            cKeywords.add("case", (byte)6);
            cKeywords.add("continue", (byte)6);
            cKeywords.add("default", (byte)6);
            cKeywords.add("do", (byte)6);
            cKeywords.add("else", (byte)6);
            cKeywords.add("for", (byte)6);
            cKeywords.add("goto", (byte)6);
            cKeywords.add("if", (byte)6);
            cKeywords.add("return", (byte)6);
            cKeywords.add("sizeof", (byte)6);
            cKeywords.add("switch", (byte)6);
            cKeywords.add("while", (byte)6);
            cKeywords.add("asm", (byte)7);
            cKeywords.add("asmlinkage", (byte)7);
            cKeywords.add("far", (byte)7);
            cKeywords.add("huge", (byte)7);
            cKeywords.add("inline", (byte)7);
            cKeywords.add("near", (byte)7);
            cKeywords.add("pascal", (byte)7);
            cKeywords.add("true", (byte)4);
            cKeywords.add("false", (byte)4);
            cKeywords.add("NULL", (byte)4);
        }
        return cKeywords;
    }
}

