/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import hep.aida.ref.histogram.Histogram1D;
import jas2.hist.HasStatistics;
import jas2.hist.HasStyle;
import jas2.hist.JASHist1DHistogramStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.Statistics;
import jasext.jhplotserver.Rebinnable1DHistogramDataWithType;

class RefH1D
extends Rebinnable1DHistogramDataWithType
implements Rebinnable1DHistogramData,
HasStatistics,
HasStyle,
Statistics {
    private Histogram1D h;
    private final String type = "histogram";

    public RefH1D(Histogram1D h) {
        this.h = h;
    }

    public int getSize() {
        return this.h.allEntries();
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        int ibins = this.h.axis().bins();
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        for (int i = 0; i < ibins - 1; ++i) {
            newHeights[i] = this.h.binHeight(i + 1);
            newErrors[i] = this.h.binError(i + 1);
        }
        return new double[][]{newHeights, newErrors};
    }

    @Override
    public String getType() {
        return "histogram";
    }

    @Override
    public double getMin() {
        return this.h.axis().lowerEdge();
    }

    @Override
    public double getMax() {
        return this.h.axis().upperEdge();
    }

    @Override
    public int getBins() {
        return this.h.axis().bins();
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    @Override
    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.h.title();
    }

    @Override
    public Statistics getStatistics() {
        return this;
    }

    @Override
    public String[] getStatisticNames() {
        return new String[]{"Entries", "Mean", "RMS"};
    }

    private double mean() {
        return this.h.mean();
    }

    public double rms() {
        return this.h.rms();
    }

    @Override
    public double getStatistic(String name) {
        if (name.equals("Entries")) {
            return this.h.allEntries();
        }
        if (name.equals("Mean")) {
            return this.mean();
        }
        if (name.equals("RMS")) {
            return this.rms();
        }
        return 0.0;
    }

    @Override
    public JASHistStyle getStyle() {
        JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        style.setShowHistogramBars(true);
        style.setShowDataPoints(false);
        style.setShowLinesBetweenPoints(false);
        style.setShowErrorBars(true);
        return style;
    }
}

