/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import jas2.hist.HasScatterPlotData;
import jas2.hist.HasStatistics;
import jas2.hist.ScatterEnumeration;
import jas2.hist.Statistics;
import jasext.jhplotserver.Rebinnable2DHistogramDataWithType;
import jhplot.P1D;

public class CopyOfRefP1D_2Dhisto
extends Rebinnable2DHistogramDataWithType
implements HasStatistics,
HasScatterPlotData,
Statistics {
    protected double[] x;
    protected double[] y;
    protected double npoints;
    private P1D h;
    private final String type = "scatter";

    public CopyOfRefP1D_2Dhisto(P1D h) {
        this.h = h;
        this.npoints = h.size();
        this.x = new double[h.size()];
        this.y = new double[h.size()];
        for (int i = 0; i < h.size(); ++i) {
            this.x[i] = h.getX(i);
            this.y[i] = h.getY(i);
        }
    }

    public int getSize() {
        return this.h.size();
    }

    @Override
    public double[][][] rebin(int xbins, double p2, double p3, int ybins, double p6, double p7, boolean p4, boolean p5, boolean p8) {
        int nn = this.h.size();
        double[][] newHeights = new double[2][nn];
        double[][] newErrors = new double[2][nn];
        int i = 0;
        while ((double)i < this.npoints) {
            newHeights[0][i] = this.h.getX(i);
            newHeights[1][i] = this.h.getY(i);
            ++i;
        }
        return new double[][][]{newHeights, newErrors};
    }

    @Override
    public String getType() {
        return "scatter";
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.h.getTitle();
    }

    @Override
    public Statistics getStatistics() {
        return this;
    }

    @Override
    public String[] getStatisticNames() {
        return new String[]{"Entries", "Mean_X", "RMS_X", "Mean_Y", "RMS_Y"};
    }

    private double meanX() {
        return this.h.meanX();
    }

    public double rmsX() {
        return this.h.rmsX();
    }

    private double meanY() {
        return this.h.meanY();
    }

    public double rmsY() {
        return this.h.rmsY();
    }

    @Override
    public double getStatistic(String name) {
        if (name.equals("Entries")) {
            return this.h.size();
        }
        if (name.equals("Mean_X")) {
            return this.meanX();
        }
        if (name.equals("RMS_X")) {
            return this.rmsX();
        }
        if (name.equals("Mean_Y")) {
            return this.meanY();
        }
        if (name.equals("RMS_Y")) {
            return this.rmsY();
        }
        return 0.0;
    }

    @Override
    public double getXMin() {
        return this.h.getMax(0);
    }

    @Override
    public double getXMax() {
        return this.h.getMax(0);
    }

    @Override
    public double getYMin() {
        return this.h.getMin(1);
    }

    @Override
    public double getYMax() {
        return this.h.getMax(1);
    }

    @Override
    public int getXAxisType() {
        return 1;
    }

    @Override
    public int getYAxisType() {
        return 1;
    }

    @Override
    public String[] getXAxisLabels() {
        return null;
    }

    @Override
    public String[] getYAxisLabels() {
        return null;
    }

    @Override
    public ScatterEnumeration startEnumeration() {
        return new TestEnumeration();
    }

    @Override
    public ScatterEnumeration startEnumeration(double a, double b, double c, double d) {
        return new TestEnumeration(a, b, c, d);
    }

    @Override
    public int getXBins() {
        return 0;
    }

    @Override
    public int getYBins() {
        return 0;
    }

    @Override
    public boolean hasScatterPlotData() {
        return false;
    }

    private class TestEnumeration
    implements ScatterEnumeration {
        private int n;
        private boolean limits;
        private double ymin;
        private double ymax;
        private double xmin;
        private double xmax;

        TestEnumeration() {
            this.n = 0;
            this.limits = false;
        }

        TestEnumeration(double xmin, double xmax, double ymin, double ymax) {
            this.n = 0;
            this.xmin = xmin;
            this.xmax = xmax;
            this.ymin = ymin;
            this.ymax = ymax;
            this.limits = true;
        }

        @Override
        public boolean getNextPoint(double[] d) {
            if (this.limits) {
                while ((double)this.n < CopyOfRefP1D_2Dhisto.this.npoints) {
                    if (CopyOfRefP1D_2Dhisto.this.x[this.n] >= this.xmin && CopyOfRefP1D_2Dhisto.this.x[this.n] < this.xmax && CopyOfRefP1D_2Dhisto.this.y[this.n] >= this.ymin && CopyOfRefP1D_2Dhisto.this.y[this.n] < this.ymax) {
                        d[0] = CopyOfRefP1D_2Dhisto.this.x[this.n];
                        d[1] = CopyOfRefP1D_2Dhisto.this.y[this.n];
                        ++this.n;
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }
            if ((double)this.n == CopyOfRefP1D_2Dhisto.this.npoints) {
                return false;
            }
            d[0] = CopyOfRefP1D_2Dhisto.this.x[this.n];
            d[1] = CopyOfRefP1D_2Dhisto.this.y[this.n];
            ++this.n;
            return true;
        }

        @Override
        public void resetEndPoint() {
        }

        @Override
        public void restart() {
            this.n = 0;
        }
    }
}

