/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import jasext.jhplotserver.CharSequenceCompilerException;
import jasext.jhplotserver.ClassLoaderImpl;
import jasext.jhplotserver.FileManagerImpl;
import jasext.jhplotserver.JavaFileObjectImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class CharSequenceCompiler<T> {
    static final String JAVA_EXTENSION = ".java";
    private final ClassLoaderImpl classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> options;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final FileManagerImpl javaFileManager;

    public CharSequenceCompiler(ClassLoader loader, Iterable<String> options) {
        if (this.compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.classLoader = new ClassLoaderImpl(loader);
        this.diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        this.javaFileManager = new FileManagerImpl(fileManager, this.classLoader);
        this.options = new ArrayList<String>();
        if (options != null) {
            for (String option : options) {
                this.options.add(option);
            }
        }
    }

    public synchronized Class<T> compile(String qualifiedClassName, CharSequence javaSource, DiagnosticCollector<JavaFileObject> diagnosticsList, Class<?> ... types) throws CharSequenceCompilerException, ClassCastException {
        this.diagnostics = diagnosticsList != null ? diagnosticsList : new DiagnosticCollector();
        HashMap<String, CharSequence> classes = new HashMap<String, CharSequence>(1);
        classes.put(qualifiedClassName, javaSource);
        Map<String, Class<T>> compiled = this.compile(classes, diagnosticsList);
        Class<T> newClass = compiled.get(qualifiedClassName);
        return this.castable(newClass, types);
    }

    public synchronized Map<String, Class<T>> compile(Map<String, CharSequence> classes, DiagnosticCollector<JavaFileObject> diagnosticsList) throws CharSequenceCompilerException {
        ArrayList<JavaFileObjectImpl> sources = new ArrayList<JavaFileObjectImpl>();
        for (Map.Entry<String, CharSequence> entry : classes.entrySet()) {
            String qualifiedClassName = entry.getKey();
            CharSequence javaSource = entry.getValue();
            if (javaSource == null) continue;
            int dotPos = qualifiedClassName.lastIndexOf(46);
            String className = dotPos == -1 ? qualifiedClassName : qualifiedClassName.substring(dotPos + 1);
            String packageName = dotPos == -1 ? "" : qualifiedClassName.substring(0, dotPos);
            JavaFileObjectImpl source = new JavaFileObjectImpl(className, javaSource);
            sources.add(source);
            this.javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + JAVA_EXTENSION, source);
        }
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.javaFileManager, this.diagnostics, this.options, null, sources);
        Boolean result = task.call();
        if (result == null || !result.booleanValue()) {
            throw new CharSequenceCompilerException("Compilation failed.", classes.keySet(), this.diagnostics);
        }
        try {
            HashMap<String, Class<T>> compiled = new HashMap<String, Class<T>>();
            for (String qualifiedClassName : classes.keySet()) {
                Class<T> newClass = this.loadClass(qualifiedClassName);
                compiled.put(qualifiedClassName, newClass);
            }
            return compiled;
        }
        catch (ClassNotFoundException e) {
            throw new CharSequenceCompilerException(classes.keySet(), e, this.diagnostics);
        }
        catch (IllegalArgumentException e) {
            throw new CharSequenceCompilerException(classes.keySet(), e, this.diagnostics);
        }
        catch (SecurityException e) {
            throw new CharSequenceCompilerException(classes.keySet(), e, this.diagnostics);
        }
    }

    public Class<T> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.classLoader.loadClass(qualifiedClassName);
    }

    private Class<T> castable(Class<T> newClass, Class<?> ... types) throws ClassCastException {
        for (Class<T> clazz : types) {
            if (clazz.isAssignableFrom(newClass)) continue;
            throw new ClassCastException(clazz.getName());
        }
        return newClass;
    }

    static URI toURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.javaFileManager.getClassLoader();
    }
}

