/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.Handle;
import jas2.hist.HasHandles;

public class StraightLineFunction
extends Fittable1DFunction
implements HasHandles {
    private double[] p = new double[2];

    StraightLineFunction(double slope, double yoffset) {
        this.p[0] = slope;
        this.p[1] = yoffset;
    }

    public StraightLineFunction(double xmin, double xmax, double ymin, double ymax) {
        this.p[0] = xmax != xmin ? (ymax - ymin) / (xmax - xmin) : 0.0;
        this.p[1] = ymin - xmin * this.p[0];
    }

    @Override
    public double valueAt(double x) {
        return this.valueAt(x, this.p);
    }

    @Override
    public double valueAt(double x, double[] a) {
        return a[1] + x * a[0];
    }

    private double valueFor(double y) {
        return (y - this.p[1]) / this.p[0];
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[]{"slope", "yoffset"};
        return result;
    }

    @Override
    public double[] getParameterValues() {
        return this.p;
    }

    @Override
    public void setParameter(int index, double value) {
        if (index > this.p.length) {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.p[index] = value;
        this.clearFit();
        this.setChanged();
    }

    @Override
    public void setFit(Fitter fit, double[] a) {
        if (a.length != this.p.length) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        System.arraycopy(a, 0, this.p, 0, this.p.length);
        this.setFit(fit);
        this.setChanged();
    }

    @Override
    public String getTitle() {
        return "Straight Line";
    }

    @Override
    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        int nHandle = 0;
        double[] intersectX = new double[4];
        double[] intersectY = new double[4];
        double x = xLow;
        double y = this.valueAt(x);
        if (y >= yLow && y <= yHigh) {
            intersectX[nHandle] = x;
            intersectY[nHandle] = y;
            ++nHandle;
        }
        if ((y = this.valueAt(x = xHigh)) >= yLow && y <= yHigh) {
            intersectX[nHandle] = x;
            intersectY[nHandle] = y;
            ++nHandle;
        }
        if ((x = this.valueFor(y = yLow)) > xLow && x < xHigh) {
            intersectX[nHandle] = x;
            intersectY[nHandle] = y;
            ++nHandle;
        }
        if ((x = this.valueFor(y = yHigh)) > xLow && x < xHigh) {
            intersectX[nHandle] = x;
            intersectY[nHandle] = y;
            ++nHandle;
        }
        if (nHandle == 2) {
            Handle[] result = new SLHandle[]{new SLHandle(intersectX[0] + (intersectX[1] - intersectX[0]) * 0.1, intersectY[0] + (intersectY[1] - intersectY[0]) * 0.1), new SLHandle(intersectX[0] + (intersectX[1] - intersectX[0]) * 0.9, intersectY[0] + (intersectY[1] - intersectY[0]) * 0.9)};
            result[0].setPartner(result[1]);
            result[1].setPartner(result[0]);
            return result;
        }
        return new Handle[0];
    }

    private class SLHandle
    extends Handle {
        private double x;
        private double y;
        private SLHandle partner;

        SLHandle(double x, double y) {
            this.x = x;
            this.y = y;
        }

        void setPartner(SLHandle partner) {
            this.partner = partner;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void moveTo(double x, double y) {
            this.x = x;
            this.y = y;
            ((StraightLineFunction)StraightLineFunction.this).p[0] = this.partner.x != x ? (this.partner.y - y) / (this.partner.x - x) : 0.0;
            ((StraightLineFunction)StraightLineFunction.this).p[1] = y - x * StraightLineFunction.this.p[0];
            StraightLineFunction.this.clearFit();
            StraightLineFunction.this.setChanged();
        }
    }
}

