/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.Basic1DFunction;
import jas2.hist.FunctionAdvancedOptions;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.util.JASDialog;
import jas2.util.JASTextField;
import jasext.hist.function.Spline;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplineFunction
extends Basic1DFunction
implements FunctionAdvancedOptions {
    private Spline spline;
    private double smoothness;
    final double initialSmoothness = 10.0;

    @Override
    public String[] getParameterNames() {
        String[] result = new String[]{"Smoothness"};
        return result;
    }

    @Override
    public double[] getParameterValues() {
        double[] result = new double[]{this.smoothness};
        return result;
    }

    @Override
    public String getTitle() {
        return "Cubic Spline";
    }

    @Override
    public void setParameter(int index, double value) {
        this.smoothness = value;
        this.setChanged();
    }

    @Override
    public double valueAt(double x) {
        return this.spline.get(x);
    }

    private void init(Rebinnable1DHistogramData data) {
        double[] yerr;
        int i;
        this.smoothness = 10.0;
        int bins = data.getBins();
        double min = data.getMin();
        double max = data.getMax();
        double bw = (max - min) / (double)bins;
        double[][] binnedData = data.rebin(bins, min, max, true, false);
        double[] x = new double[bins];
        double[] y = binnedData[0];
        if (binnedData.length > 2 && binnedData[1] != binnedData[2]) {
            throw new RuntimeException("Cannot create spline fit for data with asymetric error bars");
        }
        double xx = min + bw / 2.0;
        for (i = 0; i < bins; ++i) {
            x[i] = xx;
            xx += bw;
        }
        if (binnedData.length > 1) {
            yerr = binnedData[1];
        } else {
            yerr = new double[bins];
            for (i = 0; i < bins; ++i) {
                yerr[i] = Math.sqrt(y[i]);
            }
        }
        double emptyCode = min - 1.0;
        this.spline = new Spline(bins, emptyCode);
        for (int i2 = 0; i2 < bins; ++i2) {
            if (!(yerr[i2] > 0.0)) continue;
            this.spline.add(x[i2], y[i2], yerr[i2]);
        }
        this.spline.calcApproximation(this.smoothness);
    }

    SplineFunction(Rebinnable1DHistogramData data) {
        this.init(data);
    }

    private synchronized void setSmoothness(double d) {
        this.smoothness = d;
        this.spline.calcApproximation(this.smoothness);
        this.setChanged();
    }

    @Override
    public void openAdvancedDialog(Frame f, JASHist hist) {
        new SplineFunctionAdvancedDialog(f, hist);
    }

    private double getSmoothness() {
        return this.smoothness;
    }

    private class SplineFunctionAdvancedDialog
    extends JASDialog {
        private final NumberFormat format;
        final int sliderMin = 10;
        final int sliderMax = 1000;
        final double maxSmoothness = 100.0;
        final double minSmoothness = 1.0;
        double smoothness;

        private int toInt(double smoothness) {
            double fractionIncrease = (smoothness - 1.0) / 99.0;
            int increase = (int)(fractionIncrease * 990.0);
            return increase + 10;
        }

        SplineFunctionAdvancedDialog(Frame f, JASHist hist) {
            super(f, "Advanced...", true, 1);
            this.format = NumberFormat.getInstance();
            this.sliderMin = 10;
            this.sliderMax = 1000;
            this.maxSmoothness = 100.0;
            this.minSmoothness = 1.0;
            this.format.setMaximumFractionDigits(5);
            this.smoothness = SplineFunction.this.getSmoothness();
            final JSlider s = new JSlider(0, 10, 1000, this.toInt(this.smoothness));
            final JASTextField tf = new JASTextField(String.valueOf(this.smoothness), 5);
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent te) {
                    try {
                        SplineFunctionAdvancedDialog.this.smoothness = Double.valueOf(tf.getText());
                        if (SplineFunctionAdvancedDialog.this.smoothness < 0.0) {
                            SplineFunctionAdvancedDialog.this.smoothness = 0.0;
                        }
                        double temp = SplineFunctionAdvancedDialog.this.smoothness;
                        s.setValue(SplineFunctionAdvancedDialog.this.toInt(SplineFunctionAdvancedDialog.this.smoothness));
                        tf.setText(String.valueOf(temp));
                        SplineFunctionAdvancedDialog.this.smoothness = temp;
                        SplineFunction.this.setSmoothness(SplineFunctionAdvancedDialog.this.smoothness);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            s.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int increase = s.getValue() - 10;
                    double fractionIncrease = (double)increase / 990.0;
                    SplineFunctionAdvancedDialog.this.smoothness = 1.0 + 99.0 * fractionIncrease;
                    SplineFunction.this.setSmoothness(SplineFunctionAdvancedDialog.this.smoothness);
                    tf.setText(SplineFunctionAdvancedDialog.this.format.format(SplineFunctionAdvancedDialog.this.smoothness));
                }
            });
            Vector<JASHistData> model = new Vector<JASHistData>();
            Enumeration e = hist.getDataSources();
            while (e.hasMoreElements()) {
                JASHistData d = (JASHistData)e.nextElement();
                if (!(d.getDataSource() instanceof Rebinnable1DHistogramData)) continue;
                model.addElement(d);
            }
            JComboBox data = new JComboBox(model);
            data.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    JASHistData d = (JASHistData)ev.getItem();
                    new SplineFunction((Rebinnable1DHistogramData)d.getFittableDataSource());
                    SplineFunction.this.setChanged();
                }
            });
            Container c = this.getContentPane();
            c.setLayout(new GridLayout(6, 1));
            c.add(new JLabel("Set spline smoothness."));
            c.add(new JLabel("Slider range is 1.0 to 100.0"));
            c.add(s);
            c.add(tf);
            c.add(new JLabel("Select data source:"));
            c.add(data);
            this.pack();
            this.show();
        }
    }
}

