/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jasext.hist.function.AbstractPolynomialFunction;

public class QuadraticFunction
extends AbstractPolynomialFunction {
    QuadraticFunction(double[] coefficients) {
        this.p = coefficients;
    }

    public QuadraticFunction(double xmin, double xmax, double ymin, double ymax) {
        this.order = 2;
        this.p = new double[3];
        double xVertex = (xmax - xmin) / 2.0;
        this.p[0] = (ymax - ymin) / Math.pow(xmax - xVertex, 2.0);
        this.p[1] = -this.p[0] * (xmax - xmin);
        this.p[2] = ymin - this.p[0] * xVertex * xVertex - this.p[1] * xVertex;
    }

    @Override
    public String getTitle() {
        return "Quadratic";
    }
}

