/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.Handle;
import jas2.hist.HasHandles;

public class LorentzianFunction
extends Fittable1DFunction
implements HasHandles {
    private double amp;
    private double origin;
    private double width;

    LorentzianFunction(double amplitude, double origin, double width) {
        this.amp = amplitude;
        this.origin = origin;
        this.width = width;
    }

    public LorentzianFunction(double xmin, double xmax, double ymin, double ymax) {
        this.origin = (xmax + xmin) * 0.5;
        this.width = (xmax - xmin) / 4.0;
        this.amp = ymin + (ymax - ymin) * 0.9;
    }

    @Override
    public double valueAt(double x) {
        double gamma2 = this.width * this.width / 4.0;
        return this.amp * gamma2 / ((x - this.origin) * (x - this.origin) + gamma2);
    }

    @Override
    public double valueAt(double x, double[] a) {
        double gamma2 = a[2] * a[2] / 4.0;
        return a[0] * gamma2 / ((x - a[1]) * (x - a[1]) + gamma2);
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[]{"amplitude", "origin", "width"};
        return result;
    }

    @Override
    public double[] getParameterValues() {
        double[] result = new double[]{this.amp, this.origin, this.width};
        return result;
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.amp = value;
        } else if (index == 1) {
            this.origin = value;
        } else if (index == 2) {
            this.width = value;
        } else {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    @Override
    public void setFit(Fitter fit, double[] value) {
        if (value.length != 3) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.amp = value[0];
        this.origin = value[1];
        this.width = value[2];
        this.setFit(fit);
        this.setChanged();
    }

    @Override
    public String getTitle() {
        return "Lorentzian";
    }

    @Override
    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        Handle[] result = new Handle[]{new Handle(){

            @Override
            public void moveTo(double x, double y) {
                LorentzianFunction.this.amp = y;
                LorentzianFunction.this.origin = x;
                LorentzianFunction.this.clearFit();
                LorentzianFunction.this.setChanged();
            }

            @Override
            public double getX() {
                return LorentzianFunction.this.origin;
            }

            @Override
            public double getY() {
                return LorentzianFunction.this.amp;
            }
        }, new Handle(){

            @Override
            public void moveTo(double x, double y) {
                LorentzianFunction.this.width = 2.0 * (x - LorentzianFunction.this.origin);
                LorentzianFunction.this.clearFit();
                LorentzianFunction.this.setChanged();
            }

            @Override
            public double getY() {
                return LorentzianFunction.this.amp / 2.0;
            }

            @Override
            public double getX() {
                return LorentzianFunction.this.origin + LorentzianFunction.this.width / 2.0;
            }
        }, new Handle(){

            @Override
            public void moveTo(double x, double y) {
                LorentzianFunction.this.width = 2.0 * (LorentzianFunction.this.origin - x);
                LorentzianFunction.this.clearFit();
                LorentzianFunction.this.setChanged();
            }

            @Override
            public double getY() {
                return LorentzianFunction.this.amp / 2.0;
            }

            @Override
            public double getX() {
                return LorentzianFunction.this.origin - LorentzianFunction.this.width / 2.0;
            }
        }};
        return result;
    }
}

