/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import hepjas.analysis.AbstractNTupleEventData;
import hepjas.analysis.EndOfDataException;
import hepjas.analysis.EventData;
import hepjas.analysis.EventDataException;
import hepjas.analysis.NTupleEventData;
import jas2.jds.module.AnnotatedEventSource;
import jas2.jds.module.LocalJobBuilder;
import jas2.util.ArbitraryNameGenerator;
import jas2.util.FileReaderWithProgressBar;
import jas2.util.tree.TreeItem;
import jasext.flatfileserver.AbsentFieldValue;
import jasext.flatfileserver.BadFieldValue;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.ExponentialFormat;
import jasext.flatfileserver.ExtraFieldValue;
import jasext.flatfileserver.FlatFileException;
import jasext.flatfileserver.FlatFileSyntaxException;
import jasext.flatfileserver.IntegerFormat;
import jasext.flatfileserver.NoDataFound;
import jasext.flatfileserver.StringDataColumn;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public class FlatFileEventSource
implements AnnotatedEventSource {
    public static final int NO_STRING_DELIMITER = -4;
    public static final int WHITESPACE_DELIMITED = -4;
    private DataColumn[] data;
    private int ith_event = 0;
    private NTupleEventData event = new FlatFileEventData();
    private Hashtable fieldNameHash = new Hashtable();
    private int fieldCount;
    private int rowCount;
    private int quoteChar = -4;
    private int delimChar = -4;
    private String m_name;
    private String m_nameOnTree;
    private boolean m_containsHeaders = true;
    private boolean m_firstLineContainsTitle = false;
    private boolean m_gzip = false;
    private BoundedRangeModel m_model = null;
    private LocalJobBuilder m_ljb = null;
    private String m_dateTimeFormat = "dd-MMM-yyyy hh:mm:ss";
    private String m_timeFormat = "hh:mm:ss";
    private String m_dateFormat = "dd-MMM-yyyy";
    private Format[] formats = new Format[]{new IntegerFormat(), new SimpleDateFormat(this.m_dateTimeFormat), new SimpleDateFormat(this.m_timeFormat), new SimpleDateFormat(this.m_dateFormat), new ExponentialFormat()};

    public FlatFileEventSource(String s) throws FlatFileException {
        this.m_name = s;
        this.init();
    }

    public FlatFileEventSource() {
    }

    @Override
    public Class getEventDataClass() {
        return NTupleEventData.class;
    }

    @Override
    public void close() {
    }

    public void init() throws FlatFileException {
        try {
            if (this.m_ljb != null) {
                this.m_ljb.setMessage("Opening file " + this.m_name);
            }
            BufferedReader input = this.m_gzip ? (this.m_model == null ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.m_name)))) : new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileReaderWithProgressBar(this.m_name, this.m_model))))) : (this.m_model == null ? new BufferedReader(new FileReader(this.m_name)) : new BufferedReader(new InputStreamReader(new FileReaderWithProgressBar(this.m_name, this.m_model))));
            StreamTokenizer in = new StreamTokenizer(input);
            in.resetSyntax();
            in.eolIsSignificant(true);
            try {
                this.retrieveData(in);
            }
            catch (FlatFileSyntaxException e) {
                throw new FlatFileException("Error reading " + this.m_name + " at line " + in.lineno(), e);
            }
            catch (Throwable e) {
                throw new FlatFileException("Error while reading: " + this.m_name, e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            throw new FlatFileException("Cannot open: " + this.m_name, e);
        }
        catch (IOException e) {
            throw new FlatFileException("Cannot open: " + this.m_name, e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void retrieveData(StreamTokenizer in) throws IOException, FlatFileSyntaxException {
        block27: {
            block24: {
                this.fieldCount = 0;
                if (this.m_firstLineContainsTitle) {
                    in.wordChars(0, 65535);
                    in.whitespaceChars(10, 13);
                    in.nextToken();
                    this.m_nameOnTree = in.sval;
                    in.nextToken();
                } else {
                    this.m_nameOnTree = this.format(this.m_name);
                }
                in.whitespaceChars(0, 32);
                in.wordChars(33, 255);
                if (this.quoteChar != -4) {
                    in.quoteChar(this.quoteChar);
                }
                if (this.delimChar != -4) {
                    in.ordinaryChar(this.delimChar);
                    in.wordChars(32, 32);
                }
                if (!this.m_containsHeaders) break block24;
                this.rowCount = 0;
                fieldNameList = new Vector<String>();
                in.nextToken();
                while (in.ttype != -1) {
                    block26: {
                        block25: {
                            if (in.ttype == 10) break;
                            if (this.fieldCount != 0 && in.ttype == this.delimChar) {
                                in.nextToken();
                            }
                            if (in.ttype == this.delimChar) break block25;
                            if (in.ttype != 10) break block26;
                        }
                        fieldNameList.addElement("");
                        ++this.fieldCount;
                        continue;
                    }
                    if (in.ttype != -3 && in.ttype != this.quoteChar) {
                        throw new BadFieldValue();
                    }
                    fieldNameList.addElement(in.sval.trim());
                    ++this.fieldCount;
                    in.nextToken();
                }
                this.data = new DataColumn[this.fieldCount];
                for (i = 0; i < this.fieldCount; ++i) {
                    this.data[i] = new StringDataColumn((String)fieldNameList.elementAt(i));
                    this.fieldNameHash.put(fieldNameList.elementAt(i), new Integer(i));
                }
                break block27;
            }
            this.rowCount = 1;
            firstRowData = new Vector<String>();
            in.nextToken();
            while (in.ttype != 10) {
                if (in.ttype == -1) break;
                if (this.fieldCount != 0 && in.ttype == this.delimChar) {
                    in.nextToken();
                }
                if (in.ttype == this.delimChar) ** GOTO lbl-1000
                if (in.ttype == 10) lbl-1000:
                // 2 sources

                {
                    firstRowData.addElement(null);
                } else {
                    if (in.ttype != -3 && in.ttype != this.quoteChar) {
                        throw new BadFieldValue();
                    }
                    firstRowData.addElement(in.sval.trim());
                    in.nextToken();
                }
                ++this.fieldCount;
            }
            this.data = new DataColumn[this.fieldCount];
            fieldNames = new String[this.fieldCount];
            new ArbitraryNameGenerator().fillArray(fieldNames);
            for (i = 0; i < this.fieldCount; ++i) {
                this.data[i] = new StringDataColumn(fieldNames[i]);
                ((StringDataColumn)this.data[i]).addRow((String)firstRowData.elementAt(i));
                this.fieldNameHash.put(fieldNames[i], new Integer(i));
            }
        }
        if (in.ttype == -1) {
            throw new NoDataFound();
        }
        if (this.m_ljb != null) {
            this.m_ljb.setMessage("Reading file " + this.m_name);
        }
        while (in.ttype != -1) {
            in.nextToken();
            if (in.ttype == -1) break;
            if (in.ttype == 10) continue;
            this.readDataRow(in);
            ++this.rowCount;
        }
        if (this.m_ljb != null) {
            this.m_ljb.setMessage("Converting " + this.m_name);
            this.m_model.setRangeProperties(0, 0, 0, this.fieldCount - 1, false);
        }
        for (i = 0; i < this.fieldCount; ++i) {
            this.data[i] = ((StringDataColumn)this.data[i]).convert(this.formats);
            if (this.m_model == null) continue;
            this.m_model.setValue(i);
        }
        if (this.m_ljb != null) {
            this.m_ljb.setMessage("Processing complete: file " + this.m_name);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readDataRow(StreamTokenizer in) throws IOException, BadFieldValue, AbsentFieldValue, ExtraFieldValue {
        int currentField = 0;
        while (in.ttype != 10) {
            block10: {
                block9: {
                    if (in.ttype == -1) break;
                    if (currentField != 0 && in.ttype == this.delimChar) {
                        in.nextToken();
                    }
                    if (in.ttype == this.delimChar) break block9;
                    if (in.ttype != 10) break block10;
                }
                if (currentField >= this.fieldCount) {
                    throw new ExtraFieldValue();
                }
                ((StringDataColumn)this.data[currentField]).addRow(null);
                ++currentField;
                continue;
            }
            if (in.ttype != -3 && in.ttype != this.quoteChar) {
                throw new BadFieldValue();
            }
            if (currentField >= this.fieldCount) {
                throw new ExtraFieldValue();
            }
            ((StringDataColumn)this.data[currentField]).addRow(in.sval.trim());
            ++currentField;
            in.nextToken();
        }
        if (currentField < this.fieldCount) {
            throw new AbsentFieldValue();
        }
    }

    public String getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public void setDateTimeFormat(String s) {
        this.m_dateTimeFormat = s;
        this.formats[1] = new SimpleDateFormat(s);
    }

    public String getTimeFormat() {
        return this.m_timeFormat;
    }

    public void setTimeFormat(String s) {
        this.m_timeFormat = s;
        this.formats[2] = new SimpleDateFormat(s);
    }

    public String getDateFormat() {
        return this.m_dateFormat;
    }

    public void setDateFormat(String s) {
        this.m_dateFormat = s;
        this.formats[3] = new SimpleDateFormat(s);
    }

    public int getDelim() {
        return this.delimChar;
    }

    public void setDelim(int c) {
        this.delimChar = c;
    }

    public int getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(int c) {
        this.quoteChar = c;
    }

    public String getFileName() {
        return this.m_name;
    }

    public void setFileName(String s) {
        this.m_name = s;
    }

    public boolean getHasHeaders() {
        return this.m_containsHeaders;
    }

    public void setHasHeaders(boolean b) {
        this.m_containsHeaders = b;
    }

    public boolean getFirstLineHasTitle() {
        return this.m_firstLineContainsTitle;
    }

    public void setFirstLineHasTitle(boolean b) {
        this.m_firstLineContainsTitle = b;
    }

    public boolean getGZIP() {
        return this.m_gzip;
    }

    public void setGZIP(boolean b) {
        this.m_gzip = b;
    }

    void setLocalJobBuilder(LocalJobBuilder ljb) {
        this.m_ljb = ljb;
        if (this.m_ljb != null) {
            this.m_model = new DefaultBoundedRangeModel();
            this.m_ljb.setProgressModel(this.m_model);
        }
    }

    private String format(String fileName) {
        try {
            String sep = File.separator;
            int sepIndex = fileName.lastIndexOf(sep);
            sepIndex = sepIndex >= 0 ? (sepIndex += sep.length()) : 0;
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex > sepIndex) {
                return fileName.substring(sepIndex, dotIndex);
            }
            return fileName.substring(sepIndex);
        }
        catch (Exception e) {
            return fileName;
        }
    }

    @Override
    public TreeItem[] getItems() {
        TreeItem[] result = new TreeItem[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            result[i] = new TreeItem();
            result[i].path = new String[1];
            result[i].path[0] = this.data[i].getTitle();
            result[i].type = this.data[i].getType();
        }
        return result;
    }

    @Override
    public Object getItem(TreeItem i) {
        int column_num = (Integer)this.fieldNameHash.get(i.path[i.path.length - 1]);
        return this.data[column_num];
    }

    @Override
    public int getTotalNumberOfEvents() {
        return this.rowCount;
    }

    @Override
    public void beforeFirstEvent() {
        this.ith_event = -1;
    }

    @Override
    public void afterLastEvent() {
    }

    @Override
    public EventData getNextEvent() throws EndOfDataException {
        if (++this.ith_event >= this.rowCount) {
            throw new EndOfDataException();
        }
        return this.event;
    }

    @Override
    public String getName() {
        return this.m_nameOnTree;
    }

    private class FlatFileEventData
    extends AbstractNTupleEventData {
        private FlatFileEventData() {
        }

        @Override
        public double getDouble(String name) {
            Integer column = (Integer)FlatFileEventSource.this.fieldNameHash.get(name);
            if (column == null) {
                throw new EventDataException("Can not find column " + name);
            }
            return FlatFileEventSource.this.data[column].getDouble(FlatFileEventSource.this.ith_event);
        }

        @Override
        public int getInt(String name) {
            Integer column = (Integer)FlatFileEventSource.this.fieldNameHash.get(name);
            if (column == null) {
                throw new EventDataException("Can not find column " + name);
            }
            return FlatFileEventSource.this.data[column].getInt(FlatFileEventSource.this.ith_event);
        }

        @Override
        public Date getDate(String name) {
            Integer column = (Integer)FlatFileEventSource.this.fieldNameHash.get(name);
            if (column == null) {
                throw new EventDataException("Can not find column " + name);
            }
            return FlatFileEventSource.this.data[column].getDate(FlatFileEventSource.this.ith_event);
        }

        @Override
        public String getString(String name) {
            Integer column = (Integer)FlatFileEventSource.this.fieldNameHash.get(name);
            if (column == null) {
                throw new EventDataException("Can not find column " + name);
            }
            return FlatFileEventSource.this.data[column].getString(FlatFileEventSource.this.ith_event);
        }

        @Override
        public double getDouble(int column) {
            return FlatFileEventSource.this.data[column].getDouble(FlatFileEventSource.this.ith_event);
        }

        @Override
        public int getInt(int column) {
            return FlatFileEventSource.this.data[column].getInt(FlatFileEventSource.this.ith_event);
        }

        @Override
        public Date getDate(int column) {
            return FlatFileEventSource.this.data[column].getDate(FlatFileEventSource.this.ith_event);
        }

        @Override
        public String getString(int column) {
            return FlatFileEventSource.this.data[column].getString(FlatFileEventSource.this.ith_event);
        }

        @Override
        public int findColumn(String name) {
            Integer column = (Integer)FlatFileEventSource.this.fieldNameHash.get(name);
            if (column == null) {
                throw new EventDataException("Can not find column " + name);
            }
            return column;
        }
    }
}

