/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas2.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.StringDataColumn;

class DoubleDataColumn
extends DataColumn {
    private double min = 0.0;
    private double max = 1.0;
    private double[] data;

    DoubleDataColumn(StringDataColumn source) {
        super(source);
        this.data = new double[source.getSize()];
        if (this.data.length > 0) {
            String s = source.getString(0);
            this.max = s == null ? 0.0 : Double.valueOf(s);
            this.min = this.max;
        }
        for (int i = 0; i < this.data.length; ++i) {
            double d;
            String s = source.getString(i);
            double d2 = d = s == null ? 0.0 : Double.valueOf(s);
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
            this.data[i] = d;
        }
    }

    public int getSize() {
        return this.data.length;
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        double[] hist = new double[bins];
        double binWidth = (max - min) / (double)bins;
        for (int j = 0; j < bins; ++j) {
            hist[j] = 0.0;
        }
        for (int i = 0; i < this.data.length; ++i) {
            double x = this.data[i];
            if (!(x >= min) || !(x < max)) continue;
            int n = (int)((x - min) / binWidth);
            hist[n] = hist[n] + 1.0;
        }
        double[][] result = new double[][]{hist};
        return result;
    }

    @Override
    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public int getBins() {
        return 40;
    }

    @Override
    double getDouble(int n) {
        return this.data[n];
    }

    @Override
    String getType() {
        return "float";
    }

    public Statistics getStatistics() {
        return null;
    }
}

