/*
 * Decompiled with CFR 0.152.
 */
package jas2main;

import hep.aida.IAnalysisFactory;
import hep.aida.IFitFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hepjas.analysis.EventSource;
import hepjas.analysis.Job;
import jas2.hist.FunctionRegistry;
import jas2.hist.JASHist;
import jas2.jds.module.ServerRegistry;
import jas2.loader.ClassPathLoader;
import jas2.plugin.ExtensionPluginContext;
import jas2.plugin.IExtensionPlugin;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASPage;
import jas2.swingstudio.JASToolbarHolder;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.LocalJob;
import jasext.flatfileserver.FlatFileServer;
import jasext.jhplotserver.CharSequenceCompiler;
import jasext.jhplotserver.CharSequenceCompilerException;
import jasext.jhplotserver.FunctionData1DWithType;
import jasext.jhplotserver.JHServer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.utils.Util;
import org.freehep.graphicsbase.util.export.ExportFileType;

public class HPlotJas {
    private static int N1 = 0;
    private static int N2 = 0;
    private int xsize;
    private int ysize;
    private String title = "";
    private static final String rootKey = HPlotJas.class.getName();
    private static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    private static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";
    private JavaAnalysisStudio theApp;
    private Job job;
    private JASPage page;
    private JASHist plot;
    private JASJob m_job;
    private LocalJob localJob;
    private EventSource esource;
    private JHServer jhserver;
    private ClassPathLoader exten;
    private FunctionRegistry funcregister;
    private ArrayList<Object> olist;
    private static final Random random = new Random();
    private final CharSequenceCompiler<FunctionData1DWithType> compiler = new CharSequenceCompiler(this.getClass().getClassLoader(), Arrays.asList(new String[0]));

    public HPlotJas(String title, int xsize, int ysize, ArrayList<Object> olist) {
        ExtensionPluginContext pluginContext;
        IExtensionPlugin p;
        Class c;
        this.title = title;
        this.xsize = xsize;
        this.ysize = ysize;
        N1 = 1;
        N2 = 1;
        this.olist = olist;
        try {
            this.theApp = new JavaAnalysisStudio();
            this.theApp.setPreferredSize(new Dimension(this.xsize, this.ysize));
            this.theApp.getFrame().setSize(this.xsize, this.ysize);
            this.theApp.setNPages(1);
            JASToolbarHolder jtoolbar = this.theApp.getToolbar();
            jtoolbar.setCodeToolbarVisible(false);
            jtoolbar.setApplicationToolbarVisible(false);
            jtoolbar.setJobToolbarVisible(false);
            jtoolbar.setWebToolbarVisible(false);
            jtoolbar.setRebinSliderVisible(true);
        }
        catch (Throwable e) {
            System.err.println("Java Analysis Studio Failed to Initialize");
            e.printStackTrace();
            System.exit(1);
        }
        this.jhserver = new JHServer();
        ServerRegistry.registerServer(this.jhserver);
        FlatFileServer fhserver = new FlatFileServer(new String[0]);
        ServerRegistry.registerServer(fhserver);
        this.funcregister = FunctionRegistry.instance();
        this.exten = this.theApp.getExtensionLoader();
        try {
            c = this.exten.loadClass("jasext.hist.Register", true);
            p = (IExtensionPlugin)c.newInstance();
            pluginContext = this.theApp.getPluginContext();
            p.setPluginContext(pluginContext);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        try {
            c = this.exten.loadClass("jasext.test.Register", true);
            p = (IExtensionPlugin)c.newInstance();
            pluginContext = this.theApp.getPluginContext();
            p.setPluginContext(pluginContext);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String jobName = title;
        this.m_job = new JASJob(jobName);
        this.localJob = new LocalJob(this.m_job, jobName);
        this.job = this.localJob.currentJob();
        this.page = this.theApp.getCurrentPage();
        this.plot = this.page.getCurrentPlot();
        if (olist != null && olist.size() > 0) {
            this.visible(true);
            this.add(olist);
        }
    }

    public void add(ArrayList<Object> data) {
        this.olist = data;
        this.jhserver.addData(this.olist);
        this.esource = this.jhserver.openDataSet("jhplot");
        this.localJob.setEventSource(this.esource);
        this.m_job.setJob(this.localJob);
        this.theApp.setJob(this.m_job, true);
        FunctionRegistry func = FunctionRegistry.instance();
        for (int i = 0; i < data.size(); ++i) {
            Object o = data.get(i);
            if (!(o instanceof IFunction)) continue;
            String className = ((IFunction)o).title();
            className = className.trim();
            className = className.replaceAll("\\W", "");
            String packageName = "jasext.jhplotserver";
            FunctionData1DWithType ff = this.newFunction(packageName, className);
            ff.setH((IFunction)o);
            func.registerFunction(ff.getClass(), ff.getTitle());
        }
    }

    private String digits() {
        return '_' + Long.toHexString(random.nextLong());
    }

    private FunctionData1DWithType newFunction(String packageName, String className) {
        try {
            String qName = packageName + '.' + className;
            String source = this.fillTemplate(packageName, className);
            DiagnosticCollector<JavaFileObject> errs = new DiagnosticCollector<JavaFileObject>();
            Class<FunctionData1DWithType> compiledFunction = this.compiler.compile(qName, source, errs, FunctionData1DWithType.class);
            return compiledFunction.newInstance();
        }
        catch (CharSequenceCompilerException e) {
            System.out.println(e.getDiagnostics());
        }
        catch (InstantiationException e) {
            System.out.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private String fillTemplate(String packageName, String className) {
        String template = this.readTemplate();
        String source = template.replace("$packageName", packageName).replace("$className", className);
        return source;
    }

    public void visible(boolean vs) {
        if (vs) {
            this.theApp.showIt(true);
        } else {
            this.theApp.showIt(false);
        }
    }

    public void visible() {
        this.visible(true);
    }

    public HPlotJas(String title, ArrayList<Object> olist) {
        this(title, 700, 500, olist);
    }

    public HPlotJas(ArrayList<Object> olist) {
        this("Default", 700, 500, olist);
    }

    public HPlotJas(String title) {
        this(title, 700, 500, null);
    }

    public HPlotJas() {
        this("Default", 700, 500, null);
    }

    public void update() {
        this.m_job.setJob(this.localJob);
        this.theApp.setJob(this.m_job, true);
    }

    public void export(final String file) {
        String[] ext;
        final File f = new File(file);
        ExportFileType t = null;
        String fext = file.substring(file.lastIndexOf(46) + 1, file.length());
        List list = ExportFileType.getExportFileTypes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !fext.equalsIgnoreCase((ext = (t = (ExportFileType)iterator.next()).getExtensions())[0])) {
            t = null;
        }
        if (t == null) {
            return;
        }
        final Properties props = new Properties();
        String a = t.getDescription();
        props.put(SAVE_AS_FILE, file);
        props.put(SAVE_AS_TYPE, a);
        final ExportFileType tt = t;
        Thread tpp = new Thread(){

            @Override
            public void run() {
                try {
                    tt.exportToFile(f, (Component)HPlotJas.this.theApp.getCurrentPage(), (Component)HPlotJas.this.theApp, props, "HPlotJas (C) S.Chekanov");
                }
                catch (IOException x) {
                    Util.ErrorMessage((String)("Error when making the image " + file));
                }
            }
        };
        tpp.start();
    }

    public void exportDialog(String file) {
        String[] ext;
        File f = new File(file);
        ExportFileType t2 = null;
        String fext = file.substring(file.lastIndexOf(46) + 1, file.length());
        List list = ExportFileType.getExportFileTypes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !fext.equalsIgnoreCase((ext = (t2 = (ExportFileType)iterator.next()).getExtensions())[0])) {
            t2 = null;
        }
        Properties props = new Properties();
        String a = t2.getDescription();
        props.put(SAVE_AS_FILE, file);
        props.put(SAVE_AS_TYPE, a);
        if (t2 == null) {
            String tmp = "";
            for (ExportFileType t2 : list) {
                String[] ext2 = t2.getExtensions();
                tmp = tmp + ext2[0] + "; ";
            }
            JOptionPane.showMessageDialog(this.theApp.getCurrentPage(), "File format is not supported. \n Try " + tmp);
            return;
        }
        int ok = JOptionPane.showConfirmDialog(this.theApp.getCurrentPage(), "Create file " + file + " ?");
        if (ok == 0) {
            int ok1;
            if (f.exists() && (ok1 = JOptionPane.showConfirmDialog(this.theApp.getCurrentPage(), "Replace existing file?")) != 0) {
                return;
            }
            String ffile = file;
            ExportFileType tt = t2;
            try {
                tt.exportToFile(f, (Component)this.theApp.getCurrentPage(), (Component)this.theApp.getCurrentPage(), props, "jHPlotJa (C) S.Chekanov");
            }
            catch (IOException x) {
                System.out.println("Error when making the image " + ffile);
            }
        }
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
    }

    public String getTitle() {
        return "jhepwork";
    }

    public void close() {
        this.job = null;
        this.theApp.close();
    }

    private String colorString(Color c) {
        String rs = Integer.toString(c.getRed());
        String rg = Integer.toString(c.getGreen());
        String rb = Integer.toString(c.getBlue());
        String color = rs + "," + rg + "," + rb;
        return color;
    }

    public void draw(H1D h1) {
    }

    private String readTemplate() {
        String tmp = "";
        try {
            String line;
            InputStreamReader paramReader = new InputStreamReader(this.getClass().getResourceAsStream("/jasext/jhplotserver/RefF1D.java.template"));
            BufferedReader br = new BufferedReader(paramReader);
            while ((line = br.readLine()) != null) {
                tmp = tmp + line + "\n";
            }
            br.close();
            ((Reader)paramReader).close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return tmp;
    }

    public static void main(String[] args) {
        HPlotJas c1 = new HPlotJas("Jas");
        c1.visible(true);
        P0D p0d = new P0D("P0D");
        P0I p0i = new P0I("P0I");
        P1D p1d = new P1D("P1D");
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plot");
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        IFunction gauss = functionFactory.createFunctionFromScript("gauss", 1, "a*exp(-(x[0]-mean)*(x[0]-mean)/sigma/sigma)", "a,mean,sigma", "AGaussian");
        gauss.setParameter("a", 10.0);
        gauss.setParameter("mean", 1.0);
        gauss.setParameter("sigma", 2.0);
        IFunction parabola = functionFactory.createFunctionFromScript("parabola", 1, "background + (a*x[0]*x[0]+b*x[0]+c)", "a,b,c,background", "AParabola");
        H1D h1 = new H1D("H1D", 10, -10.0, 10.0);
        H2D h2 = new H2D("H2D", 100, -10.0, 10.0, 100, -10.0, 10.0);
        Random random = new Random();
        for (int i = 0; i < 10000; ++i) {
            p0d.add(random.nextGaussian());
            p0i.add((int)random.nextGaussian());
            h1.fill(2.0 * random.nextGaussian());
            h2.fill(random.nextGaussian(), random.nextGaussian() * 4.0);
        }
        p1d.add(0.0, 10.0, 1.0);
        p1d.add(1.0, 20.0, 1.0);
        p1d.add(2.0, 12.0, 1.0);
        ArrayList<Object> a = new ArrayList<Object>();
        a.add(p0d);
        a.add(p0i);
        a.add(h1);
        a.add(h2);
        a.add(p1d);
        a.add(gauss);
        a.add(parabola);
        c1.add(a);
    }
}

