/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.tree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TreeItem
implements Externalizable,
Cloneable {
    public String[] path;
    public String type;
    public int flags;
    public static final int HAS_SUB_ITEMS = 1;
    public static final int DELETED = 2;
    public static final int FOLDER = 4;

    public TreeItem() {
    }

    public TreeItem(String s) {
        String[] p = new String[]{s};
        this.path = p;
    }

    public TreeItem(String s, String type) {
        this(s, type, 0);
    }

    public TreeItem(String s, String type, int flags) {
        String[] p = new String[]{s};
        this.path = p;
        this.type = type;
        this.flags = flags;
    }

    public TreeItem(String[] path, String type, int flags) {
        this.path = path;
        this.type = type;
        this.flags = flags;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = (String[])in.readObject();
        this.type = (String)in.readObject();
        this.flags = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.path);
        out.writeObject(this.type);
        out.writeInt(this.flags);
    }

    public boolean equals(Object in) {
        if (!(in instanceof TreeItem)) {
            return false;
        }
        TreeItem item = (TreeItem)in;
        if (item.path.length != this.path.length) {
            return false;
        }
        if (this.path == null || item.path == null) {
            return this.path == item.path;
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i].equals(item.path[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        if (this.path != null) {
            for (int i = 0; i < this.path.length; ++i) {
                hash += this.path[i].hashCode();
            }
        }
        return hash;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.path.length; ++i) {
            result = result + "/" + this.path[i];
        }
        result = result + " [ type=" + this.type + " flags=" + Integer.toHexString(this.flags) + " ]";
        return result;
    }
}

