/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.pluginmanager;

import jas2.util.pluginmanager.PluginDownloadProgress;
import jas2.util.pluginmanager.PluginProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;

public class PluginDownloadThread
extends Thread {
    private PluginDownloadProgress progress;
    private String path;
    private Object[] plugins;
    private JOptionPane minversionpane;
    boolean stopthread;

    public PluginDownloadThread(PluginDownloadProgress progress, Object[] selected, String path) {
        super("Plugin downloader");
        this.path = path;
        this.plugins = selected;
        this.progress = progress;
        this.start();
    }

    @Override
    public void run() {
        if (this.stopthread) {
            return;
        }
        for (int i = 0; i < this.plugins.length; ++i) {
            if (this.stopthread) {
                return;
            }
            try {
                Object object = this.plugins[i];
                if (!(object instanceof PluginProperties)) continue;
                PluginProperties dummyplug = (PluginProperties)object;
                File file = this.path.compareTo("update") == 0 ? new File(dummyplug.path) : new File(this.path);
                for (int j = 0; j < dummyplug.urldownloads.length; ++j) {
                    if (this.stopthread) {
                        return;
                    }
                    URL url = dummyplug.urldownloads[j];
                    String fileName = dummyplug.files[j];
                    this.progress.downloading(fileName);
                    this.download(file.getPath() + "/" + fileName, url);
                }
                if (this.stopthread) {
                    return;
                }
                this.progress.done();
                continue;
            }
            catch (IOException io) {
                this.progress.onCancel();
                System.out.println(io);
                continue;
            }
            catch (Exception e) {
                this.progress.onCancel();
                System.out.println(e);
            }
        }
    }

    private void download(String filepath, URL url) throws Exception {
        URLConnection conn = url.openConnection();
        this.progress.setMaximum(Math.max(0, conn.getContentLength()));
        this.copy(conn.getInputStream(), new FileOutputStream(filepath), true, true);
    }

    private void copy(InputStream in, OutputStream out, boolean canStop, boolean doProgress) throws Exception {
        int count;
        in = new BufferedInputStream(in);
        out = new BufferedOutputStream(out);
        byte[] buf = new byte[4096];
        int copied = 0;
        while ((count = in.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, count);
            if (doProgress) {
                this.progress.setValue(copied += count);
            }
            if (!canStop || !this.stopthread) continue;
            in.close();
            out.close();
            return;
        }
        in.close();
        out.close();
    }

    void stopRequest() {
        this.stopthread = true;
    }
}

