/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.pluginmanager;

import jas2.util.pluginmanager.VersionNumberCompare;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AppVersionCheck
implements ActionListener {
    private JButton checknow;
    private JCheckBox checkdevelopers;
    private JCheckBox checknondevelopers;
    private JCheckBox checkstartno;
    private JCheckBox checkstartyes;
    private JOptionPane updatepane;
    private JPanel panel;
    private Container container;
    private String latestversion;
    private String appname;
    private String versionURL;
    private String currentversion;
    private Properties userprops;
    private int whichmessage;
    boolean developers;
    private static final String unknown = "unknown";

    public AppVersionCheck(String appname, String versionURL, String currentversion, Properties userprops) {
        this.userprops = userprops;
        this.appname = appname != null ? appname : unknown;
        this.versionURL = versionURL != null ? versionURL : unknown;
        this.currentversion = currentversion != null ? currentversion : unknown;
    }

    public JPanel getVersionCheckOptionPane() {
        this.panel = new JPanel(new GridLayout(7, 0));
        this.checknow = new JButton("Check For New Version Now...");
        this.checknow.addActionListener(this);
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(this.checknow);
        box.add(Box.createGlue());
        JLabel checkstartlabel = new JLabel("Would you like " + this.appname + " to check for a new application version each time the application starts?");
        JLabel checkdevelopmentlabel = new JLabel("When checking for a new version would you like to check for production or development releases?");
        this.checknondevelopers = new JCheckBox("Only check for new " + this.appname + " production release versions.");
        this.checkdevelopers = new JCheckBox("Check for new development and production releases of " + this.appname + ".");
        this.checkstartno = new JCheckBox("No, do not check at start up.");
        this.checkstartno.addActionListener(this);
        this.checkstartyes = new JCheckBox("Yes, check at start up");
        this.checkstartyes.addActionListener(this);
        ButtonGroup developergroup = new ButtonGroup();
        developergroup.add(this.checkdevelopers);
        developergroup.add(this.checknondevelopers);
        ButtonGroup startgroup = new ButtonGroup();
        startgroup.add(this.checkstartno);
        startgroup.add(this.checkstartyes);
        if (this.userprops.getProperty("DeveloperVersion", "false").equals("true")) {
            this.checkdevelopers.setSelected(true);
        } else {
            this.checknondevelopers.setSelected(true);
        }
        if (this.userprops.getProperty("UpdateOnStart", "true").equals("true")) {
            this.checkstartyes.setSelected(true);
        } else {
            this.checkstartno.setSelected(true);
        }
        this.panel.add(checkstartlabel);
        this.panel.add(this.checkstartno);
        this.panel.add(this.checkstartyes);
        this.panel.add(checkdevelopmentlabel);
        this.panel.add(this.checknondevelopers);
        this.panel.add(this.checkdevelopers);
        this.panel.add(box);
        return this.panel;
    }

    private String getLatestVersion(boolean developers) {
        if (this.versionURL.equals(unknown)) {
            return unknown;
        }
        try {
            String line;
            URL location = new URL(this.versionURL);
            URLConnection con = location.openConnection();
            String productionversion = unknown;
            String developersversion = unknown;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                if (productionversion == unknown) {
                    productionversion = line;
                    continue;
                }
                developersversion = line;
            }
            in.close();
            return developers ? developersversion : productionversion;
        }
        catch (Exception x) {
            return unknown;
        }
    }

    public int testCurrentVersion() {
        this.developers = false;
        this.developers = this.checkdevelopers != null ? this.checkdevelopers.isSelected() : new Boolean(this.userprops.getProperty("DeveloperVersion")).booleanValue();
        this.latestversion = this.getLatestVersion(this.developers);
        VersionNumberCompare versioncompare = new VersionNumberCompare();
        try {
            this.whichmessage = versioncompare.compareVersions(this.currentversion, this.latestversion, true);
        }
        catch (VersionNumberCompare.VersionCompareException vce) {
            this.whichmessage = 0;
        }
        return this.whichmessage;
    }

    public void showUpdateDialog(Container c, boolean ignoreErrors, boolean ignoreRunningCurrentVersion) {
        this.container = c;
        if (this.latestversion.equals(unknown) && ignoreErrors) {
            return;
        }
        String updatemessage = null;
        String updatetitle = "Application Version Check Dialog";
        if (this.whichmessage == 1 & this.developers) {
            int messagetype;
            int optiontype;
            updatemessage = this.appname + " developement release version " + this.latestversion + " is available. You are currently running " + this.appname + " version " + this.currentversion + ". Would you like to update " + this.appname + "?";
            int selectedbutton = JOptionPane.showConfirmDialog(this.container, updatemessage, updatetitle, optiontype = 1, messagetype = 3);
            if (selectedbutton == 0) {
                this.createDownloadUpdatesDialog();
            }
        } else if (this.whichmessage == 1 & !this.developers) {
            int messagetype;
            int optiontype;
            updatemessage = this.appname + " production release version " + this.latestversion + " is available. You are currently running " + this.appname + " version " + this.currentversion + ". Would you like to update " + this.appname + "?";
            int selectedbutton = JOptionPane.showConfirmDialog(this.container, updatemessage, updatetitle, optiontype = 1, messagetype = 3);
            if (selectedbutton == 0) {
                this.createDownloadUpdatesDialog();
            }
        } else if (this.whichmessage == 2 && !ignoreRunningCurrentVersion) {
            updatemessage = this.developers ? "You are currently running " + this.appname + " version " + this.currentversion + ", which is the latest developers version." : "You are currently running " + this.appname + " version " + this.currentversion + ", which is the latest production release version.";
            int optiontype = 2;
            int messagetype = 1;
            int selectedbutton = JOptionPane.showConfirmDialog(this.container, updatemessage, updatetitle, optiontype, messagetype);
        } else if (this.whichmessage == 0) {
            if (ignoreErrors) {
                return;
            }
            updatemessage = "User version: " + this.currentversion + ". Newest version: " + this.latestversion + ". " + this.appname + " version comparison error!!";
            int optiontype = 2;
            int messagetype = 1;
            int n = JOptionPane.showConfirmDialog(this.container, updatemessage, updatetitle, optiontype, messagetype);
        }
    }

    private void createDownloadUpdatesDialog() {
        String downloadmessage = "To update " + this.appname + " to version " + this.latestversion + " go to http://jas.freehep.org/downloads.htm.";
        String downloadtitle = "Retrieving Updates Dialog";
        int optionType = 2;
        int messagetype = 1;
        int selectedbutton = JOptionPane.showConfirmDialog(this.container, downloadmessage, downloadtitle, optionType, messagetype);
    }

    private void createCheckNowButtonPane() {
        String updatetitle = "Check Now Dialog";
        String updatemessage = "Before " + this.appname + " can check for new releases you need to select either the developer or production release version check box.";
        int optiontype = 2;
        int messagetype = 1;
        int selectedbutton = JOptionPane.showConfirmDialog(this.container, updatemessage, updatetitle, optiontype, messagetype);
    }

    public void setUserProperties() {
        if (this.checkstartno.isSelected()) {
            this.userprops.put("UpdateOnStart", "false");
        } else if (this.checkstartyes.isSelected()) {
            this.userprops.put("UpdateOnStart", "true");
        }
        if (this.checknondevelopers.isSelected()) {
            this.userprops.put("DeveloperVersion", "false");
        } else if (this.checkdevelopers.isSelected()) {
            this.userprops.put("DeveloperVersion", "true");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.checknow)) {
            if (this.checkdevelopers.isSelected() | this.checknondevelopers.isSelected()) {
                this.testCurrentVersion();
                this.showUpdateDialog(this.checknow.getParent(), false, false);
            } else {
                this.createCheckNowButtonPane();
            }
        } else if (e.getSource().equals(this.checkstartyes) && !this.checkdevelopers.isSelected() && !this.checknondevelopers.isSelected()) {
            this.checknondevelopers.setSelected(true);
        }
    }
}

