/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.multibuttontoolbar;

import jas2.util.OnScreenPopupMenu;
import jas2.util.multibuttontoolbar.MultiToolBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MultiButtonGroup {
    private Vector m_buttons = new Vector();
    private int m_visibleButtonIndex = 0;
    private int m_toolbarPositionIndex;
    private MultiToolBar m_multiToolBar;
    private MouseAdapter m_mouseAdapter;

    public MultiButtonGroup(AbstractButton b) {
        this.add(b);
        this.m_mouseAdapter = new MouseAdapter(){
            private int menuItemIndex = 0;

            @Override
            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    OnScreenPopupMenu thePopupMenu = new OnScreenPopupMenu();
                    Enumeration e = MultiButtonGroup.this.getElements();
                    ButtonGroup theMenuItemGroup = new ButtonGroup();
                    this.menuItemIndex = 0;
                    while (e.hasMoreElements()) {
                        AbstractButton theButton = (AbstractButton)e.nextElement();
                        MultiButtonMenuItem theMenuItem = new MultiButtonMenuItem(this.menuItemIndex);
                        Icon theIcon = theButton.getIcon();
                        String theText = theButton.getText();
                        if (theIcon != null) {
                            theMenuItem.setIcon(theIcon);
                        }
                        if (theText != null) {
                            theMenuItem.setText(theText);
                        }
                        if (MultiButtonGroup.this.isVisibleButton(theButton)) {
                            theMenuItem.setEnabled(false);
                        } else {
                            theMenuItem.setEnabled(true);
                        }
                        theMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int temp = ((MultiButtonMenuItem)e.getSource()).getIndex();
                                MultiButtonGroup.this.m_multiToolBar.replace(MultiButtonGroup.this.getVisibleButton(false), MultiButtonGroup.this.getButton(true, temp));
                                MultiButtonGroup.this.m_visibleButtonIndex = temp;
                                MultiButtonGroup.this.getButton(true, temp).requestFocus();
                                MultiButtonGroup.this.getButton(true, temp).doClick();
                            }
                        });
                        thePopupMenu.add(theMenuItem);
                        theMenuItemGroup.add(theMenuItem);
                        ++this.menuItemIndex;
                    }
                    ((JPopupMenu)thePopupMenu).show(me.getComponent(), me.getX(), me.getY());
                }
            }
        };
    }

    public void add(AbstractButton b) {
        this.m_buttons.addElement(b);
    }

    public void remove(AbstractButton b) {
        if (this.m_buttons.size() < 2) {
            return;
        }
        if (this.isVisibleButton(b)) {
            this.m_visibleButtonIndex = 0;
        }
        this.m_buttons.removeElement(b);
    }

    public AbstractButton getVisibleButton(boolean needMouseListener) {
        AbstractButton theButton = (AbstractButton)this.m_buttons.elementAt(this.m_visibleButtonIndex);
        if (needMouseListener) {
            theButton.addMouseListener(this.m_mouseAdapter);
        }
        return theButton;
    }

    private AbstractButton getButton(boolean needMouseListener, int index) {
        AbstractButton theButton = (AbstractButton)this.m_buttons.elementAt(index);
        if (needMouseListener) {
            theButton.addMouseListener(this.m_mouseAdapter);
        }
        return theButton;
    }

    public void setVisibleButton(AbstractButton b) {
        int newIndex = this.m_buttons.indexOf(b);
        if (newIndex != -1) {
            this.m_visibleButtonIndex = newIndex;
        }
    }

    public boolean isVisibleButton(AbstractButton b) {
        return this.m_buttons.elementAt(this.m_visibleButtonIndex) == b;
    }

    public Enumeration getElements() {
        return this.m_buttons.elements();
    }

    public void setPositionInToolBar(int pos) {
        this.m_toolbarPositionIndex = pos;
    }

    public void setToolBar(MultiToolBar tb) {
        this.m_multiToolBar = tb;
    }

    private class MultiButtonMenuItem
    extends JMenuItem {
        private int index;

        public MultiButtonMenuItem(int i) {
            this.index = i;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

