/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.moverlayeredpane;

import jas2.util.moverlayeredpane.MovableObjectBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

class MovableArrow
extends JComponent
implements MovableObjectBorder {
    private double m1_alpha;
    private double m1_theta;
    private Point m1_start;
    private Point m1_finish;
    private MovableArrowHead m1_startArrowHead;
    private MovableArrowHead m1_finishArrowHead;
    private int m1_lineAreaWidth = 5;
    private int m1_arrowHeadBuffer = 0;

    @Override
    public int getCursor(Component c, Point p) {
        return 0;
    }

    @Override
    public void paintBorder(Component c, Graphics g) {
    }

    @Override
    public boolean isPointOverTheBorder(Component c, Point p) {
        return false;
    }

    @Override
    public Rectangle getRepaintRegion(Component c) {
        return null;
    }

    public MovableArrow(Point start, int arrowHeadDrawState, float arrowHeadLength, boolean arrowHeadFilled) {
        this(start, 10.0, arrowHeadDrawState, arrowHeadLength, arrowHeadFilled);
    }

    public MovableArrow(Point start, double alpha, int arrowHeadDrawState, float arrowHeadLength, boolean arrowHeadFilled) {
        System.out.println("MovableArrow unnested--yay!");
        this.m1_finish = this.m1_start = start;
        this.m1_alpha = alpha;
        switch (arrowHeadDrawState) {
            case 0: {
                break;
            }
            case 2: {
                this.m1_startArrowHead = new MovableArrowHead(arrowHeadLength, arrowHeadFilled, false);
                this.m1_arrowHeadBuffer = this.m1_startArrowHead.getArrowHeadBuffer();
                break;
            }
            case 1: {
                this.m1_finishArrowHead = new MovableArrowHead(arrowHeadLength, arrowHeadFilled, true);
                this.m1_arrowHeadBuffer = this.m1_finishArrowHead.getArrowHeadBuffer();
                break;
            }
            case 3: {
                this.m1_startArrowHead = new MovableArrowHead(arrowHeadLength, arrowHeadFilled, false);
                this.m1_finishArrowHead = new MovableArrowHead(arrowHeadLength, arrowHeadFilled, true);
                this.m1_arrowHeadBuffer = this.m1_startArrowHead.getArrowHeadBuffer();
                break;
            }
            default: {
                System.out.println("ERROR: illegal arrowHeadState");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public int getArrowHeadBuffer() {
        return this.m1_arrowHeadBuffer;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.contains(new Point(x, y));
    }

    @Override
    public boolean contains(Point p) {
        return this.isPointInLineArea(p) || this.m1_startArrowHead != null && this.m1_startArrowHead.contains(p) || this.m1_finishArrowHead != null && this.m1_finishArrowHead.contains(p);
    }

    public void updateStart(Point start) {
        this.m1_start = start;
    }

    public void updateFinish(Point finish) {
        this.m1_finish = finish;
    }

    public void updateThetaAndArrowHeads() {
        this.calcTheta();
        if (this.m1_startArrowHead != null) {
            this.m1_startArrowHead.recalculateArea();
        }
        if (this.m1_finishArrowHead != null) {
            this.m1_finishArrowHead.recalculateArea();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        switch (this.getQuadrant()) {
            case 1: {
                g.drawLine(this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer, this.getSize().width - this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer);
                break;
            }
            case 2: {
                g.drawLine(this.getSize().width - this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer);
                break;
            }
            case 3: {
                g.drawLine(this.getSize().width - this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer);
                break;
            }
            case 4: {
                g.drawLine(this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.getSize().width - this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer);
                break;
            }
        }
        if (this.m1_startArrowHead != null) {
            this.m1_startArrowHead.drawYourself(g);
        }
        if (this.m1_finishArrowHead != null) {
            this.m1_finishArrowHead.drawYourself(g);
        }
    }

    public int getQuadrant() {
        if (this.getXlen() >= 0) {
            if (this.getYlen() > 0) {
                return 4;
            }
            return 1;
        }
        if (this.getYlen() > 0) {
            return 3;
        }
        return 2;
    }

    private boolean isPointInLineArea(Point p) {
        int[] poly_x = new int[4];
        int[] poly_y = new int[4];
        switch (this.getQuadrant()) {
            case 1: {
                poly_x[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[0] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[1] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_x[3] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[2] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                break;
            }
            case 2: {
                poly_x[0] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[1] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[0] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[1] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_x[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                break;
            }
            case 3: {
                poly_x[0] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[1] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_x[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[3] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[2] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                break;
            }
            case 4: {
                poly_x[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_x[3] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_x[2] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                poly_y[3] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                poly_y[2] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                break;
            }
        }
        Polygon bounds = new Polygon(poly_x, poly_y, 4);
        return bounds.contains(p);
    }

    private void calcTheta() {
        int x = this.getXlen();
        int y = this.getYlen();
        if (x == 0) {
            this.m1_theta = y > 0 ? 1.5707963267948966 : 4.71238898038469;
        } else {
            this.m1_theta = Math.atan((double)y / (double)x);
            switch (this.getQuadrant()) {
                case 2: 
                case 3: {
                    this.m1_theta += Math.PI;
                    break;
                }
                case 4: {
                    this.m1_theta += Math.PI * 2;
                    break;
                }
            }
        }
    }

    public Point getStart() {
        return this.m1_start;
    }

    public Point getFinish() {
        return this.m1_finish;
    }

    private int getXlen() {
        return this.m1_finish.x - this.m1_start.x;
    }

    private int getYlen() {
        return this.m1_finish.y - this.m1_start.y;
    }

    private class MovableArrowHead {
        private Polygon m2_arrowHead;
        private double m2_len;
        private boolean m2_filled;
        private boolean m2_finish;
        private int m2_arrowHeadBuffer;

        public MovableArrowHead(double len, boolean filled, boolean finish) {
            this.m2_len = len;
            this.m2_filled = filled;
            this.m2_finish = finish;
            this.m2_arrowHeadBuffer = (int)Math.ceil(this.m2_len * Math.tan(MovableArrow.this.m1_alpha));
        }

        public int getArrowHeadBuffer() {
            return this.m2_arrowHeadBuffer;
        }

        public void recalculateArea() {
            Point pt = null;
            if (this.m2_finish) {
                switch (MovableArrow.this.getQuadrant()) {
                    case 1: {
                        pt = new Point(MovableArrow.this.getSize().width - this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                        break;
                    }
                    case 2: {
                        pt = new Point(this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                        break;
                    }
                    case 3: {
                        pt = new Point(this.m2_arrowHeadBuffer, MovableArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                        break;
                    }
                    case 4: {
                        pt = new Point(MovableArrow.this.getSize().width - this.m2_arrowHeadBuffer, MovableArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                        break;
                    }
                }
            } else {
                switch (MovableArrow.this.getQuadrant()) {
                    case 1: {
                        pt = new Point(this.m2_arrowHeadBuffer, MovableArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                        break;
                    }
                    case 2: {
                        pt = new Point(MovableArrow.this.getSize().width - this.m2_arrowHeadBuffer, MovableArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                        break;
                    }
                    case 3: {
                        pt = new Point(MovableArrow.this.getSize().width - this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                        break;
                    }
                    case 4: {
                        pt = new Point(this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                        break;
                    }
                }
            }
            double cosA = Math.cos(MovableArrow.this.m1_alpha);
            int[] xs = new int[]{pt.x, this.addOrSubtract(!this.m2_finish, pt.x, (int)(this.m2_len / Math.cos(MovableArrow.this.m1_alpha) * Math.cos(MovableArrow.this.m1_theta - MovableArrow.this.m1_alpha))), this.addOrSubtract(!this.m2_finish, pt.x, (int)(this.m2_len * Math.cos(MovableArrow.this.m1_theta))), this.addOrSubtract(!this.m2_finish, pt.x, (int)(this.m2_len / Math.cos(MovableArrow.this.m1_alpha) * Math.cos(MovableArrow.this.m1_theta + MovableArrow.this.m1_alpha)))};
            int[] ys = new int[]{pt.y, this.addOrSubtract(!this.m2_finish, pt.y, (int)(this.m2_len / Math.cos(MovableArrow.this.m1_alpha) * Math.sin(MovableArrow.this.m1_theta - MovableArrow.this.m1_alpha))), this.addOrSubtract(!this.m2_finish, pt.y, (int)(this.m2_len * Math.sin(MovableArrow.this.m1_theta))), this.addOrSubtract(!this.m2_finish, pt.y, (int)(this.m2_len / Math.cos(MovableArrow.this.m1_alpha) * Math.sin(MovableArrow.this.m1_theta + MovableArrow.this.m1_alpha)))};
            this.m2_arrowHead = new Polygon(xs, ys, 4);
        }

        public void drawYourself(Graphics g) {
            if (this.m2_filled) {
                g.fillPolygon(this.m2_arrowHead);
            } else {
                g.drawPolygon(this.m2_arrowHead);
            }
        }

        public boolean contains(Point p1) {
            return this.contains(p1.x, p1.y);
        }

        public boolean contains(int x, int y) {
            return this.m2_arrowHead != null && this.m2_arrowHead.contains(x, y);
        }

        private int addOrSubtract(boolean add, int a, int b) {
            return add ? a + b : a - b;
        }
    }
}

