/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.moverlayeredpane;

import jas2.util.moverlayeredpane.MLPObjectFactory;
import jas2.util.moverlayeredpane.MovableArrow;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class MLPArrowFactory
implements MLPObjectFactory {
    private int arrowHeadDrawState;
    private MovableArrow tempArrow;
    private boolean arrowHeadFilled;
    private float arrowHeadLength = 15.0f;
    private Point dragStart;
    private int numRepaints = 0;
    private static final int REPAINT_FUDGE_FACTOR = 10;
    private static final int FULL_REPAINT = 5;

    @Override
    public void mousePressed(MouseEvent e, JPanel p) {
        this.dragStart = e.getPoint();
        this.tempArrow = new MovableArrow(this.dragStart, this.arrowHeadDrawState, this.arrowHeadLength, this.arrowHeadFilled);
        this.tempArrow.setLocation(e.getPoint());
        p.add(this.tempArrow);
        this.tempArrow.setVisible(true);
    }

    @Override
    public void mouseDragged(MouseEvent e, JPanel p) {
        this.updateArrowSizeAndLocation(this.tempArrow, e.getPoint());
        if (++this.numRepaints % 5 == 0) {
            p.repaint();
        } else {
            p.repaint(new Rectangle(this.dragStart.x - 10, this.dragStart.y - 10, e.getPoint().x - this.dragStart.x + 20, e.getPoint().y - this.dragStart.y + 20));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e, JPanel p) {
        p.repaint();
    }

    public int getArrowHeadDrawState() {
        return this.arrowHeadDrawState;
    }

    public void setArrowHeadDrawState(int newState) {
        this.arrowHeadDrawState = newState;
    }

    public float getArrowHeadLength() {
        return this.arrowHeadLength;
    }

    public void setArrowHeadLength(float newLength) {
        this.arrowHeadLength = newLength;
    }

    public boolean getArrowHeadFillState() {
        return this.arrowHeadFilled;
    }

    public void setArrowHeadFillState(boolean newState) {
        this.arrowHeadFilled = newState;
    }

    public void showArrowConfigDialog() {
    }

    private void updateArrowSizeAndLocation(MovableArrow p_arrow, Point p_newFinish) {
        Point start = p_arrow.getStart();
        p_arrow.updateFinish(p_newFinish);
        if (start.x < p_newFinish.x) {
            if (start.y < p_newFinish.y) {
                p_arrow.setLocation(start.x, start.y);
            } else {
                p_arrow.setLocation(start.x, p_newFinish.y);
            }
        } else if (start.y < p_newFinish.y) {
            p_arrow.setLocation(p_newFinish.x, start.y);
        } else {
            p_arrow.setLocation(p_newFinish.x, p_newFinish.y);
        }
        int buf = p_arrow.getArrowHeadBuffer();
        p_arrow.setLocation(p_arrow.getLocation().x - buf, p_arrow.getLocation().y - buf);
        p_arrow.setSize(Math.abs(p_arrow.getStart().x - p_arrow.getFinish().x) + 2 * buf, Math.abs(p_arrow.getStart().y - p_arrow.getFinish().y) + 2 * buf);
        p_arrow.updateThetaAndArrowHeads();
        p_arrow.invalidate();
    }

    public static interface ArrowheadDrawStates {
        public static final int NONE = 0;
        public static final int FINISH = 1;
        public static final int START = 2;
        public static final int BOTH = 3;
    }
}

